/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * Defines a question that comprises multiple questions grouped together.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class QuestionGroupItem extends com.google.api.client.json.GenericJson {

  /**
   * The question group is a grid with rows of multiple choice questions that share the same
   * options. When `grid` is set, all questions in the group must be of kind `row`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Grid grid;

  /**
   * The image displayed within the question group above the specific questions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image image;

  /**
   * Required. A list of questions that belong in this question group. A question must only belong
   * to one group. The `kind` of the group may affect what types of questions are allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Question> questions;

  static {
    // hack to force ProGuard to consider Question used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Question.class);
  }

  /**
   * The question group is a grid with rows of multiple choice questions that share the same
   * options. When `grid` is set, all questions in the group must be of kind `row`.
   * @return value or {@code null} for none
   */
  public Grid getGrid() {
    return grid;
  }

  /**
   * The question group is a grid with rows of multiple choice questions that share the same
   * options. When `grid` is set, all questions in the group must be of kind `row`.
   * @param grid grid or {@code null} for none
   */
  public QuestionGroupItem setGrid(Grid grid) {
    this.grid = grid;
    return this;
  }

  /**
   * The image displayed within the question group above the specific questions.
   * @return value or {@code null} for none
   */
  public Image getImage() {
    return image;
  }

  /**
   * The image displayed within the question group above the specific questions.
   * @param image image or {@code null} for none
   */
  public QuestionGroupItem setImage(Image image) {
    this.image = image;
    return this;
  }

  /**
   * Required. A list of questions that belong in this question group. A question must only belong
   * to one group. The `kind` of the group may affect what types of questions are allowed.
   * @return value or {@code null} for none
   */
  public java.util.List<Question> getQuestions() {
    return questions;
  }

  /**
   * Required. A list of questions that belong in this question group. A question must only belong
   * to one group. The `kind` of the group may affect what types of questions are allowed.
   * @param questions questions or {@code null} for none
   */
  public QuestionGroupItem setQuestions(java.util.List<Question> questions) {
    this.questions = questions;
    return this;
  }

  @Override
  public QuestionGroupItem set(String fieldName, Object value) {
    return (QuestionGroupItem) super.set(fieldName, value);
  }

  @Override
  public QuestionGroupItem clone() {
    return (QuestionGroupItem) super.clone();
  }

}
