/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * Move an item in a form.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MoveItemRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. The new location for the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Location newLocation;

  /**
   * Required. The location of the item to move.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Location originalLocation;

  /**
   * Required. The new location for the item.
   * @return value or {@code null} for none
   */
  public Location getNewLocation() {
    return newLocation;
  }

  /**
   * Required. The new location for the item.
   * @param newLocation newLocation or {@code null} for none
   */
  public MoveItemRequest setNewLocation(Location newLocation) {
    this.newLocation = newLocation;
    return this;
  }

  /**
   * Required. The location of the item to move.
   * @return value or {@code null} for none
   */
  public Location getOriginalLocation() {
    return originalLocation;
  }

  /**
   * Required. The location of the item to move.
   * @param originalLocation originalLocation or {@code null} for none
   */
  public MoveItemRequest setOriginalLocation(Location originalLocation) {
    this.originalLocation = originalLocation;
    return this;
  }

  @Override
  public MoveItemRequest set(String fieldName, Object value) {
    return (MoveItemRequest) super.set(fieldName, value);
  }

  @Override
  public MoveItemRequest clone() {
    return (MoveItemRequest) super.clone();
  }

}
