/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * A single item of the form. `kind` defines which kind of item it is.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Item extends com.google.api.client.json.GenericJson {

  /**
   * The description of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Displays an image on the page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ImageItem imageItem;

  /**
   * The item ID. On creation, it can be provided but the ID must not be already used in the form.
   * If not provided, a new ID is assigned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String itemId;

  /**
   * Starts a new page with a title.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PageBreakItem pageBreakItem;

  /**
   * Poses one or more questions to the user with a single major prompt.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private QuestionGroupItem questionGroupItem;

  /**
   * Poses a question to the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private QuestionItem questionItem;

  /**
   * Displays a title and description on the page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextItem textItem;

  /**
   * The title of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * Displays a video on the page.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoItem videoItem;

  /**
   * The description of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * The description of the item.
   * @param description description or {@code null} for none
   */
  public Item setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Displays an image on the page.
   * @return value or {@code null} for none
   */
  public ImageItem getImageItem() {
    return imageItem;
  }

  /**
   * Displays an image on the page.
   * @param imageItem imageItem or {@code null} for none
   */
  public Item setImageItem(ImageItem imageItem) {
    this.imageItem = imageItem;
    return this;
  }

  /**
   * The item ID. On creation, it can be provided but the ID must not be already used in the form.
   * If not provided, a new ID is assigned.
   * @return value or {@code null} for none
   */
  public java.lang.String getItemId() {
    return itemId;
  }

  /**
   * The item ID. On creation, it can be provided but the ID must not be already used in the form.
   * If not provided, a new ID is assigned.
   * @param itemId itemId or {@code null} for none
   */
  public Item setItemId(java.lang.String itemId) {
    this.itemId = itemId;
    return this;
  }

  /**
   * Starts a new page with a title.
   * @return value or {@code null} for none
   */
  public PageBreakItem getPageBreakItem() {
    return pageBreakItem;
  }

  /**
   * Starts a new page with a title.
   * @param pageBreakItem pageBreakItem or {@code null} for none
   */
  public Item setPageBreakItem(PageBreakItem pageBreakItem) {
    this.pageBreakItem = pageBreakItem;
    return this;
  }

  /**
   * Poses one or more questions to the user with a single major prompt.
   * @return value or {@code null} for none
   */
  public QuestionGroupItem getQuestionGroupItem() {
    return questionGroupItem;
  }

  /**
   * Poses one or more questions to the user with a single major prompt.
   * @param questionGroupItem questionGroupItem or {@code null} for none
   */
  public Item setQuestionGroupItem(QuestionGroupItem questionGroupItem) {
    this.questionGroupItem = questionGroupItem;
    return this;
  }

  /**
   * Poses a question to the user.
   * @return value or {@code null} for none
   */
  public QuestionItem getQuestionItem() {
    return questionItem;
  }

  /**
   * Poses a question to the user.
   * @param questionItem questionItem or {@code null} for none
   */
  public Item setQuestionItem(QuestionItem questionItem) {
    this.questionItem = questionItem;
    return this;
  }

  /**
   * Displays a title and description on the page.
   * @return value or {@code null} for none
   */
  public TextItem getTextItem() {
    return textItem;
  }

  /**
   * Displays a title and description on the page.
   * @param textItem textItem or {@code null} for none
   */
  public Item setTextItem(TextItem textItem) {
    this.textItem = textItem;
    return this;
  }

  /**
   * The title of the item.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The title of the item.
   * @param title title or {@code null} for none
   */
  public Item setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * Displays a video on the page.
   * @return value or {@code null} for none
   */
  public VideoItem getVideoItem() {
    return videoItem;
  }

  /**
   * Displays a video on the page.
   * @param videoItem videoItem or {@code null} for none
   */
  public Item setVideoItem(VideoItem videoItem) {
    this.videoItem = videoItem;
    return this;
  }

  @Override
  public Item set(String fieldName, Object value) {
    return (Item) super.set(fieldName, value);
  }

  @Override
  public Item clone() {
    return (Item) super.clone();
  }

}
