/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * Grade information associated with a respondent's answer to a question.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Grade extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Whether the question was answered correctly or not. A zero-point score is not
   * enough to infer incorrectness, since a correctly answered question could be worth zero points.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean correct;

  /**
   * Output only. Additional feedback given for an answer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Feedback feedback;

  /**
   * Output only. The numeric score awarded for the answer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double score;

  /**
   * Output only. Whether the question was answered correctly or not. A zero-point score is not
   * enough to infer incorrectness, since a correctly answered question could be worth zero points.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCorrect() {
    return correct;
  }

  /**
   * Output only. Whether the question was answered correctly or not. A zero-point score is not
   * enough to infer incorrectness, since a correctly answered question could be worth zero points.
   * @param correct correct or {@code null} for none
   */
  public Grade setCorrect(java.lang.Boolean correct) {
    this.correct = correct;
    return this;
  }

  /**
   * Output only. Additional feedback given for an answer.
   * @return value or {@code null} for none
   */
  public Feedback getFeedback() {
    return feedback;
  }

  /**
   * Output only. Additional feedback given for an answer.
   * @param feedback feedback or {@code null} for none
   */
  public Grade setFeedback(Feedback feedback) {
    this.feedback = feedback;
    return this;
  }

  /**
   * Output only. The numeric score awarded for the answer.
   * @return value or {@code null} for none
   */
  public java.lang.Double getScore() {
    return score;
  }

  /**
   * Output only. The numeric score awarded for the answer.
   * @param score score or {@code null} for none
   */
  public Grade setScore(java.lang.Double score) {
    this.score = score;
    return this;
  }

  @Override
  public Grade set(String fieldName, Object value) {
    return (Grade) super.set(fieldName, value);
  }

  @Override
  public Grade clone() {
    return (Grade) super.clone();
  }

}
