/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * All submitted files for a FileUpload question.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FileUploadAnswers extends com.google.api.client.json.GenericJson {

  /**
   * Output only. All submitted files for a FileUpload question.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FileUploadAnswer> answers;

  static {
    // hack to force ProGuard to consider FileUploadAnswer used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FileUploadAnswer.class);
  }

  /**
   * Output only. All submitted files for a FileUpload question.
   * @return value or {@code null} for none
   */
  public java.util.List<FileUploadAnswer> getAnswers() {
    return answers;
  }

  /**
   * Output only. All submitted files for a FileUpload question.
   * @param answers answers or {@code null} for none
   */
  public FileUploadAnswers setAnswers(java.util.List<FileUploadAnswer> answers) {
    this.answers = answers;
    return this;
  }

  @Override
  public FileUploadAnswers set(String fieldName, Object value) {
    return (FileUploadAnswers) super.set(fieldName, value);
  }

  @Override
  public FileUploadAnswers clone() {
    return (FileUploadAnswers) super.clone();
  }

}
