/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * Feedback for a respondent about their response to a question.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Feedback extends com.google.api.client.json.GenericJson {

  /**
   * Additional information provided as part of the feedback, often used to point the respondent to
   * more reading and resources.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ExtraMaterial> material;

  static {
    // hack to force ProGuard to consider ExtraMaterial used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ExtraMaterial.class);
  }

  /**
   * Required. The main text of the feedback.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String text;

  /**
   * Additional information provided as part of the feedback, often used to point the respondent to
   * more reading and resources.
   * @return value or {@code null} for none
   */
  public java.util.List<ExtraMaterial> getMaterial() {
    return material;
  }

  /**
   * Additional information provided as part of the feedback, often used to point the respondent to
   * more reading and resources.
   * @param material material or {@code null} for none
   */
  public Feedback setMaterial(java.util.List<ExtraMaterial> material) {
    this.material = material;
    return this;
  }

  /**
   * Required. The main text of the feedback.
   * @return value or {@code null} for none
   */
  public java.lang.String getText() {
    return text;
  }

  /**
   * Required. The main text of the feedback.
   * @param text text or {@code null} for none
   */
  public Feedback setText(java.lang.String text) {
    this.text = text;
    return this;
  }

  @Override
  public Feedback set(String fieldName, Object value) {
    return (Feedback) super.set(fieldName, value);
  }

  @Override
  public Feedback clone() {
    return (Feedback) super.clone();
  }

}
