/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * Response to a BatchUpdateFormRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BatchUpdateFormResponse extends com.google.api.client.json.GenericJson {

  /**
   * Based on the bool request field `include_form_in_response`, a form with all applied
   * mutations/updates is returned or not. This may be later than the revision ID created by these
   * changes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Form form;

  /**
   * The reply of the updates. This maps 1:1 with the update requests, although replies to some
   * requests may be empty.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Response> replies;

  /**
   * The updated write control after applying the request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private WriteControl writeControl;

  /**
   * Based on the bool request field `include_form_in_response`, a form with all applied
   * mutations/updates is returned or not. This may be later than the revision ID created by these
   * changes.
   * @return value or {@code null} for none
   */
  public Form getForm() {
    return form;
  }

  /**
   * Based on the bool request field `include_form_in_response`, a form with all applied
   * mutations/updates is returned or not. This may be later than the revision ID created by these
   * changes.
   * @param form form or {@code null} for none
   */
  public BatchUpdateFormResponse setForm(Form form) {
    this.form = form;
    return this;
  }

  /**
   * The reply of the updates. This maps 1:1 with the update requests, although replies to some
   * requests may be empty.
   * @return value or {@code null} for none
   */
  public java.util.List<Response> getReplies() {
    return replies;
  }

  /**
   * The reply of the updates. This maps 1:1 with the update requests, although replies to some
   * requests may be empty.
   * @param replies replies or {@code null} for none
   */
  public BatchUpdateFormResponse setReplies(java.util.List<Response> replies) {
    this.replies = replies;
    return this;
  }

  /**
   * The updated write control after applying the request.
   * @return value or {@code null} for none
   */
  public WriteControl getWriteControl() {
    return writeControl;
  }

  /**
   * The updated write control after applying the request.
   * @param writeControl writeControl or {@code null} for none
   */
  public BatchUpdateFormResponse setWriteControl(WriteControl writeControl) {
    this.writeControl = writeControl;
    return this;
  }

  @Override
  public BatchUpdateFormResponse set(String fieldName, Object value) {
    return (BatchUpdateFormResponse) super.set(fieldName, value);
  }

  @Override
  public BatchUpdateFormResponse clone() {
    return (BatchUpdateFormResponse) super.clone();
  }

}
