/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * Provides control over how write requests are executed.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WriteControl extends com.google.api.client.json.GenericJson {

  /**
   * The revision ID of the form that the write request is applied to. If this is not the latest
   * revision of the form, the request is not processed and returns a 400 bad request error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requiredRevisionId;

  /**
   * The target revision ID of the form that the write request is applied to. If changes have
   * occurred after this revision, the changes in this update request are transformed against those
   * changes. This results in a new revision of the form that incorporates both the changes in the
   * request and the intervening changes, with the server resolving conflicting changes. The target
   * revision ID may only be used to write to recent versions of a form. If the target revision is
   * too far behind the latest revision, the request is not processed and returns a 400 (Bad Request
   * Error). The request may be retried after reading the latest version of the form. In most cases
   * a target revision ID remains valid for several minutes after it is read, but for frequently-
   * edited forms this window may be shorter.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetRevisionId;

  /**
   * The revision ID of the form that the write request is applied to. If this is not the latest
   * revision of the form, the request is not processed and returns a 400 bad request error.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequiredRevisionId() {
    return requiredRevisionId;
  }

  /**
   * The revision ID of the form that the write request is applied to. If this is not the latest
   * revision of the form, the request is not processed and returns a 400 bad request error.
   * @param requiredRevisionId requiredRevisionId or {@code null} for none
   */
  public WriteControl setRequiredRevisionId(java.lang.String requiredRevisionId) {
    this.requiredRevisionId = requiredRevisionId;
    return this;
  }

  /**
   * The target revision ID of the form that the write request is applied to. If changes have
   * occurred after this revision, the changes in this update request are transformed against those
   * changes. This results in a new revision of the form that incorporates both the changes in the
   * request and the intervening changes, with the server resolving conflicting changes. The target
   * revision ID may only be used to write to recent versions of a form. If the target revision is
   * too far behind the latest revision, the request is not processed and returns a 400 (Bad Request
   * Error). The request may be retried after reading the latest version of the form. In most cases
   * a target revision ID remains valid for several minutes after it is read, but for frequently-
   * edited forms this window may be shorter.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetRevisionId() {
    return targetRevisionId;
  }

  /**
   * The target revision ID of the form that the write request is applied to. If changes have
   * occurred after this revision, the changes in this update request are transformed against those
   * changes. This results in a new revision of the form that incorporates both the changes in the
   * request and the intervening changes, with the server resolving conflicting changes. The target
   * revision ID may only be used to write to recent versions of a form. If the target revision is
   * too far behind the latest revision, the request is not processed and returns a 400 (Bad Request
   * Error). The request may be retried after reading the latest version of the form. In most cases
   * a target revision ID remains valid for several minutes after it is read, but for frequently-
   * edited forms this window may be shorter.
   * @param targetRevisionId targetRevisionId or {@code null} for none
   */
  public WriteControl setTargetRevisionId(java.lang.String targetRevisionId) {
    this.targetRevisionId = targetRevisionId;
    return this;
  }

  @Override
  public WriteControl set(String fieldName, Object value) {
    return (WriteControl) super.set(fieldName, value);
  }

  @Override
  public WriteControl clone() {
    return (WriteControl) super.clone();
  }

}
