/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * An item containing a video.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VideoItem extends com.google.api.client.json.GenericJson {

  /**
   * The text displayed below the video.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String caption;

  /**
   * Required. The video displayed in the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Video video;

  /**
   * The text displayed below the video.
   * @return value or {@code null} for none
   */
  public java.lang.String getCaption() {
    return caption;
  }

  /**
   * The text displayed below the video.
   * @param caption caption or {@code null} for none
   */
  public VideoItem setCaption(java.lang.String caption) {
    this.caption = caption;
    return this;
  }

  /**
   * Required. The video displayed in the item.
   * @return value or {@code null} for none
   */
  public Video getVideo() {
    return video;
  }

  /**
   * Required. The video displayed in the item.
   * @param video video or {@code null} for none
   */
  public VideoItem setVideo(Video video) {
    this.video = video;
    return this;
  }

  @Override
  public VideoItem set(String fieldName, Object value) {
    return (VideoItem) super.set(fieldName, value);
  }

  @Override
  public VideoItem clone() {
    return (VideoItem) super.clone();
  }

}
