/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * Update an item in a form.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateItemRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. New values for the item. Note that item and question IDs are used if they are
   * provided (and are in the field mask). If an ID is blank (and in the field mask) a new ID is
   * generated. This means you can modify an item by getting the form via forms.get, modifying your
   * local copy of that item to be how you want it, and using UpdateItemRequest to write it back,
   * with the IDs being the same (or not in the field mask).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Item item;

  /**
   * Required. The location identifying the item to update.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Location location;

  /**
   * Required. Only values named in this mask are changed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateMask;

  /**
   * Required. New values for the item. Note that item and question IDs are used if they are
   * provided (and are in the field mask). If an ID is blank (and in the field mask) a new ID is
   * generated. This means you can modify an item by getting the form via forms.get, modifying your
   * local copy of that item to be how you want it, and using UpdateItemRequest to write it back,
   * with the IDs being the same (or not in the field mask).
   * @return value or {@code null} for none
   */
  public Item getItem() {
    return item;
  }

  /**
   * Required. New values for the item. Note that item and question IDs are used if they are
   * provided (and are in the field mask). If an ID is blank (and in the field mask) a new ID is
   * generated. This means you can modify an item by getting the form via forms.get, modifying your
   * local copy of that item to be how you want it, and using UpdateItemRequest to write it back,
   * with the IDs being the same (or not in the field mask).
   * @param item item or {@code null} for none
   */
  public UpdateItemRequest setItem(Item item) {
    this.item = item;
    return this;
  }

  /**
   * Required. The location identifying the item to update.
   * @return value or {@code null} for none
   */
  public Location getLocation() {
    return location;
  }

  /**
   * Required. The location identifying the item to update.
   * @param location location or {@code null} for none
   */
  public UpdateItemRequest setLocation(Location location) {
    this.location = location;
    return this;
  }

  /**
   * Required. Only values named in this mask are changed.
   * @return value or {@code null} for none
   */
  public String getUpdateMask() {
    return updateMask;
  }

  /**
   * Required. Only values named in this mask are changed.
   * @param updateMask updateMask or {@code null} for none
   */
  public UpdateItemRequest setUpdateMask(String updateMask) {
    this.updateMask = updateMask;
    return this;
  }

  @Override
  public UpdateItemRequest set(String fieldName, Object value) {
    return (UpdateItemRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateItemRequest clone() {
    return (UpdateItemRequest) super.clone();
  }

}
