/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * An answer to a question represented as text.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TextAnswer extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The answer value. Formatting used for different kinds of question: *
   * ChoiceQuestion * `RADIO` or `DROP_DOWN`: A single string corresponding to the option that was
   * selected. * `CHECKBOX`: Multiple strings corresponding to each option that was selected. *
   * TextQuestion: The text that the user entered. * ScaleQuestion: A string containing the number
   * that was selected. * DateQuestion * Without time or year: MM-DD e.g. "05-19" * With year: YYYY-
   * MM-DD e.g. "1986-05-19" * With time: MM-DD HH:MM e.g. "05-19 14:51" * With year and time: YYYY-
   * MM-DD HH:MM e.g. "1986-05-19 14:51" * TimeQuestion: String with time or duration in HH:MM
   * format e.g. "14:51" * RowQuestion within QuestionGroupItem: The answer for each row of a
   * QuestionGroupItem is represented as a separate Answer. Each will contain one string for
   * `RADIO`-type choices or multiple strings for `CHECKBOX` choices.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * Output only. The answer value. Formatting used for different kinds of question: *
   * ChoiceQuestion * `RADIO` or `DROP_DOWN`: A single string corresponding to the option that was
   * selected. * `CHECKBOX`: Multiple strings corresponding to each option that was selected. *
   * TextQuestion: The text that the user entered. * ScaleQuestion: A string containing the number
   * that was selected. * DateQuestion * Without time or year: MM-DD e.g. "05-19" * With year: YYYY-
   * MM-DD e.g. "1986-05-19" * With time: MM-DD HH:MM e.g. "05-19 14:51" * With year and time: YYYY-
   * MM-DD HH:MM e.g. "1986-05-19 14:51" * TimeQuestion: String with time or duration in HH:MM
   * format e.g. "14:51" * RowQuestion within QuestionGroupItem: The answer for each row of a
   * QuestionGroupItem is represented as a separate Answer. Each will contain one string for
   * `RADIO`-type choices or multiple strings for `CHECKBOX` choices.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * Output only. The answer value. Formatting used for different kinds of question: *
   * ChoiceQuestion * `RADIO` or `DROP_DOWN`: A single string corresponding to the option that was
   * selected. * `CHECKBOX`: Multiple strings corresponding to each option that was selected. *
   * TextQuestion: The text that the user entered. * ScaleQuestion: A string containing the number
   * that was selected. * DateQuestion * Without time or year: MM-DD e.g. "05-19" * With year: YYYY-
   * MM-DD e.g. "1986-05-19" * With time: MM-DD HH:MM e.g. "05-19 14:51" * With year and time: YYYY-
   * MM-DD HH:MM e.g. "1986-05-19 14:51" * TimeQuestion: String with time or duration in HH:MM
   * format e.g. "14:51" * RowQuestion within QuestionGroupItem: The answer for each row of a
   * QuestionGroupItem is represented as a separate Answer. Each will contain one string for
   * `RADIO`-type choices or multiple strings for `CHECKBOX` choices.
   * @param value value or {@code null} for none
   */
  public TextAnswer setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public TextAnswer set(String fieldName, Object value) {
    return (TextAnswer) super.set(fieldName, value);
  }

  @Override
  public TextAnswer clone() {
    return (TextAnswer) super.clone();
  }

}
