/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * Any question. The specific type of question is known by its `kind`.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Question extends com.google.api.client.json.GenericJson {

  /**
   * A respondent can choose from a pre-defined set of options.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ChoiceQuestion choiceQuestion;

  /**
   * A respondent can enter a date.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DateQuestion dateQuestion;

  /**
   * A respondent can upload one or more files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FileUploadQuestion fileUploadQuestion;

  /**
   * Grading setup for the question.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Grading grading;

  /**
   * Read only. The question ID. On creation, it can be provided but the ID must not be already used
   * in the form. If not provided, a new ID is assigned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String questionId;

  /**
   * Whether the question must be answered in order for a respondent to submit their response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean required;

  /**
   * A row of a QuestionGroupItem.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private RowQuestion rowQuestion;

  /**
   * A respondent can choose a number from a range.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ScaleQuestion scaleQuestion;

  /**
   * A respondent can enter a free text response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TextQuestion textQuestion;

  /**
   * A respondent can enter a time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeQuestion timeQuestion;

  /**
   * A respondent can choose from a pre-defined set of options.
   * @return value or {@code null} for none
   */
  public ChoiceQuestion getChoiceQuestion() {
    return choiceQuestion;
  }

  /**
   * A respondent can choose from a pre-defined set of options.
   * @param choiceQuestion choiceQuestion or {@code null} for none
   */
  public Question setChoiceQuestion(ChoiceQuestion choiceQuestion) {
    this.choiceQuestion = choiceQuestion;
    return this;
  }

  /**
   * A respondent can enter a date.
   * @return value or {@code null} for none
   */
  public DateQuestion getDateQuestion() {
    return dateQuestion;
  }

  /**
   * A respondent can enter a date.
   * @param dateQuestion dateQuestion or {@code null} for none
   */
  public Question setDateQuestion(DateQuestion dateQuestion) {
    this.dateQuestion = dateQuestion;
    return this;
  }

  /**
   * A respondent can upload one or more files.
   * @return value or {@code null} for none
   */
  public FileUploadQuestion getFileUploadQuestion() {
    return fileUploadQuestion;
  }

  /**
   * A respondent can upload one or more files.
   * @param fileUploadQuestion fileUploadQuestion or {@code null} for none
   */
  public Question setFileUploadQuestion(FileUploadQuestion fileUploadQuestion) {
    this.fileUploadQuestion = fileUploadQuestion;
    return this;
  }

  /**
   * Grading setup for the question.
   * @return value or {@code null} for none
   */
  public Grading getGrading() {
    return grading;
  }

  /**
   * Grading setup for the question.
   * @param grading grading or {@code null} for none
   */
  public Question setGrading(Grading grading) {
    this.grading = grading;
    return this;
  }

  /**
   * Read only. The question ID. On creation, it can be provided but the ID must not be already used
   * in the form. If not provided, a new ID is assigned.
   * @return value or {@code null} for none
   */
  public java.lang.String getQuestionId() {
    return questionId;
  }

  /**
   * Read only. The question ID. On creation, it can be provided but the ID must not be already used
   * in the form. If not provided, a new ID is assigned.
   * @param questionId questionId or {@code null} for none
   */
  public Question setQuestionId(java.lang.String questionId) {
    this.questionId = questionId;
    return this;
  }

  /**
   * Whether the question must be answered in order for a respondent to submit their response.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getRequired() {
    return required;
  }

  /**
   * Whether the question must be answered in order for a respondent to submit their response.
   * @param required required or {@code null} for none
   */
  public Question setRequired(java.lang.Boolean required) {
    this.required = required;
    return this;
  }

  /**
   * A row of a QuestionGroupItem.
   * @return value or {@code null} for none
   */
  public RowQuestion getRowQuestion() {
    return rowQuestion;
  }

  /**
   * A row of a QuestionGroupItem.
   * @param rowQuestion rowQuestion or {@code null} for none
   */
  public Question setRowQuestion(RowQuestion rowQuestion) {
    this.rowQuestion = rowQuestion;
    return this;
  }

  /**
   * A respondent can choose a number from a range.
   * @return value or {@code null} for none
   */
  public ScaleQuestion getScaleQuestion() {
    return scaleQuestion;
  }

  /**
   * A respondent can choose a number from a range.
   * @param scaleQuestion scaleQuestion or {@code null} for none
   */
  public Question setScaleQuestion(ScaleQuestion scaleQuestion) {
    this.scaleQuestion = scaleQuestion;
    return this;
  }

  /**
   * A respondent can enter a free text response.
   * @return value or {@code null} for none
   */
  public TextQuestion getTextQuestion() {
    return textQuestion;
  }

  /**
   * A respondent can enter a free text response.
   * @param textQuestion textQuestion or {@code null} for none
   */
  public Question setTextQuestion(TextQuestion textQuestion) {
    this.textQuestion = textQuestion;
    return this;
  }

  /**
   * A respondent can enter a time.
   * @return value or {@code null} for none
   */
  public TimeQuestion getTimeQuestion() {
    return timeQuestion;
  }

  /**
   * A respondent can enter a time.
   * @param timeQuestion timeQuestion or {@code null} for none
   */
  public Question setTimeQuestion(TimeQuestion timeQuestion) {
    this.timeQuestion = timeQuestion;
    return this;
  }

  @Override
  public Question set(String fieldName, Object value) {
    return (Question) super.set(fieldName, value);
  }

  @Override
  public Question clone() {
    return (Question) super.clone();
  }

}
