/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * An option for a Choice question.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Option extends com.google.api.client.json.GenericJson {

  /**
   * Section navigation type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String goToAction;

  /**
   * Item ID of section header to go to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String goToSectionId;

  /**
   * Display image as an option.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image image;

  /**
   * Whether the option is "other". Currently only applies to `RADIO` and `CHECKBOX` choice types,
   * but is not allowed in a QuestionGroupItem.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isOther;

  /**
   * Required. The choice as presented to the user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String value;

  /**
   * Section navigation type.
   * @return value or {@code null} for none
   */
  public java.lang.String getGoToAction() {
    return goToAction;
  }

  /**
   * Section navigation type.
   * @param goToAction goToAction or {@code null} for none
   */
  public Option setGoToAction(java.lang.String goToAction) {
    this.goToAction = goToAction;
    return this;
  }

  /**
   * Item ID of section header to go to.
   * @return value or {@code null} for none
   */
  public java.lang.String getGoToSectionId() {
    return goToSectionId;
  }

  /**
   * Item ID of section header to go to.
   * @param goToSectionId goToSectionId or {@code null} for none
   */
  public Option setGoToSectionId(java.lang.String goToSectionId) {
    this.goToSectionId = goToSectionId;
    return this;
  }

  /**
   * Display image as an option.
   * @return value or {@code null} for none
   */
  public Image getImage() {
    return image;
  }

  /**
   * Display image as an option.
   * @param image image or {@code null} for none
   */
  public Option setImage(Image image) {
    this.image = image;
    return this;
  }

  /**
   * Whether the option is "other". Currently only applies to `RADIO` and `CHECKBOX` choice types,
   * but is not allowed in a QuestionGroupItem.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsOther() {
    return isOther;
  }

  /**
   * Whether the option is "other". Currently only applies to `RADIO` and `CHECKBOX` choice types,
   * but is not allowed in a QuestionGroupItem.
   * @param isOther isOther or {@code null} for none
   */
  public Option setIsOther(java.lang.Boolean isOther) {
    this.isOther = isOther;
    return this;
  }

  /**
   * Required. The choice as presented to the user.
   * @return value or {@code null} for none
   */
  public java.lang.String getValue() {
    return value;
  }

  /**
   * Required. The choice as presented to the user.
   * @param value value or {@code null} for none
   */
  public Option setValue(java.lang.String value) {
    this.value = value;
    return this;
  }

  @Override
  public Option set(String fieldName, Object value) {
    return (Option) super.set(fieldName, value);
  }

  @Override
  public Option clone() {
    return (Option) super.clone();
  }

}
