/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * A form response.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FormResponse extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The actual answers to the questions, keyed by question_id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, Answer> answers;

  static {
    // hack to force ProGuard to consider Answer used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Answer.class);
  }

  /**
   * Output only. Timestamp for the first time the response was submitted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Output only. The form ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String formId;

  /**
   * Output only. Timestamp for the most recent time the response was submitted. Does not track
   * changes to grades.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String lastSubmittedTime;

  /**
   * Output only. The email address (if collected) for the respondent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String respondentEmail;

  /**
   * Output only. The response ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String responseId;

  /**
   * Output only. The total number of points the respondent received for their submission Only set
   * if the form was a quiz and the response was graded. This includes points automatically awarded
   * via autograding adjusted by any manual corrections entered by the form owner.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double totalScore;

  /**
   * Output only. The actual answers to the questions, keyed by question_id.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, Answer> getAnswers() {
    return answers;
  }

  /**
   * Output only. The actual answers to the questions, keyed by question_id.
   * @param answers answers or {@code null} for none
   */
  public FormResponse setAnswers(java.util.Map<String, Answer> answers) {
    this.answers = answers;
    return this;
  }

  /**
   * Output only. Timestamp for the first time the response was submitted.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. Timestamp for the first time the response was submitted.
   * @param createTime createTime or {@code null} for none
   */
  public FormResponse setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Output only. The form ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormId() {
    return formId;
  }

  /**
   * Output only. The form ID.
   * @param formId formId or {@code null} for none
   */
  public FormResponse setFormId(java.lang.String formId) {
    this.formId = formId;
    return this;
  }

  /**
   * Output only. Timestamp for the most recent time the response was submitted. Does not track
   * changes to grades.
   * @return value or {@code null} for none
   */
  public String getLastSubmittedTime() {
    return lastSubmittedTime;
  }

  /**
   * Output only. Timestamp for the most recent time the response was submitted. Does not track
   * changes to grades.
   * @param lastSubmittedTime lastSubmittedTime or {@code null} for none
   */
  public FormResponse setLastSubmittedTime(String lastSubmittedTime) {
    this.lastSubmittedTime = lastSubmittedTime;
    return this;
  }

  /**
   * Output only. The email address (if collected) for the respondent.
   * @return value or {@code null} for none
   */
  public java.lang.String getRespondentEmail() {
    return respondentEmail;
  }

  /**
   * Output only. The email address (if collected) for the respondent.
   * @param respondentEmail respondentEmail or {@code null} for none
   */
  public FormResponse setRespondentEmail(java.lang.String respondentEmail) {
    this.respondentEmail = respondentEmail;
    return this;
  }

  /**
   * Output only. The response ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getResponseId() {
    return responseId;
  }

  /**
   * Output only. The response ID.
   * @param responseId responseId or {@code null} for none
   */
  public FormResponse setResponseId(java.lang.String responseId) {
    this.responseId = responseId;
    return this;
  }

  /**
   * Output only. The total number of points the respondent received for their submission Only set
   * if the form was a quiz and the response was graded. This includes points automatically awarded
   * via autograding adjusted by any manual corrections entered by the form owner.
   * @return value or {@code null} for none
   */
  public java.lang.Double getTotalScore() {
    return totalScore;
  }

  /**
   * Output only. The total number of points the respondent received for their submission Only set
   * if the form was a quiz and the response was graded. This includes points automatically awarded
   * via autograding adjusted by any manual corrections entered by the form owner.
   * @param totalScore totalScore or {@code null} for none
   */
  public FormResponse setTotalScore(java.lang.Double totalScore) {
    this.totalScore = totalScore;
    return this;
  }

  @Override
  public FormResponse set(String fieldName, Object value) {
    return (FormResponse) super.set(fieldName, value);
  }

  @Override
  public FormResponse clone() {
    return (FormResponse) super.clone();
  }

}
