/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * A Google Forms document. A form is created in Drive, and deleting a form or changing its access
 * protections is done via the [Drive API](https://developers.google.com/drive/api/v3/about-sdk).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Form extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The form ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String formId;

  /**
   * Required. The title and description of the form.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Info info;

  /**
   * Required. A list of the form's items, which can include section headers, questions, embedded
   * media, etc.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Item> items;

  /**
   * Output only. The ID of the linked Google Sheet which is accumulating responses from this Form
   * (if such a Sheet exists).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String linkedSheetId;

  /**
   * Output only. The form URI to share with responders. This opens a page that allows the user to
   * submit responses but not edit the questions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String responderUri;

  /**
   * Output only. The revision ID of the form. Used in the WriteControl in update requests to
   * identify the revision on which the changes are based. The format of the revision ID may change
   * over time, so it should be treated opaquely. A returned revision ID is only guaranteed to be
   * valid for 24 hours after it has been returned and cannot be shared across users. If the
   * revision ID is unchanged between calls, then the form has not changed. Conversely, a changed ID
   * (for the same form and user) usually means the form has been updated; however, a changed ID can
   * also be due to internal factors such as ID format changes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String revisionId;

  /**
   * The form's settings. This must be updated with UpdateSettingsRequest; it is ignored during
   * `forms.create` and UpdateFormInfoRequest.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FormSettings settings;

  /**
   * Output only. The form ID.
   * @return value or {@code null} for none
   */
  public java.lang.String getFormId() {
    return formId;
  }

  /**
   * Output only. The form ID.
   * @param formId formId or {@code null} for none
   */
  public Form setFormId(java.lang.String formId) {
    this.formId = formId;
    return this;
  }

  /**
   * Required. The title and description of the form.
   * @return value or {@code null} for none
   */
  public Info getInfo() {
    return info;
  }

  /**
   * Required. The title and description of the form.
   * @param info info or {@code null} for none
   */
  public Form setInfo(Info info) {
    this.info = info;
    return this;
  }

  /**
   * Required. A list of the form's items, which can include section headers, questions, embedded
   * media, etc.
   * @return value or {@code null} for none
   */
  public java.util.List<Item> getItems() {
    return items;
  }

  /**
   * Required. A list of the form's items, which can include section headers, questions, embedded
   * media, etc.
   * @param items items or {@code null} for none
   */
  public Form setItems(java.util.List<Item> items) {
    this.items = items;
    return this;
  }

  /**
   * Output only. The ID of the linked Google Sheet which is accumulating responses from this Form
   * (if such a Sheet exists).
   * @return value or {@code null} for none
   */
  public java.lang.String getLinkedSheetId() {
    return linkedSheetId;
  }

  /**
   * Output only. The ID of the linked Google Sheet which is accumulating responses from this Form
   * (if such a Sheet exists).
   * @param linkedSheetId linkedSheetId or {@code null} for none
   */
  public Form setLinkedSheetId(java.lang.String linkedSheetId) {
    this.linkedSheetId = linkedSheetId;
    return this;
  }

  /**
   * Output only. The form URI to share with responders. This opens a page that allows the user to
   * submit responses but not edit the questions.
   * @return value or {@code null} for none
   */
  public java.lang.String getResponderUri() {
    return responderUri;
  }

  /**
   * Output only. The form URI to share with responders. This opens a page that allows the user to
   * submit responses but not edit the questions.
   * @param responderUri responderUri or {@code null} for none
   */
  public Form setResponderUri(java.lang.String responderUri) {
    this.responderUri = responderUri;
    return this;
  }

  /**
   * Output only. The revision ID of the form. Used in the WriteControl in update requests to
   * identify the revision on which the changes are based. The format of the revision ID may change
   * over time, so it should be treated opaquely. A returned revision ID is only guaranteed to be
   * valid for 24 hours after it has been returned and cannot be shared across users. If the
   * revision ID is unchanged between calls, then the form has not changed. Conversely, a changed ID
   * (for the same form and user) usually means the form has been updated; however, a changed ID can
   * also be due to internal factors such as ID format changes.
   * @return value or {@code null} for none
   */
  public java.lang.String getRevisionId() {
    return revisionId;
  }

  /**
   * Output only. The revision ID of the form. Used in the WriteControl in update requests to
   * identify the revision on which the changes are based. The format of the revision ID may change
   * over time, so it should be treated opaquely. A returned revision ID is only guaranteed to be
   * valid for 24 hours after it has been returned and cannot be shared across users. If the
   * revision ID is unchanged between calls, then the form has not changed. Conversely, a changed ID
   * (for the same form and user) usually means the form has been updated; however, a changed ID can
   * also be due to internal factors such as ID format changes.
   * @param revisionId revisionId or {@code null} for none
   */
  public Form setRevisionId(java.lang.String revisionId) {
    this.revisionId = revisionId;
    return this;
  }

  /**
   * The form's settings. This must be updated with UpdateSettingsRequest; it is ignored during
   * `forms.create` and UpdateFormInfoRequest.
   * @return value or {@code null} for none
   */
  public FormSettings getSettings() {
    return settings;
  }

  /**
   * The form's settings. This must be updated with UpdateSettingsRequest; it is ignored during
   * `forms.create` and UpdateFormInfoRequest.
   * @param settings settings or {@code null} for none
   */
  public Form setSettings(FormSettings settings) {
    this.settings = settings;
    return this;
  }

  @Override
  public Form set(String fieldName, Object value) {
    return (Form) super.set(fieldName, value);
  }

  @Override
  public Form clone() {
    return (Form) super.clone();
  }

}
