/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * A file upload question. The API currently does not support creating file upload questions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FileUploadQuestion extends com.google.api.client.json.GenericJson {

  /**
   * Required. The ID of the Drive folder where uploaded files are stored.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String folderId;

  /**
   * Maximum number of bytes allowed for any single file uploaded to this question.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxFileSize;

  /**
   * Maximum number of files that can be uploaded for this question in a single response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxFiles;

  /**
   * File types accepted by this question.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> types;

  /**
   * Required. The ID of the Drive folder where uploaded files are stored.
   * @return value or {@code null} for none
   */
  public java.lang.String getFolderId() {
    return folderId;
  }

  /**
   * Required. The ID of the Drive folder where uploaded files are stored.
   * @param folderId folderId or {@code null} for none
   */
  public FileUploadQuestion setFolderId(java.lang.String folderId) {
    this.folderId = folderId;
    return this;
  }

  /**
   * Maximum number of bytes allowed for any single file uploaded to this question.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxFileSize() {
    return maxFileSize;
  }

  /**
   * Maximum number of bytes allowed for any single file uploaded to this question.
   * @param maxFileSize maxFileSize or {@code null} for none
   */
  public FileUploadQuestion setMaxFileSize(java.lang.Long maxFileSize) {
    this.maxFileSize = maxFileSize;
    return this;
  }

  /**
   * Maximum number of files that can be uploaded for this question in a single response.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxFiles() {
    return maxFiles;
  }

  /**
   * Maximum number of files that can be uploaded for this question in a single response.
   * @param maxFiles maxFiles or {@code null} for none
   */
  public FileUploadQuestion setMaxFiles(java.lang.Integer maxFiles) {
    this.maxFiles = maxFiles;
    return this;
  }

  /**
   * File types accepted by this question.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getTypes() {
    return types;
  }

  /**
   * File types accepted by this question.
   * @param types types or {@code null} for none
   */
  public FileUploadQuestion setTypes(java.util.List<java.lang.String> types) {
    this.types = types;
    return this;
  }

  @Override
  public FileUploadQuestion set(String fieldName, Object value) {
    return (FileUploadQuestion) super.set(fieldName, value);
  }

  @Override
  public FileUploadQuestion clone() {
    return (FileUploadQuestion) super.clone();
  }

}
