/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * Create an item in a form.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreateItemRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. The item to create.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Item item;

  /**
   * Required. Where to place the new item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Location location;

  /**
   * Required. The item to create.
   * @return value or {@code null} for none
   */
  public Item getItem() {
    return item;
  }

  /**
   * Required. The item to create.
   * @param item item or {@code null} for none
   */
  public CreateItemRequest setItem(Item item) {
    this.item = item;
    return this;
  }

  /**
   * Required. Where to place the new item.
   * @return value or {@code null} for none
   */
  public Location getLocation() {
    return location;
  }

  /**
   * Required. Where to place the new item.
   * @param location location or {@code null} for none
   */
  public CreateItemRequest setLocation(Location location) {
    this.location = location;
    return this;
  }

  @Override
  public CreateItemRequest set(String fieldName, Object value) {
    return (CreateItemRequest) super.set(fieldName, value);
  }

  @Override
  public CreateItemRequest clone() {
    return (CreateItemRequest) super.clone();
  }

}
