/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * The answer key for a question.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CorrectAnswers extends com.google.api.client.json.GenericJson {

  /**
   * A list of correct answers. A quiz response can be automatically graded based on these answers.
   * For single-valued questions, a response is marked correct if it matches any value in this list
   * (in other words, multiple correct answers are possible). For multiple-valued (`CHECKBOX`)
   * questions, a response is marked correct if it contains exactly the values in this list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CorrectAnswer> answers;

  static {
    // hack to force ProGuard to consider CorrectAnswer used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(CorrectAnswer.class);
  }

  /**
   * A list of correct answers. A quiz response can be automatically graded based on these answers.
   * For single-valued questions, a response is marked correct if it matches any value in this list
   * (in other words, multiple correct answers are possible). For multiple-valued (`CHECKBOX`)
   * questions, a response is marked correct if it contains exactly the values in this list.
   * @return value or {@code null} for none
   */
  public java.util.List<CorrectAnswer> getAnswers() {
    return answers;
  }

  /**
   * A list of correct answers. A quiz response can be automatically graded based on these answers.
   * For single-valued questions, a response is marked correct if it matches any value in this list
   * (in other words, multiple correct answers are possible). For multiple-valued (`CHECKBOX`)
   * questions, a response is marked correct if it contains exactly the values in this list.
   * @param answers answers or {@code null} for none
   */
  public CorrectAnswers setAnswers(java.util.List<CorrectAnswer> answers) {
    this.answers = answers;
    return this;
  }

  @Override
  public CorrectAnswers set(String fieldName, Object value) {
    return (CorrectAnswers) super.set(fieldName, value);
  }

  @Override
  public CorrectAnswers clone() {
    return (CorrectAnswers) super.clone();
  }

}
