/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * A Pub/Sub topic.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CloudPubsubTopic extends com.google.api.client.json.GenericJson {

  /**
   * Required. A fully qualified Pub/Sub topic name to publish the events to. This topic must be
   * owned by the calling project and already exist in Pub/Sub.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String topicName;

  /**
   * Required. A fully qualified Pub/Sub topic name to publish the events to. This topic must be
   * owned by the calling project and already exist in Pub/Sub.
   * @return value or {@code null} for none
   */
  public java.lang.String getTopicName() {
    return topicName;
  }

  /**
   * Required. A fully qualified Pub/Sub topic name to publish the events to. This topic must be
   * owned by the calling project and already exist in Pub/Sub.
   * @param topicName topicName or {@code null} for none
   */
  public CloudPubsubTopic setTopicName(java.lang.String topicName) {
    this.topicName = topicName;
    return this;
  }

  @Override
  public CloudPubsubTopic set(String fieldName, Object value) {
    return (CloudPubsubTopic) super.set(fieldName, value);
  }

  @Override
  public CloudPubsubTopic clone() {
    return (CloudPubsubTopic) super.clone();
  }

}
