/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * A batch of updates to perform on a form. All the specified updates are made or none of them are.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BatchUpdateFormRequest extends com.google.api.client.json.GenericJson {

  /**
   * Whether to return an updated version of the model in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean includeFormInResponse;

  /**
   * Required. The update requests of this batch.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Request> requests;

  /**
   * Provides control over how write requests are executed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private WriteControl writeControl;

  /**
   * Whether to return an updated version of the model in the response.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIncludeFormInResponse() {
    return includeFormInResponse;
  }

  /**
   * Whether to return an updated version of the model in the response.
   * @param includeFormInResponse includeFormInResponse or {@code null} for none
   */
  public BatchUpdateFormRequest setIncludeFormInResponse(java.lang.Boolean includeFormInResponse) {
    this.includeFormInResponse = includeFormInResponse;
    return this;
  }

  /**
   * Required. The update requests of this batch.
   * @return value or {@code null} for none
   */
  public java.util.List<Request> getRequests() {
    return requests;
  }

  /**
   * Required. The update requests of this batch.
   * @param requests requests or {@code null} for none
   */
  public BatchUpdateFormRequest setRequests(java.util.List<Request> requests) {
    this.requests = requests;
    return this;
  }

  /**
   * Provides control over how write requests are executed.
   * @return value or {@code null} for none
   */
  public WriteControl getWriteControl() {
    return writeControl;
  }

  /**
   * Provides control over how write requests are executed.
   * @param writeControl writeControl or {@code null} for none
   */
  public BatchUpdateFormRequest setWriteControl(WriteControl writeControl) {
    this.writeControl = writeControl;
    return this;
  }

  @Override
  public BatchUpdateFormRequest set(String fieldName, Object value) {
    return (BatchUpdateFormRequest) super.set(fieldName, value);
  }

  @Override
  public BatchUpdateFormRequest clone() {
    return (BatchUpdateFormRequest) super.clone();
  }

}
