/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1;

/**
 * Service definition for Forms (v1).
 *
 * <p>
 * Reads and writes Google Forms and responses.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/forms/api" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link FormsRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Forms extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1)),
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "1.32.1 of the Google Forms API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://forms.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://forms.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Forms(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Forms(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the FormsOperations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Forms forms = new Forms(...);}
   *   {@code Forms.FormsOperations.List request = forms.forms().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public FormsOperations forms() {
    return new FormsOperations();
  }

  /**
   * The "forms" collection of methods.
   */
  public class FormsOperations {

    /**
     * Change the form with a batch of updates.
     *
     * Create a request for the method "forms.batchUpdate".
     *
     * This request holds the parameters needed by the forms server.  After setting any optional
     * parameters, call the {@link BatchUpdate#execute()} method to invoke the remote operation.
     *
     * @param formId Required. The form ID.
     * @param content the {@link com.google.api.services.forms.v1.model.BatchUpdateFormRequest}
     * @return the request
     */
    public BatchUpdate batchUpdate(java.lang.String formId, com.google.api.services.forms.v1.model.BatchUpdateFormRequest content) throws java.io.IOException {
      BatchUpdate result = new BatchUpdate(formId, content);
      initialize(result);
      return result;
    }

    public class BatchUpdate extends FormsRequest<com.google.api.services.forms.v1.model.BatchUpdateFormResponse> {

      private static final String REST_PATH = "v1/forms/{formId}:batchUpdate";

      /**
       * Change the form with a batch of updates.
       *
       * Create a request for the method "forms.batchUpdate".
       *
       * This request holds the parameters needed by the the forms server.  After setting any optional
       * parameters, call the {@link BatchUpdate#execute()} method to invoke the remote operation. <p>
       * {@link
       * BatchUpdate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param formId Required. The form ID.
       * @param content the {@link com.google.api.services.forms.v1.model.BatchUpdateFormRequest}
       * @since 1.13
       */
      protected BatchUpdate(java.lang.String formId, com.google.api.services.forms.v1.model.BatchUpdateFormRequest content) {
        super(Forms.this, "POST", REST_PATH, content, com.google.api.services.forms.v1.model.BatchUpdateFormResponse.class);
        this.formId = com.google.api.client.util.Preconditions.checkNotNull(formId, "Required parameter formId must be specified.");
      }

      @Override
      public BatchUpdate set$Xgafv(java.lang.String $Xgafv) {
        return (BatchUpdate) super.set$Xgafv($Xgafv);
      }

      @Override
      public BatchUpdate setAccessToken(java.lang.String accessToken) {
        return (BatchUpdate) super.setAccessToken(accessToken);
      }

      @Override
      public BatchUpdate setAlt(java.lang.String alt) {
        return (BatchUpdate) super.setAlt(alt);
      }

      @Override
      public BatchUpdate setCallback(java.lang.String callback) {
        return (BatchUpdate) super.setCallback(callback);
      }

      @Override
      public BatchUpdate setFields(java.lang.String fields) {
        return (BatchUpdate) super.setFields(fields);
      }

      @Override
      public BatchUpdate setKey(java.lang.String key) {
        return (BatchUpdate) super.setKey(key);
      }

      @Override
      public BatchUpdate setOauthToken(java.lang.String oauthToken) {
        return (BatchUpdate) super.setOauthToken(oauthToken);
      }

      @Override
      public BatchUpdate setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (BatchUpdate) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public BatchUpdate setQuotaUser(java.lang.String quotaUser) {
        return (BatchUpdate) super.setQuotaUser(quotaUser);
      }

      @Override
      public BatchUpdate setUploadType(java.lang.String uploadType) {
        return (BatchUpdate) super.setUploadType(uploadType);
      }

      @Override
      public BatchUpdate setUploadProtocol(java.lang.String uploadProtocol) {
        return (BatchUpdate) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The form ID. */
      @com.google.api.client.util.Key
      private java.lang.String formId;

      /** Required. The form ID.
       */
      public java.lang.String getFormId() {
        return formId;
      }

      /** Required. The form ID. */
      public BatchUpdate setFormId(java.lang.String formId) {
        this.formId = formId;
        return this;
      }

      @Override
      public BatchUpdate set(String parameterName, Object value) {
        return (BatchUpdate) super.set(parameterName, value);
      }
    }
    /**
     * Create a new form using the title given in the provided form message in the request. *Important:*
     * Only the form.info.title and form.info.document_title fields are copied to the new form. All
     * other fields including the form description, items and settings are disallowed. To create a new
     * form and add items, you must first call forms.create to create an empty form with a title and
     * (optional) document title, and then call forms.update to add the items.
     *
     * Create a request for the method "forms.create".
     *
     * This request holds the parameters needed by the forms server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.forms.v1.model.Form}
     * @return the request
     */
    public Create create(com.google.api.services.forms.v1.model.Form content) throws java.io.IOException {
      Create result = new Create(content);
      initialize(result);
      return result;
    }

    public class Create extends FormsRequest<com.google.api.services.forms.v1.model.Form> {

      private static final String REST_PATH = "v1/forms";

      /**
       * Create a new form using the title given in the provided form message in the request.
       * *Important:* Only the form.info.title and form.info.document_title fields are copied to the new
       * form. All other fields including the form description, items and settings are disallowed. To
       * create a new form and add items, you must first call forms.create to create an empty form with
       * a title and (optional) document title, and then call forms.update to add the items.
       *
       * Create a request for the method "forms.create".
       *
       * This request holds the parameters needed by the the forms server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.forms.v1.model.Form}
       * @since 1.13
       */
      protected Create(com.google.api.services.forms.v1.model.Form content) {
        super(Forms.this, "POST", REST_PATH, content, com.google.api.services.forms.v1.model.Form.class);
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Get a form.
     *
     * Create a request for the method "forms.get".
     *
     * This request holds the parameters needed by the forms server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param formId Required. The form ID.
     * @return the request
     */
    public Get get(java.lang.String formId) throws java.io.IOException {
      Get result = new Get(formId);
      initialize(result);
      return result;
    }

    public class Get extends FormsRequest<com.google.api.services.forms.v1.model.Form> {

      private static final String REST_PATH = "v1/forms/{formId}";

      /**
       * Get a form.
       *
       * Create a request for the method "forms.get".
       *
       * This request holds the parameters needed by the the forms server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param formId Required. The form ID.
       * @since 1.13
       */
      protected Get(java.lang.String formId) {
        super(Forms.this, "GET", REST_PATH, null, com.google.api.services.forms.v1.model.Form.class);
        this.formId = com.google.api.client.util.Preconditions.checkNotNull(formId, "Required parameter formId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The form ID. */
      @com.google.api.client.util.Key
      private java.lang.String formId;

      /** Required. The form ID.
       */
      public java.lang.String getFormId() {
        return formId;
      }

      /** Required. The form ID. */
      public Get setFormId(java.lang.String formId) {
        this.formId = formId;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the Responses collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Forms forms = new Forms(...);}
     *   {@code Forms.Responses.List request = forms.responses().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Responses responses() {
      return new Responses();
    }

    /**
     * The "responses" collection of methods.
     */
    public class Responses {

      /**
       * Get one response from the form.
       *
       * Create a request for the method "responses.get".
       *
       * This request holds the parameters needed by the forms server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param formId Required. The form ID.
       * @param responseId Required. The response ID within the form.
       * @return the request
       */
      public Get get(java.lang.String formId, java.lang.String responseId) throws java.io.IOException {
        Get result = new Get(formId, responseId);
        initialize(result);
        return result;
      }

      public class Get extends FormsRequest<com.google.api.services.forms.v1.model.FormResponse> {

        private static final String REST_PATH = "v1/forms/{formId}/responses/{responseId}";

        /**
         * Get one response from the form.
         *
         * Create a request for the method "responses.get".
         *
         * This request holds the parameters needed by the the forms server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
         * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param formId Required. The form ID.
         * @param responseId Required. The response ID within the form.
         * @since 1.13
         */
        protected Get(java.lang.String formId, java.lang.String responseId) {
          super(Forms.this, "GET", REST_PATH, null, com.google.api.services.forms.v1.model.FormResponse.class);
          this.formId = com.google.api.client.util.Preconditions.checkNotNull(formId, "Required parameter formId must be specified.");
          this.responseId = com.google.api.client.util.Preconditions.checkNotNull(responseId, "Required parameter responseId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The form ID. */
        @com.google.api.client.util.Key
        private java.lang.String formId;

        /** Required. The form ID.
         */
        public java.lang.String getFormId() {
          return formId;
        }

        /** Required. The form ID. */
        public Get setFormId(java.lang.String formId) {
          this.formId = formId;
          return this;
        }

        /** Required. The response ID within the form. */
        @com.google.api.client.util.Key
        private java.lang.String responseId;

        /** Required. The response ID within the form.
         */
        public java.lang.String getResponseId() {
          return responseId;
        }

        /** Required. The response ID within the form. */
        public Get setResponseId(java.lang.String responseId) {
          this.responseId = responseId;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * List a form's responses.
       *
       * Create a request for the method "responses.list".
       *
       * This request holds the parameters needed by the forms server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param formId Required. ID of the Form whose responses to list.
       * @return the request
       */
      public List list(java.lang.String formId) throws java.io.IOException {
        List result = new List(formId);
        initialize(result);
        return result;
      }

      public class List extends FormsRequest<com.google.api.services.forms.v1.model.ListFormResponsesResponse> {

        private static final String REST_PATH = "v1/forms/{formId}/responses";

        /**
         * List a form's responses.
         *
         * Create a request for the method "responses.list".
         *
         * This request holds the parameters needed by the the forms server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param formId Required. ID of the Form whose responses to list.
         * @since 1.13
         */
        protected List(java.lang.String formId) {
          super(Forms.this, "GET", REST_PATH, null, com.google.api.services.forms.v1.model.ListFormResponsesResponse.class);
          this.formId = com.google.api.client.util.Preconditions.checkNotNull(formId, "Required parameter formId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. ID of the Form whose responses to list. */
        @com.google.api.client.util.Key
        private java.lang.String formId;

        /** Required. ID of the Form whose responses to list.
         */
        public java.lang.String getFormId() {
          return formId;
        }

        /** Required. ID of the Form whose responses to list. */
        public List setFormId(java.lang.String formId) {
          this.formId = formId;
          return this;
        }

        /**
         * Which form responses to return. Currently, the only supported filters are: * timestamp >
         * *N* which means to get all form responses submitted after (but not at) timestamp *N*. *
         * timestamp >= *N* which means to get all form responses submitted at and after timestamp
         * *N*. For both supported filters, timestamp must be formatted in RFC3339 UTC "Zulu"
         * format. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
         */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** Which form responses to return. Currently, the only supported filters are: * timestamp > *N* which
       means to get all form responses submitted after (but not at) timestamp *N*. * timestamp >= *N*
       which means to get all form responses submitted at and after timestamp *N*. For both supported
       filters, timestamp must be formatted in RFC3339 UTC "Zulu" format. Examples: "2014-10-02T15:01:23Z"
       and "2014-10-02T15:01:23.045123456Z".
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /**
         * Which form responses to return. Currently, the only supported filters are: * timestamp >
         * *N* which means to get all form responses submitted after (but not at) timestamp *N*. *
         * timestamp >= *N* which means to get all form responses submitted at and after timestamp
         * *N*. For both supported filters, timestamp must be formatted in RFC3339 UTC "Zulu"
         * format. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
         */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        /**
         * The maximum number of responses to return. The service may return fewer than this value.
         * If unspecified or zero, at most 5000 responses are returned.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** The maximum number of responses to return. The service may return fewer than this value. If
       unspecified or zero, at most 5000 responses are returned.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * The maximum number of responses to return. The service may return fewer than this value.
         * If unspecified or zero, at most 5000 responses are returned.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * A page token returned by a previous list response. If this field is set, the form and the
         * values of the filter must be the same as for the original request.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** A page token returned by a previous list response. If this field is set, the form and the values of
       the filter must be the same as for the original request.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * A page token returned by a previous list response. If this field is set, the form and the
         * values of the filter must be the same as for the original request.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Watches collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code Forms forms = new Forms(...);}
     *   {@code Forms.Watches.List request = forms.watches().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Watches watches() {
      return new Watches();
    }

    /**
     * The "watches" collection of methods.
     */
    public class Watches {

      /**
       * Create a new watch. If a watch ID is provided, it must be unused. For each invoking project, the
       * per form limit is one watch per Watch.EventType. A watch expires seven days after it is created
       * (see Watch.expire_time).
       *
       * Create a request for the method "watches.create".
       *
       * This request holds the parameters needed by the forms server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param formId Required. ID of the Form to watch.
       * @param content the {@link com.google.api.services.forms.v1.model.CreateWatchRequest}
       * @return the request
       */
      public Create create(java.lang.String formId, com.google.api.services.forms.v1.model.CreateWatchRequest content) throws java.io.IOException {
        Create result = new Create(formId, content);
        initialize(result);
        return result;
      }

      public class Create extends FormsRequest<com.google.api.services.forms.v1.model.Watch> {

        private static final String REST_PATH = "v1/forms/{formId}/watches";

        /**
         * Create a new watch. If a watch ID is provided, it must be unused. For each invoking project,
         * the per form limit is one watch per Watch.EventType. A watch expires seven days after it is
         * created (see Watch.expire_time).
         *
         * Create a request for the method "watches.create".
         *
         * This request holds the parameters needed by the the forms server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param formId Required. ID of the Form to watch.
         * @param content the {@link com.google.api.services.forms.v1.model.CreateWatchRequest}
         * @since 1.13
         */
        protected Create(java.lang.String formId, com.google.api.services.forms.v1.model.CreateWatchRequest content) {
          super(Forms.this, "POST", REST_PATH, content, com.google.api.services.forms.v1.model.Watch.class);
          this.formId = com.google.api.client.util.Preconditions.checkNotNull(formId, "Required parameter formId must be specified.");
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. ID of the Form to watch. */
        @com.google.api.client.util.Key
        private java.lang.String formId;

        /** Required. ID of the Form to watch.
         */
        public java.lang.String getFormId() {
          return formId;
        }

        /** Required. ID of the Form to watch. */
        public Create setFormId(java.lang.String formId) {
          this.formId = formId;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Delete a watch.
       *
       * Create a request for the method "watches.delete".
       *
       * This request holds the parameters needed by the forms server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param formId Required. The ID of the Form.
       * @param watchId Required. The ID of the Watch to delete.
       * @return the request
       */
      public Delete delete(java.lang.String formId, java.lang.String watchId) throws java.io.IOException {
        Delete result = new Delete(formId, watchId);
        initialize(result);
        return result;
      }

      public class Delete extends FormsRequest<com.google.api.services.forms.v1.model.Empty> {

        private static final String REST_PATH = "v1/forms/{formId}/watches/{watchId}";

        /**
         * Delete a watch.
         *
         * Create a request for the method "watches.delete".
         *
         * This request holds the parameters needed by the the forms server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param formId Required. The ID of the Form.
         * @param watchId Required. The ID of the Watch to delete.
         * @since 1.13
         */
        protected Delete(java.lang.String formId, java.lang.String watchId) {
          super(Forms.this, "DELETE", REST_PATH, null, com.google.api.services.forms.v1.model.Empty.class);
          this.formId = com.google.api.client.util.Preconditions.checkNotNull(formId, "Required parameter formId must be specified.");
          this.watchId = com.google.api.client.util.Preconditions.checkNotNull(watchId, "Required parameter watchId must be specified.");
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The ID of the Form. */
        @com.google.api.client.util.Key
        private java.lang.String formId;

        /** Required. The ID of the Form.
         */
        public java.lang.String getFormId() {
          return formId;
        }

        /** Required. The ID of the Form. */
        public Delete setFormId(java.lang.String formId) {
          this.formId = formId;
          return this;
        }

        /** Required. The ID of the Watch to delete. */
        @com.google.api.client.util.Key
        private java.lang.String watchId;

        /** Required. The ID of the Watch to delete.
         */
        public java.lang.String getWatchId() {
          return watchId;
        }

        /** Required. The ID of the Watch to delete. */
        public Delete setWatchId(java.lang.String watchId) {
          this.watchId = watchId;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Return a list of the watches owned by the invoking project. The maximum number of watches is two:
       * For each invoker, the limit is one for each event type per form.
       *
       * Create a request for the method "watches.list".
       *
       * This request holds the parameters needed by the forms server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param formId Required. ID of the Form whose watches to list.
       * @return the request
       */
      public List list(java.lang.String formId) throws java.io.IOException {
        List result = new List(formId);
        initialize(result);
        return result;
      }

      public class List extends FormsRequest<com.google.api.services.forms.v1.model.ListWatchesResponse> {

        private static final String REST_PATH = "v1/forms/{formId}/watches";

        /**
         * Return a list of the watches owned by the invoking project. The maximum number of watches is
         * two: For each invoker, the limit is one for each event type per form.
         *
         * Create a request for the method "watches.list".
         *
         * This request holds the parameters needed by the the forms server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param formId Required. ID of the Form whose watches to list.
         * @since 1.13
         */
        protected List(java.lang.String formId) {
          super(Forms.this, "GET", REST_PATH, null, com.google.api.services.forms.v1.model.ListWatchesResponse.class);
          this.formId = com.google.api.client.util.Preconditions.checkNotNull(formId, "Required parameter formId must be specified.");
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. ID of the Form whose watches to list. */
        @com.google.api.client.util.Key
        private java.lang.String formId;

        /** Required. ID of the Form whose watches to list.
         */
        public java.lang.String getFormId() {
          return formId;
        }

        /** Required. ID of the Form whose watches to list. */
        public List setFormId(java.lang.String formId) {
          this.formId = formId;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Renew an existing watch for seven days. The state of the watch after renewal is `ACTIVE`, and the
       * `expire_time` is seven days from the renewal. Renewing a watch in an error state (e.g.
       * `SUSPENDED`) succeeds if the error is no longer present, but fail otherwise. After a watch has
       * expired, RenewWatch returns `NOT_FOUND`.
       *
       * Create a request for the method "watches.renew".
       *
       * This request holds the parameters needed by the forms server.  After setting any optional
       * parameters, call the {@link Renew#execute()} method to invoke the remote operation.
       *
       * @param formId Required. The ID of the Form.
       * @param watchId Required. The ID of the Watch to renew.
       * @param content the {@link com.google.api.services.forms.v1.model.RenewWatchRequest}
       * @return the request
       */
      public Renew renew(java.lang.String formId, java.lang.String watchId, com.google.api.services.forms.v1.model.RenewWatchRequest content) throws java.io.IOException {
        Renew result = new Renew(formId, watchId, content);
        initialize(result);
        return result;
      }

      public class Renew extends FormsRequest<com.google.api.services.forms.v1.model.Watch> {

        private static final String REST_PATH = "v1/forms/{formId}/watches/{watchId}:renew";

        /**
         * Renew an existing watch for seven days. The state of the watch after renewal is `ACTIVE`, and
         * the `expire_time` is seven days from the renewal. Renewing a watch in an error state (e.g.
         * `SUSPENDED`) succeeds if the error is no longer present, but fail otherwise. After a watch has
         * expired, RenewWatch returns `NOT_FOUND`.
         *
         * Create a request for the method "watches.renew".
         *
         * This request holds the parameters needed by the the forms server.  After setting any optional
         * parameters, call the {@link Renew#execute()} method to invoke the remote operation. <p> {@link
         * Renew#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param formId Required. The ID of the Form.
         * @param watchId Required. The ID of the Watch to renew.
         * @param content the {@link com.google.api.services.forms.v1.model.RenewWatchRequest}
         * @since 1.13
         */
        protected Renew(java.lang.String formId, java.lang.String watchId, com.google.api.services.forms.v1.model.RenewWatchRequest content) {
          super(Forms.this, "POST", REST_PATH, content, com.google.api.services.forms.v1.model.Watch.class);
          this.formId = com.google.api.client.util.Preconditions.checkNotNull(formId, "Required parameter formId must be specified.");
          this.watchId = com.google.api.client.util.Preconditions.checkNotNull(watchId, "Required parameter watchId must be specified.");
        }

        @Override
        public Renew set$Xgafv(java.lang.String $Xgafv) {
          return (Renew) super.set$Xgafv($Xgafv);
        }

        @Override
        public Renew setAccessToken(java.lang.String accessToken) {
          return (Renew) super.setAccessToken(accessToken);
        }

        @Override
        public Renew setAlt(java.lang.String alt) {
          return (Renew) super.setAlt(alt);
        }

        @Override
        public Renew setCallback(java.lang.String callback) {
          return (Renew) super.setCallback(callback);
        }

        @Override
        public Renew setFields(java.lang.String fields) {
          return (Renew) super.setFields(fields);
        }

        @Override
        public Renew setKey(java.lang.String key) {
          return (Renew) super.setKey(key);
        }

        @Override
        public Renew setOauthToken(java.lang.String oauthToken) {
          return (Renew) super.setOauthToken(oauthToken);
        }

        @Override
        public Renew setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Renew) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Renew setQuotaUser(java.lang.String quotaUser) {
          return (Renew) super.setQuotaUser(quotaUser);
        }

        @Override
        public Renew setUploadType(java.lang.String uploadType) {
          return (Renew) super.setUploadType(uploadType);
        }

        @Override
        public Renew setUploadProtocol(java.lang.String uploadProtocol) {
          return (Renew) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The ID of the Form. */
        @com.google.api.client.util.Key
        private java.lang.String formId;

        /** Required. The ID of the Form.
         */
        public java.lang.String getFormId() {
          return formId;
        }

        /** Required. The ID of the Form. */
        public Renew setFormId(java.lang.String formId) {
          this.formId = formId;
          return this;
        }

        /** Required. The ID of the Watch to renew. */
        @com.google.api.client.util.Key
        private java.lang.String watchId;

        /** Required. The ID of the Watch to renew.
         */
        public java.lang.String getWatchId() {
          return watchId;
        }

        /** Required. The ID of the Watch to renew. */
        public Renew setWatchId(java.lang.String watchId) {
          this.watchId = watchId;
          return this;
        }

        @Override
        public Renew set(String parameterName, Object value) {
          return (Renew) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link Forms}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Forms}. */
    @Override
    public Forms build() {
      return new Forms(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link FormsRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setFormsRequestInitializer(
        FormsRequestInitializer formsRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(formsRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
