/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * The target for notification delivery.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class WatchTarget extends com.google.api.client.json.GenericJson {

  /**
   * A Pub/Sub topic. To receive notifications, the topic must grant publish privileges to the Forms
   * service account `serviceAccount:forms-notifications@system.gserviceaccount.com`. Only the
   * project that owns a topic may create a watch with it. Pub/Sub delivery guarantees should be
   * considered.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CloudPubsubTopic topic;

  /**
   * A Pub/Sub topic. To receive notifications, the topic must grant publish privileges to the Forms
   * service account `serviceAccount:forms-notifications@system.gserviceaccount.com`. Only the
   * project that owns a topic may create a watch with it. Pub/Sub delivery guarantees should be
   * considered.
   * @return value or {@code null} for none
   */
  public CloudPubsubTopic getTopic() {
    return topic;
  }

  /**
   * A Pub/Sub topic. To receive notifications, the topic must grant publish privileges to the Forms
   * service account `serviceAccount:forms-notifications@system.gserviceaccount.com`. Only the
   * project that owns a topic may create a watch with it. Pub/Sub delivery guarantees should be
   * considered.
   * @param topic topic or {@code null} for none
   */
  public WatchTarget setTopic(CloudPubsubTopic topic) {
    this.topic = topic;
    return this;
  }

  @Override
  public WatchTarget set(String fieldName, Object value) {
    return (WatchTarget) super.set(fieldName, value);
  }

  @Override
  public WatchTarget clone() {
    return (WatchTarget) super.clone();
  }

}
