/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * Update Form's FormSettings.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class UpdateSettingsRequest extends com.google.api.client.json.GenericJson {

  /**
   * Required. The settings to update with.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FormSettings settings;

  /**
   * Required. Only values named in this mask are changed. At least one field must be specified. The
   * root `settings` is implied and should not be specified. A single `"*"` can be used as short-
   * hand for updating every field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String updateMask;

  /**
   * Required. The settings to update with.
   * @return value or {@code null} for none
   */
  public FormSettings getSettings() {
    return settings;
  }

  /**
   * Required. The settings to update with.
   * @param settings settings or {@code null} for none
   */
  public UpdateSettingsRequest setSettings(FormSettings settings) {
    this.settings = settings;
    return this;
  }

  /**
   * Required. Only values named in this mask are changed. At least one field must be specified. The
   * root `settings` is implied and should not be specified. A single `"*"` can be used as short-
   * hand for updating every field.
   * @return value or {@code null} for none
   */
  public String getUpdateMask() {
    return updateMask;
  }

  /**
   * Required. Only values named in this mask are changed. At least one field must be specified. The
   * root `settings` is implied and should not be specified. A single `"*"` can be used as short-
   * hand for updating every field.
   * @param updateMask updateMask or {@code null} for none
   */
  public UpdateSettingsRequest setUpdateMask(String updateMask) {
    this.updateMask = updateMask;
    return this;
  }

  @Override
  public UpdateSettingsRequest set(String fieldName, Object value) {
    return (UpdateSettingsRequest) super.set(fieldName, value);
  }

  @Override
  public UpdateSettingsRequest clone() {
    return (UpdateSettingsRequest) super.clone();
  }

}
