/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * A scale question. The user has a range of numeric values to choose from.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ScaleQuestion extends com.google.api.client.json.GenericJson {

  /**
   * Required. The highest possible value for the scale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer high;

  /**
   * The label to display describing the highest point on the scale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String highLabel;

  /**
   * Required. The lowest possible value for the scale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer low;

  /**
   * The label to display describing the lowest point on the scale.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lowLabel;

  /**
   * Required. The highest possible value for the scale.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getHigh() {
    return high;
  }

  /**
   * Required. The highest possible value for the scale.
   * @param high high or {@code null} for none
   */
  public ScaleQuestion setHigh(java.lang.Integer high) {
    this.high = high;
    return this;
  }

  /**
   * The label to display describing the highest point on the scale.
   * @return value or {@code null} for none
   */
  public java.lang.String getHighLabel() {
    return highLabel;
  }

  /**
   * The label to display describing the highest point on the scale.
   * @param highLabel highLabel or {@code null} for none
   */
  public ScaleQuestion setHighLabel(java.lang.String highLabel) {
    this.highLabel = highLabel;
    return this;
  }

  /**
   * Required. The lowest possible value for the scale.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getLow() {
    return low;
  }

  /**
   * Required. The lowest possible value for the scale.
   * @param low low or {@code null} for none
   */
  public ScaleQuestion setLow(java.lang.Integer low) {
    this.low = low;
    return this;
  }

  /**
   * The label to display describing the lowest point on the scale.
   * @return value or {@code null} for none
   */
  public java.lang.String getLowLabel() {
    return lowLabel;
  }

  /**
   * The label to display describing the lowest point on the scale.
   * @param lowLabel lowLabel or {@code null} for none
   */
  public ScaleQuestion setLowLabel(java.lang.String lowLabel) {
    this.lowLabel = lowLabel;
    return this;
  }

  @Override
  public ScaleQuestion set(String fieldName, Object value) {
    return (ScaleQuestion) super.set(fieldName, value);
  }

  @Override
  public ScaleQuestion clone() {
    return (ScaleQuestion) super.clone();
  }

}
