/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * The kinds of update requests that can be made.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Request extends com.google.api.client.json.GenericJson {

  /**
   * Create a new item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CreateItemRequest createItem;

  /**
   * Delete an item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DeleteItemRequest deleteItem;

  /**
   * Move an item to a specified location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MoveItemRequest moveItem;

  /**
   * Update Form's Info.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateFormInfoRequest updateFormInfo;

  /**
   * Update an item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateItemRequest updateItem;

  /**
   * Updates the Form's settings.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private UpdateSettingsRequest updateSettings;

  /**
   * Create a new item.
   * @return value or {@code null} for none
   */
  public CreateItemRequest getCreateItem() {
    return createItem;
  }

  /**
   * Create a new item.
   * @param createItem createItem or {@code null} for none
   */
  public Request setCreateItem(CreateItemRequest createItem) {
    this.createItem = createItem;
    return this;
  }

  /**
   * Delete an item.
   * @return value or {@code null} for none
   */
  public DeleteItemRequest getDeleteItem() {
    return deleteItem;
  }

  /**
   * Delete an item.
   * @param deleteItem deleteItem or {@code null} for none
   */
  public Request setDeleteItem(DeleteItemRequest deleteItem) {
    this.deleteItem = deleteItem;
    return this;
  }

  /**
   * Move an item to a specified location.
   * @return value or {@code null} for none
   */
  public MoveItemRequest getMoveItem() {
    return moveItem;
  }

  /**
   * Move an item to a specified location.
   * @param moveItem moveItem or {@code null} for none
   */
  public Request setMoveItem(MoveItemRequest moveItem) {
    this.moveItem = moveItem;
    return this;
  }

  /**
   * Update Form's Info.
   * @return value or {@code null} for none
   */
  public UpdateFormInfoRequest getUpdateFormInfo() {
    return updateFormInfo;
  }

  /**
   * Update Form's Info.
   * @param updateFormInfo updateFormInfo or {@code null} for none
   */
  public Request setUpdateFormInfo(UpdateFormInfoRequest updateFormInfo) {
    this.updateFormInfo = updateFormInfo;
    return this;
  }

  /**
   * Update an item.
   * @return value or {@code null} for none
   */
  public UpdateItemRequest getUpdateItem() {
    return updateItem;
  }

  /**
   * Update an item.
   * @param updateItem updateItem or {@code null} for none
   */
  public Request setUpdateItem(UpdateItemRequest updateItem) {
    this.updateItem = updateItem;
    return this;
  }

  /**
   * Updates the Form's settings.
   * @return value or {@code null} for none
   */
  public UpdateSettingsRequest getUpdateSettings() {
    return updateSettings;
  }

  /**
   * Updates the Form's settings.
   * @param updateSettings updateSettings or {@code null} for none
   */
  public Request setUpdateSettings(UpdateSettingsRequest updateSettings) {
    this.updateSettings = updateSettings;
    return this;
  }

  @Override
  public Request set(String fieldName, Object value) {
    return (Request) super.set(fieldName, value);
  }

  @Override
  public Request clone() {
    return (Request) super.clone();
  }

}
