/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * A form item containing a single question.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class QuestionItem extends com.google.api.client.json.GenericJson {

  /**
   * The image displayed within the question.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Image image;

  /**
   * Required. The displayed question.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Question question;

  /**
   * The image displayed within the question.
   * @return value or {@code null} for none
   */
  public Image getImage() {
    return image;
  }

  /**
   * The image displayed within the question.
   * @param image image or {@code null} for none
   */
  public QuestionItem setImage(Image image) {
    this.image = image;
    return this;
  }

  /**
   * Required. The displayed question.
   * @return value or {@code null} for none
   */
  public Question getQuestion() {
    return question;
  }

  /**
   * Required. The displayed question.
   * @param question question or {@code null} for none
   */
  public QuestionItem setQuestion(Question question) {
    this.question = question;
    return this;
  }

  @Override
  public QuestionItem set(String fieldName, Object value) {
    return (QuestionItem) super.set(fieldName, value);
  }

  @Override
  public QuestionItem clone() {
    return (QuestionItem) super.clone();
  }

}
