/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * Properties of the media.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MediaProperties extends com.google.api.client.json.GenericJson {

  /**
   * Position of the media.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String alignment;

  /**
   * The width of the media in pixels. When the media is displayed, it is scaled to the smaller of
   * this value or the width of the displayed form. The original aspect ratio of the media is
   * preserved. If a width is not specified when the media is added to the form, it is set to the
   * width of the media source. Width must be between 0 and 740, inclusive. Setting width to 0 or
   * unspecified is only permitted when updating the media source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer width;

  /**
   * Position of the media.
   * @return value or {@code null} for none
   */
  public java.lang.String getAlignment() {
    return alignment;
  }

  /**
   * Position of the media.
   * @param alignment alignment or {@code null} for none
   */
  public MediaProperties setAlignment(java.lang.String alignment) {
    this.alignment = alignment;
    return this;
  }

  /**
   * The width of the media in pixels. When the media is displayed, it is scaled to the smaller of
   * this value or the width of the displayed form. The original aspect ratio of the media is
   * preserved. If a width is not specified when the media is added to the form, it is set to the
   * width of the media source. Width must be between 0 and 740, inclusive. Setting width to 0 or
   * unspecified is only permitted when updating the media source.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getWidth() {
    return width;
  }

  /**
   * The width of the media in pixels. When the media is displayed, it is scaled to the smaller of
   * this value or the width of the displayed form. The original aspect ratio of the media is
   * preserved. If a width is not specified when the media is added to the form, it is set to the
   * width of the media source. Width must be between 0 and 740, inclusive. Setting width to 0 or
   * unspecified is only permitted when updating the media source.
   * @param width width or {@code null} for none
   */
  public MediaProperties setWidth(java.lang.Integer width) {
    this.width = width;
    return this;
  }

  @Override
  public MediaProperties set(String fieldName, Object value) {
    return (MediaProperties) super.set(fieldName, value);
  }

  @Override
  public MediaProperties clone() {
    return (MediaProperties) super.clone();
  }

}
