/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * Response to a ListFormResponsesRequest.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListFormResponsesResponse extends com.google.api.client.json.GenericJson {

  /**
   * If set, there are more responses. To get the next page of responses, provide this as
   * `page_token` in a future request.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The returned responses.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FormResponse> responses;

  static {
    // hack to force ProGuard to consider FormResponse used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FormResponse.class);
  }

  /**
   * If set, there are more responses. To get the next page of responses, provide this as
   * `page_token` in a future request.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If set, there are more responses. To get the next page of responses, provide this as
   * `page_token` in a future request.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListFormResponsesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The returned responses.
   * @return value or {@code null} for none
   */
  public java.util.List<FormResponse> getResponses() {
    return responses;
  }

  /**
   * The returned responses.
   * @param responses responses or {@code null} for none
   */
  public ListFormResponsesResponse setResponses(java.util.List<FormResponse> responses) {
    this.responses = responses;
    return this;
  }

  @Override
  public ListFormResponsesResponse set(String fieldName, Object value) {
    return (ListFormResponsesResponse) super.set(fieldName, value);
  }

  @Override
  public ListFormResponsesResponse clone() {
    return (ListFormResponsesResponse) super.clone();
  }

}
