/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * Data representing an image.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Image extends com.google.api.client.json.GenericJson {

  /**
   * A description of the image that is shown on hover and read by screenreaders.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String altText;

  /**
   * Output only. A URI from which you can download the image; this is valid only for a limited
   * time.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String contentUri;

  /**
   * Properties of an image.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MediaProperties properties;

  /**
   * Input only. The source URI is the URI used to insert the image. The source URI can be empty
   * when fetched.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceUri;

  /**
   * A description of the image that is shown on hover and read by screenreaders.
   * @return value or {@code null} for none
   */
  public java.lang.String getAltText() {
    return altText;
  }

  /**
   * A description of the image that is shown on hover and read by screenreaders.
   * @param altText altText or {@code null} for none
   */
  public Image setAltText(java.lang.String altText) {
    this.altText = altText;
    return this;
  }

  /**
   * Output only. A URI from which you can download the image; this is valid only for a limited
   * time.
   * @return value or {@code null} for none
   */
  public java.lang.String getContentUri() {
    return contentUri;
  }

  /**
   * Output only. A URI from which you can download the image; this is valid only for a limited
   * time.
   * @param contentUri contentUri or {@code null} for none
   */
  public Image setContentUri(java.lang.String contentUri) {
    this.contentUri = contentUri;
    return this;
  }

  /**
   * Properties of an image.
   * @return value or {@code null} for none
   */
  public MediaProperties getProperties() {
    return properties;
  }

  /**
   * Properties of an image.
   * @param properties properties or {@code null} for none
   */
  public Image setProperties(MediaProperties properties) {
    this.properties = properties;
    return this;
  }

  /**
   * Input only. The source URI is the URI used to insert the image. The source URI can be empty
   * when fetched.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceUri() {
    return sourceUri;
  }

  /**
   * Input only. The source URI is the URI used to insert the image. The source URI can be empty
   * when fetched.
   * @param sourceUri sourceUri or {@code null} for none
   */
  public Image setSourceUri(java.lang.String sourceUri) {
    this.sourceUri = sourceUri;
    return this;
  }

  @Override
  public Image set(String fieldName, Object value) {
    return (Image) super.set(fieldName, value);
  }

  @Override
  public Image clone() {
    return (Image) super.clone();
  }

}
