/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * Grading for a single question
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Grading extends com.google.api.client.json.GenericJson {

  /**
   * Required. The answer key for the question. Responses are automatically graded based on this
   * field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CorrectAnswers correctAnswers;

  /**
   * The feedback displayed for all answers. This is commonly used for short answer questions when a
   * quiz owner wants to quickly give respondents some sense of whether they answered the question
   * correctly before they've had a chance to officially grade the response. General feedback cannot
   * be set for automatically graded multiple choice questions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Feedback generalFeedback;

  /**
   * Required. The maximum number of points a respondent can automatically get for a correct answer.
   * This must not be negative.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer pointValue;

  /**
   * The feedback displayed for correct responses. This feedback can only be set for multiple choice
   * questions that have correct answers provided.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Feedback whenRight;

  /**
   * The feedback displayed for incorrect responses. This feedback can only be set for multiple
   * choice questions that have correct answers provided.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Feedback whenWrong;

  /**
   * Required. The answer key for the question. Responses are automatically graded based on this
   * field.
   * @return value or {@code null} for none
   */
  public CorrectAnswers getCorrectAnswers() {
    return correctAnswers;
  }

  /**
   * Required. The answer key for the question. Responses are automatically graded based on this
   * field.
   * @param correctAnswers correctAnswers or {@code null} for none
   */
  public Grading setCorrectAnswers(CorrectAnswers correctAnswers) {
    this.correctAnswers = correctAnswers;
    return this;
  }

  /**
   * The feedback displayed for all answers. This is commonly used for short answer questions when a
   * quiz owner wants to quickly give respondents some sense of whether they answered the question
   * correctly before they've had a chance to officially grade the response. General feedback cannot
   * be set for automatically graded multiple choice questions.
   * @return value or {@code null} for none
   */
  public Feedback getGeneralFeedback() {
    return generalFeedback;
  }

  /**
   * The feedback displayed for all answers. This is commonly used for short answer questions when a
   * quiz owner wants to quickly give respondents some sense of whether they answered the question
   * correctly before they've had a chance to officially grade the response. General feedback cannot
   * be set for automatically graded multiple choice questions.
   * @param generalFeedback generalFeedback or {@code null} for none
   */
  public Grading setGeneralFeedback(Feedback generalFeedback) {
    this.generalFeedback = generalFeedback;
    return this;
  }

  /**
   * Required. The maximum number of points a respondent can automatically get for a correct answer.
   * This must not be negative.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPointValue() {
    return pointValue;
  }

  /**
   * Required. The maximum number of points a respondent can automatically get for a correct answer.
   * This must not be negative.
   * @param pointValue pointValue or {@code null} for none
   */
  public Grading setPointValue(java.lang.Integer pointValue) {
    this.pointValue = pointValue;
    return this;
  }

  /**
   * The feedback displayed for correct responses. This feedback can only be set for multiple choice
   * questions that have correct answers provided.
   * @return value or {@code null} for none
   */
  public Feedback getWhenRight() {
    return whenRight;
  }

  /**
   * The feedback displayed for correct responses. This feedback can only be set for multiple choice
   * questions that have correct answers provided.
   * @param whenRight whenRight or {@code null} for none
   */
  public Grading setWhenRight(Feedback whenRight) {
    this.whenRight = whenRight;
    return this;
  }

  /**
   * The feedback displayed for incorrect responses. This feedback can only be set for multiple
   * choice questions that have correct answers provided.
   * @return value or {@code null} for none
   */
  public Feedback getWhenWrong() {
    return whenWrong;
  }

  /**
   * The feedback displayed for incorrect responses. This feedback can only be set for multiple
   * choice questions that have correct answers provided.
   * @param whenWrong whenWrong or {@code null} for none
   */
  public Grading setWhenWrong(Feedback whenWrong) {
    this.whenWrong = whenWrong;
    return this;
  }

  @Override
  public Grading set(String fieldName, Object value) {
    return (Grading) super.set(fieldName, value);
  }

  @Override
  public Grading clone() {
    return (Grading) super.clone();
  }

}
