/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.forms.v1.model;

/**
 * The result of creating an item.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Forms API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CreateItemResponse extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the created item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String itemId;

  /**
   * The ID of the question created as part of this item, for a question group it lists IDs of all
   * the questions created for this item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> questionId;

  /**
   * The ID of the created item.
   * @return value or {@code null} for none
   */
  public java.lang.String getItemId() {
    return itemId;
  }

  /**
   * The ID of the created item.
   * @param itemId itemId or {@code null} for none
   */
  public CreateItemResponse setItemId(java.lang.String itemId) {
    this.itemId = itemId;
    return this;
  }

  /**
   * The ID of the question created as part of this item, for a question group it lists IDs of all
   * the questions created for this item.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getQuestionId() {
    return questionId;
  }

  /**
   * The ID of the question created as part of this item, for a question group it lists IDs of all
   * the questions created for this item.
   * @param questionId questionId or {@code null} for none
   */
  public CreateItemResponse setQuestionId(java.util.List<java.lang.String> questionId) {
    this.questionId = questionId;
    return this;
  }

  @Override
  public CreateItemResponse set(String fieldName, Object value) {
    return (CreateItemResponse) super.set(fieldName, value);
  }

  @Override
  public CreateItemResponse clone() {
    return (CreateItemResponse) super.clone();
  }

}
