/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-25 at 11:49:19 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive;

/**
 * Service definition for Drive (v3).
 *
 * <p>
 * Manages files in Drive including uploading, downloading, searching, detecting changes, and updating sharing permissions.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/drive/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link DriveRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class Drive extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.23.0 of the Drive API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "drive/v3/";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch/drive/v3";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public Drive(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  Drive(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the About collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.About.List request = drive.about().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public About about() {
    return new About();
  }

  /**
   * The "about" collection of methods.
   */
  public class About {

    /**
     * Gets information about the user, the user's Drive, and system capabilities.
     *
     * Create a request for the method "about.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public Get get() throws java.io.IOException {
      Get result = new Get();
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.About> {

      private static final String REST_PATH = "about";

      /**
       * Gets information about the user, the user's Drive, and system capabilities.
       *
       * Create a request for the method "about.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected Get() {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.About.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Changes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Changes.List request = drive.changes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Changes changes() {
    return new Changes();
  }

  /**
   * The "changes" collection of methods.
   */
  public class Changes {

    /**
     * Gets the starting pageToken for listing future changes.
     *
     * Create a request for the method "changes.getStartPageToken".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link GetStartPageToken#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public GetStartPageToken getStartPageToken() throws java.io.IOException {
      GetStartPageToken result = new GetStartPageToken();
      initialize(result);
      return result;
    }

    public class GetStartPageToken extends DriveRequest<com.google.api.services.drive.model.StartPageToken> {

      private static final String REST_PATH = "changes/startPageToken";

      /**
       * Gets the starting pageToken for listing future changes.
       *
       * Create a request for the method "changes.getStartPageToken".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link GetStartPageToken#execute()} method to invoke the remote operation.
       * <p> {@link GetStartPageToken#initialize(com.google.api.client.googleapis.services.AbstractGoogl
       * eClientRequest)} must be called to initialize this instance immediately after invoking the
       * constructor. </p>
       *
       * @since 1.13
       */
      protected GetStartPageToken() {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.StartPageToken.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetStartPageToken setAlt(java.lang.String alt) {
        return (GetStartPageToken) super.setAlt(alt);
      }

      @Override
      public GetStartPageToken setFields(java.lang.String fields) {
        return (GetStartPageToken) super.setFields(fields);
      }

      @Override
      public GetStartPageToken setKey(java.lang.String key) {
        return (GetStartPageToken) super.setKey(key);
      }

      @Override
      public GetStartPageToken setOauthToken(java.lang.String oauthToken) {
        return (GetStartPageToken) super.setOauthToken(oauthToken);
      }

      @Override
      public GetStartPageToken setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetStartPageToken) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetStartPageToken setQuotaUser(java.lang.String quotaUser) {
        return (GetStartPageToken) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetStartPageToken setUserIp(java.lang.String userIp) {
        return (GetStartPageToken) super.setUserIp(userIp);
      }

      /** Whether the requesting application supports Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Whether the requesting application supports Team Drives. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Whether the requesting application supports Team Drives. */
      public GetStartPageToken setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports Team Drives.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /**
       * The ID of the Team Drive for which the starting pageToken for listing future changes from
       * that Team Drive will be returned.
       */
      @com.google.api.client.util.Key
      private java.lang.String teamDriveId;

      /** The ID of the Team Drive for which the starting pageToken for listing future changes from that Team
     Drive will be returned.
       */
      public java.lang.String getTeamDriveId() {
        return teamDriveId;
      }

      /**
       * The ID of the Team Drive for which the starting pageToken for listing future changes from
       * that Team Drive will be returned.
       */
      public GetStartPageToken setTeamDriveId(java.lang.String teamDriveId) {
        this.teamDriveId = teamDriveId;
        return this;
      }

      @Override
      public GetStartPageToken set(String parameterName, Object value) {
        return (GetStartPageToken) super.set(parameterName, value);
      }
    }
    /**
     * Lists the changes for a user or Team Drive.
     *
     * Create a request for the method "changes.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param pageToken The token for continuing a previous list request on the next page. This should be set to the value
     *        of 'nextPageToken' from the previous response or to the response from the
     *        getStartPageToken method.
     * @return the request
     */
    public List list(java.lang.String pageToken) throws java.io.IOException {
      List result = new List(pageToken);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.ChangeList> {

      private static final String REST_PATH = "changes";

      /**
       * Lists the changes for a user or Team Drive.
       *
       * Create a request for the method "changes.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param pageToken The token for continuing a previous list request on the next page. This should be set to the value
     *        of 'nextPageToken' from the previous response or to the response from the
     *        getStartPageToken method.
       * @since 1.13
       */
      protected List(java.lang.String pageToken) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.ChangeList.class);
        this.pageToken = com.google.api.client.util.Preconditions.checkNotNull(pageToken, "Required parameter pageToken must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response or to the response from the
       * getStartPageToken method.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of 'nextPageToken' from the previous response or to the response from the getStartPageToken method.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response or to the response from the
       * getStartPageToken method.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Whether changes should include the file resource if the file is still accessible by the
       * user at the time of the request, even when a file was removed from the list of changes and
       * there will be no further change entries for this file.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeCorpusRemovals;

      /** Whether changes should include the file resource if the file is still accessible by the user at the
     time of the request, even when a file was removed from the list of changes and there will be no
     further change entries for this file. [default: false]
       */
      public java.lang.Boolean getIncludeCorpusRemovals() {
        return includeCorpusRemovals;
      }

      /**
       * Whether changes should include the file resource if the file is still accessible by the
       * user at the time of the request, even when a file was removed from the list of changes and
       * there will be no further change entries for this file.
       */
      public List setIncludeCorpusRemovals(java.lang.Boolean includeCorpusRemovals) {
        this.includeCorpusRemovals = includeCorpusRemovals;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether changes should include the file resource if the file is still accessible by the user at the
     time of the request, even when a file was removed from the list of changes and there will be no
     further change entries for this file.
       * </p>
       */
      public boolean isIncludeCorpusRemovals() {
        if (includeCorpusRemovals == null || includeCorpusRemovals == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeCorpusRemovals;
      }

      /**
       * Whether to include changes indicating that items have been removed from the list of
       * changes, for example by deletion or loss of access.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeRemoved;

      /** Whether to include changes indicating that items have been removed from the list of changes, for
     example by deletion or loss of access. [default: true]
       */
      public java.lang.Boolean getIncludeRemoved() {
        return includeRemoved;
      }

      /**
       * Whether to include changes indicating that items have been removed from the list of
       * changes, for example by deletion or loss of access.
       */
      public List setIncludeRemoved(java.lang.Boolean includeRemoved) {
        this.includeRemoved = includeRemoved;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to include changes indicating that items have been removed from the list of changes, for
     example by deletion or loss of access.
       * </p>
       */
      public boolean isIncludeRemoved() {
        if (includeRemoved == null || includeRemoved == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return includeRemoved;
      }

      /** Whether Team Drive files or changes should be included in results. */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeTeamDriveItems;

      /** Whether Team Drive files or changes should be included in results. [default: false]
       */
      public java.lang.Boolean getIncludeTeamDriveItems() {
        return includeTeamDriveItems;
      }

      /** Whether Team Drive files or changes should be included in results. */
      public List setIncludeTeamDriveItems(java.lang.Boolean includeTeamDriveItems) {
        this.includeTeamDriveItems = includeTeamDriveItems;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether Team Drive files or changes should be included in results.
       * </p>
       */
      public boolean isIncludeTeamDriveItems() {
        if (includeTeamDriveItems == null || includeTeamDriveItems == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeTeamDriveItems;
      }

      /** The maximum number of changes to return per page. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of changes to return per page. [default: 100] [minimum: 1] [maximum: 1000]
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** The maximum number of changes to return per page. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * Whether to restrict the results to changes inside the My Drive hierarchy. This omits
       * changes to files such as those in the Application Data folder or shared files which have
       * not been added to My Drive.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean restrictToMyDrive;

      /** Whether to restrict the results to changes inside the My Drive hierarchy. This omits changes to
     files such as those in the Application Data folder or shared files which have not been added to My
     Drive. [default: false]
       */
      public java.lang.Boolean getRestrictToMyDrive() {
        return restrictToMyDrive;
      }

      /**
       * Whether to restrict the results to changes inside the My Drive hierarchy. This omits
       * changes to files such as those in the Application Data folder or shared files which have
       * not been added to My Drive.
       */
      public List setRestrictToMyDrive(java.lang.Boolean restrictToMyDrive) {
        this.restrictToMyDrive = restrictToMyDrive;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to restrict the results to changes inside the My Drive hierarchy. This omits changes to
     files such as those in the Application Data folder or shared files which have not been added to My
     Drive.
       * </p>
       */
      public boolean isRestrictToMyDrive() {
        if (restrictToMyDrive == null || restrictToMyDrive == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return restrictToMyDrive;
      }

      /**
       * A comma-separated list of spaces to query within the user corpus. Supported values are
       * 'drive', 'appDataFolder' and 'photos'.
       */
      @com.google.api.client.util.Key
      private java.lang.String spaces;

      /** A comma-separated list of spaces to query within the user corpus. Supported values are 'drive',
     'appDataFolder' and 'photos'. [default: drive]
       */
      public java.lang.String getSpaces() {
        return spaces;
      }

      /**
       * A comma-separated list of spaces to query within the user corpus. Supported values are
       * 'drive', 'appDataFolder' and 'photos'.
       */
      public List setSpaces(java.lang.String spaces) {
        this.spaces = spaces;
        return this;
      }

      /** Whether the requesting application supports Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Whether the requesting application supports Team Drives. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Whether the requesting application supports Team Drives. */
      public List setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports Team Drives.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /**
       * The Team Drive from which changes will be returned. If specified the change IDs will be
       * reflective of the Team Drive; use the combined Team Drive ID and change ID as an
       * identifier.
       */
      @com.google.api.client.util.Key
      private java.lang.String teamDriveId;

      /** The Team Drive from which changes will be returned. If specified the change IDs will be reflective
     of the Team Drive; use the combined Team Drive ID and change ID as an identifier.
       */
      public java.lang.String getTeamDriveId() {
        return teamDriveId;
      }

      /**
       * The Team Drive from which changes will be returned. If specified the change IDs will be
       * reflective of the Team Drive; use the combined Team Drive ID and change ID as an
       * identifier.
       */
      public List setTeamDriveId(java.lang.String teamDriveId) {
        this.teamDriveId = teamDriveId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Subscribes to changes for a user.
     *
     * Create a request for the method "changes.watch".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Watch#execute()} method to invoke the remote operation.
     *
     * @param pageToken The token for continuing a previous list request on the next page. This should be set to the value
     *        of 'nextPageToken' from the previous response or to the response from the
     *        getStartPageToken method.
     * @param content the {@link com.google.api.services.drive.model.Channel}
     * @return the request
     */
    public Watch watch(java.lang.String pageToken, com.google.api.services.drive.model.Channel content) throws java.io.IOException {
      Watch result = new Watch(pageToken, content);
      initialize(result);
      return result;
    }

    public class Watch extends DriveRequest<com.google.api.services.drive.model.Channel> {

      private static final String REST_PATH = "changes/watch";

      /**
       * Subscribes to changes for a user.
       *
       * Create a request for the method "changes.watch".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Watch#execute()} method to invoke the remote operation. <p> {@link
       * Watch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param pageToken The token for continuing a previous list request on the next page. This should be set to the value
     *        of 'nextPageToken' from the previous response or to the response from the
     *        getStartPageToken method.
       * @param content the {@link com.google.api.services.drive.model.Channel}
       * @since 1.13
       */
      protected Watch(java.lang.String pageToken, com.google.api.services.drive.model.Channel content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.Channel.class);
        this.pageToken = com.google.api.client.util.Preconditions.checkNotNull(pageToken, "Required parameter pageToken must be specified.");
      }

      @Override
      public Watch setAlt(java.lang.String alt) {
        return (Watch) super.setAlt(alt);
      }

      @Override
      public Watch setFields(java.lang.String fields) {
        return (Watch) super.setFields(fields);
      }

      @Override
      public Watch setKey(java.lang.String key) {
        return (Watch) super.setKey(key);
      }

      @Override
      public Watch setOauthToken(java.lang.String oauthToken) {
        return (Watch) super.setOauthToken(oauthToken);
      }

      @Override
      public Watch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Watch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Watch setQuotaUser(java.lang.String quotaUser) {
        return (Watch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Watch setUserIp(java.lang.String userIp) {
        return (Watch) super.setUserIp(userIp);
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response or to the response from the
       * getStartPageToken method.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of 'nextPageToken' from the previous response or to the response from the getStartPageToken method.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response or to the response from the
       * getStartPageToken method.
       */
      public Watch setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Whether changes should include the file resource if the file is still accessible by the
       * user at the time of the request, even when a file was removed from the list of changes and
       * there will be no further change entries for this file.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeCorpusRemovals;

      /** Whether changes should include the file resource if the file is still accessible by the user at the
     time of the request, even when a file was removed from the list of changes and there will be no
     further change entries for this file. [default: false]
       */
      public java.lang.Boolean getIncludeCorpusRemovals() {
        return includeCorpusRemovals;
      }

      /**
       * Whether changes should include the file resource if the file is still accessible by the
       * user at the time of the request, even when a file was removed from the list of changes and
       * there will be no further change entries for this file.
       */
      public Watch setIncludeCorpusRemovals(java.lang.Boolean includeCorpusRemovals) {
        this.includeCorpusRemovals = includeCorpusRemovals;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether changes should include the file resource if the file is still accessible by the user at the
     time of the request, even when a file was removed from the list of changes and there will be no
     further change entries for this file.
       * </p>
       */
      public boolean isIncludeCorpusRemovals() {
        if (includeCorpusRemovals == null || includeCorpusRemovals == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeCorpusRemovals;
      }

      /**
       * Whether to include changes indicating that items have been removed from the list of
       * changes, for example by deletion or loss of access.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeRemoved;

      /** Whether to include changes indicating that items have been removed from the list of changes, for
     example by deletion or loss of access. [default: true]
       */
      public java.lang.Boolean getIncludeRemoved() {
        return includeRemoved;
      }

      /**
       * Whether to include changes indicating that items have been removed from the list of
       * changes, for example by deletion or loss of access.
       */
      public Watch setIncludeRemoved(java.lang.Boolean includeRemoved) {
        this.includeRemoved = includeRemoved;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to include changes indicating that items have been removed from the list of changes, for
     example by deletion or loss of access.
       * </p>
       */
      public boolean isIncludeRemoved() {
        if (includeRemoved == null || includeRemoved == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return true;
        }
        return includeRemoved;
      }

      /** Whether Team Drive files or changes should be included in results. */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeTeamDriveItems;

      /** Whether Team Drive files or changes should be included in results. [default: false]
       */
      public java.lang.Boolean getIncludeTeamDriveItems() {
        return includeTeamDriveItems;
      }

      /** Whether Team Drive files or changes should be included in results. */
      public Watch setIncludeTeamDriveItems(java.lang.Boolean includeTeamDriveItems) {
        this.includeTeamDriveItems = includeTeamDriveItems;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether Team Drive files or changes should be included in results.
       * </p>
       */
      public boolean isIncludeTeamDriveItems() {
        if (includeTeamDriveItems == null || includeTeamDriveItems == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeTeamDriveItems;
      }

      /** The maximum number of changes to return per page. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of changes to return per page. [default: 100] [minimum: 1] [maximum: 1000]
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** The maximum number of changes to return per page. */
      public Watch setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * Whether to restrict the results to changes inside the My Drive hierarchy. This omits
       * changes to files such as those in the Application Data folder or shared files which have
       * not been added to My Drive.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean restrictToMyDrive;

      /** Whether to restrict the results to changes inside the My Drive hierarchy. This omits changes to
     files such as those in the Application Data folder or shared files which have not been added to My
     Drive. [default: false]
       */
      public java.lang.Boolean getRestrictToMyDrive() {
        return restrictToMyDrive;
      }

      /**
       * Whether to restrict the results to changes inside the My Drive hierarchy. This omits
       * changes to files such as those in the Application Data folder or shared files which have
       * not been added to My Drive.
       */
      public Watch setRestrictToMyDrive(java.lang.Boolean restrictToMyDrive) {
        this.restrictToMyDrive = restrictToMyDrive;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to restrict the results to changes inside the My Drive hierarchy. This omits changes to
     files such as those in the Application Data folder or shared files which have not been added to My
     Drive.
       * </p>
       */
      public boolean isRestrictToMyDrive() {
        if (restrictToMyDrive == null || restrictToMyDrive == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return restrictToMyDrive;
      }

      /**
       * A comma-separated list of spaces to query within the user corpus. Supported values are
       * 'drive', 'appDataFolder' and 'photos'.
       */
      @com.google.api.client.util.Key
      private java.lang.String spaces;

      /** A comma-separated list of spaces to query within the user corpus. Supported values are 'drive',
     'appDataFolder' and 'photos'. [default: drive]
       */
      public java.lang.String getSpaces() {
        return spaces;
      }

      /**
       * A comma-separated list of spaces to query within the user corpus. Supported values are
       * 'drive', 'appDataFolder' and 'photos'.
       */
      public Watch setSpaces(java.lang.String spaces) {
        this.spaces = spaces;
        return this;
      }

      /** Whether the requesting application supports Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Whether the requesting application supports Team Drives. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Whether the requesting application supports Team Drives. */
      public Watch setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports Team Drives.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /**
       * The Team Drive from which changes will be returned. If specified the change IDs will be
       * reflective of the Team Drive; use the combined Team Drive ID and change ID as an
       * identifier.
       */
      @com.google.api.client.util.Key
      private java.lang.String teamDriveId;

      /** The Team Drive from which changes will be returned. If specified the change IDs will be reflective
     of the Team Drive; use the combined Team Drive ID and change ID as an identifier.
       */
      public java.lang.String getTeamDriveId() {
        return teamDriveId;
      }

      /**
       * The Team Drive from which changes will be returned. If specified the change IDs will be
       * reflective of the Team Drive; use the combined Team Drive ID and change ID as an
       * identifier.
       */
      public Watch setTeamDriveId(java.lang.String teamDriveId) {
        this.teamDriveId = teamDriveId;
        return this;
      }

      @Override
      public Watch set(String parameterName, Object value) {
        return (Watch) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Channels collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Channels.List request = drive.channels().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Channels channels() {
    return new Channels();
  }

  /**
   * The "channels" collection of methods.
   */
  public class Channels {

    /**
     * Stop watching resources through this channel
     *
     * Create a request for the method "channels.stop".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Stop#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.drive.model.Channel}
     * @return the request
     */
    public Stop stop(com.google.api.services.drive.model.Channel content) throws java.io.IOException {
      Stop result = new Stop(content);
      initialize(result);
      return result;
    }

    public class Stop extends DriveRequest<Void> {

      private static final String REST_PATH = "channels/stop";

      /**
       * Stop watching resources through this channel
       *
       * Create a request for the method "channels.stop".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Stop#execute()} method to invoke the remote operation. <p> {@link
       * Stop#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.drive.model.Channel}
       * @since 1.13
       */
      protected Stop(com.google.api.services.drive.model.Channel content) {
        super(Drive.this, "POST", REST_PATH, content, Void.class);
      }

      @Override
      public Stop setAlt(java.lang.String alt) {
        return (Stop) super.setAlt(alt);
      }

      @Override
      public Stop setFields(java.lang.String fields) {
        return (Stop) super.setFields(fields);
      }

      @Override
      public Stop setKey(java.lang.String key) {
        return (Stop) super.setKey(key);
      }

      @Override
      public Stop setOauthToken(java.lang.String oauthToken) {
        return (Stop) super.setOauthToken(oauthToken);
      }

      @Override
      public Stop setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Stop) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Stop setQuotaUser(java.lang.String quotaUser) {
        return (Stop) super.setQuotaUser(quotaUser);
      }

      @Override
      public Stop setUserIp(java.lang.String userIp) {
        return (Stop) super.setUserIp(userIp);
      }

      @Override
      public Stop set(String parameterName, Object value) {
        return (Stop) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Comments collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Comments.List request = drive.comments().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Comments comments() {
    return new Comments();
  }

  /**
   * The "comments" collection of methods.
   */
  public class Comments {

    /**
     * Creates a new comment on a file.
     *
     * Create a request for the method "comments.create".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param content the {@link com.google.api.services.drive.model.Comment}
     * @return the request
     */
    public Create create(java.lang.String fileId, com.google.api.services.drive.model.Comment content) throws java.io.IOException {
      Create result = new Create(fileId, content);
      initialize(result);
      return result;
    }

    public class Create extends DriveRequest<com.google.api.services.drive.model.Comment> {

      private static final String REST_PATH = "files/{fileId}/comments";

      /**
       * Creates a new comment on a file.
       *
       * Create a request for the method "comments.create".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param content the {@link com.google.api.services.drive.model.Comment}
       * @since 1.13
       */
      protected Create(java.lang.String fileId, com.google.api.services.drive.model.Comment content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.Comment.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getContent(), "Comment.getContent()");
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUserIp(java.lang.String userIp) {
        return (Create) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Create setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a comment.
     *
     * Create a request for the method "comments.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @return the request
     */
    public Delete delete(java.lang.String fileId, java.lang.String commentId) throws java.io.IOException {
      Delete result = new Delete(fileId, commentId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}";

      /**
       * Deletes a comment.
       *
       * Create a request for the method "comments.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @since 1.13
       */
      protected Delete(java.lang.String fileId, java.lang.String commentId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Delete setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Delete setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a comment by ID.
     *
     * Create a request for the method "comments.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @return the request
     */
    public Get get(java.lang.String fileId, java.lang.String commentId) throws java.io.IOException {
      Get result = new Get(fileId, commentId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.Comment> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}";

      /**
       * Gets a comment by ID.
       *
       * Create a request for the method "comments.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @since 1.13
       */
      protected Get(java.lang.String fileId, java.lang.String commentId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Comment.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Get setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      /**
       * Whether to return deleted comments. Deleted comments will not include their original
       * content.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeDeleted;

      /** Whether to return deleted comments. Deleted comments will not include their original content.
     [default: false]
       */
      public java.lang.Boolean getIncludeDeleted() {
        return includeDeleted;
      }

      /**
       * Whether to return deleted comments. Deleted comments will not include their original
       * content.
       */
      public Get setIncludeDeleted(java.lang.Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to return deleted comments. Deleted comments will not include their original content.
       * </p>
       */
      public boolean isIncludeDeleted() {
        if (includeDeleted == null || includeDeleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeDeleted;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists a file's comments.
     *
     * Create a request for the method "comments.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @return the request
     */
    public List list(java.lang.String fileId) throws java.io.IOException {
      List result = new List(fileId);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.CommentList> {

      private static final String REST_PATH = "files/{fileId}/comments";

      /**
       * Lists a file's comments.
       *
       * Create a request for the method "comments.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @since 1.13
       */
      protected List(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.CommentList.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public List setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * Whether to include deleted comments. Deleted comments will not include their original
       * content.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeDeleted;

      /** Whether to include deleted comments. Deleted comments will not include their original content.
     [default: false]
       */
      public java.lang.Boolean getIncludeDeleted() {
        return includeDeleted;
      }

      /**
       * Whether to include deleted comments. Deleted comments will not include their original
       * content.
       */
      public List setIncludeDeleted(java.lang.Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to include deleted comments. Deleted comments will not include their original content.
       * </p>
       */
      public boolean isIncludeDeleted() {
        if (includeDeleted == null || includeDeleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeDeleted;
      }

      /** The maximum number of comments to return per page. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of comments to return per page. [default: 20] [minimum: 1] [maximum: 100]
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** The maximum number of comments to return per page. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of 'nextPageToken' from the previous response.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** The minimum value of 'modifiedTime' for the result comments (RFC 3339 date-time). */
      @com.google.api.client.util.Key
      private java.lang.String startModifiedTime;

      /** The minimum value of 'modifiedTime' for the result comments (RFC 3339 date-time).
       */
      public java.lang.String getStartModifiedTime() {
        return startModifiedTime;
      }

      /** The minimum value of 'modifiedTime' for the result comments (RFC 3339 date-time). */
      public List setStartModifiedTime(java.lang.String startModifiedTime) {
        this.startModifiedTime = startModifiedTime;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a comment with patch semantics.
     *
     * Create a request for the method "comments.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @param content the {@link com.google.api.services.drive.model.Comment}
     * @return the request
     */
    public Update update(java.lang.String fileId, java.lang.String commentId, com.google.api.services.drive.model.Comment content) throws java.io.IOException {
      Update result = new Update(fileId, commentId, content);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.Comment> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}";

      /**
       * Updates a comment with patch semantics.
       *
       * Create a request for the method "comments.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @param content the {@link com.google.api.services.drive.model.Comment}
       * @since 1.13
       */
      protected Update(java.lang.String fileId, java.lang.String commentId, com.google.api.services.drive.model.Comment content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.Comment.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getContent(), "Comment.getContent()");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Update setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Update setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Files collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Files.List request = drive.files().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Files files() {
    return new Files();
  }

  /**
   * The "files" collection of methods.
   */
  public class Files {

    /**
     * Creates a copy of a file and applies any requested updates with patch semantics.
     *
     * Create a request for the method "files.copy".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Copy#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param content the {@link com.google.api.services.drive.model.File}
     * @return the request
     */
    public Copy copy(java.lang.String fileId, com.google.api.services.drive.model.File content) throws java.io.IOException {
      Copy result = new Copy(fileId, content);
      initialize(result);
      return result;
    }

    public class Copy extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files/{fileId}/copy";

      /**
       * Creates a copy of a file and applies any requested updates with patch semantics.
       *
       * Create a request for the method "files.copy".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Copy#execute()} method to invoke the remote operation. <p> {@link
       * Copy#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param content the {@link com.google.api.services.drive.model.File}
       * @since 1.13
       */
      protected Copy(java.lang.String fileId, com.google.api.services.drive.model.File content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.File.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public Copy setAlt(java.lang.String alt) {
        return (Copy) super.setAlt(alt);
      }

      @Override
      public Copy setFields(java.lang.String fields) {
        return (Copy) super.setFields(fields);
      }

      @Override
      public Copy setKey(java.lang.String key) {
        return (Copy) super.setKey(key);
      }

      @Override
      public Copy setOauthToken(java.lang.String oauthToken) {
        return (Copy) super.setOauthToken(oauthToken);
      }

      @Override
      public Copy setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Copy) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Copy setQuotaUser(java.lang.String quotaUser) {
        return (Copy) super.setQuotaUser(quotaUser);
      }

      @Override
      public Copy setUserIp(java.lang.String userIp) {
        return (Copy) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Copy setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * Whether to ignore the domain's default visibility settings for the created file. Domain
       * administrators can choose to make all uploaded files visible to the domain by default; this
       * parameter bypasses that behavior for the request. Permissions are still inherited from
       * parent folders.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean ignoreDefaultVisibility;

      /** Whether to ignore the domain's default visibility settings for the created file. Domain
     administrators can choose to make all uploaded files visible to the domain by default; this
     parameter bypasses that behavior for the request. Permissions are still inherited from parent
     folders. [default: false]
       */
      public java.lang.Boolean getIgnoreDefaultVisibility() {
        return ignoreDefaultVisibility;
      }

      /**
       * Whether to ignore the domain's default visibility settings for the created file. Domain
       * administrators can choose to make all uploaded files visible to the domain by default; this
       * parameter bypasses that behavior for the request. Permissions are still inherited from
       * parent folders.
       */
      public Copy setIgnoreDefaultVisibility(java.lang.Boolean ignoreDefaultVisibility) {
        this.ignoreDefaultVisibility = ignoreDefaultVisibility;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to ignore the domain's default visibility settings for the created file. Domain
     administrators can choose to make all uploaded files visible to the domain by default; this
     parameter bypasses that behavior for the request. Permissions are still inherited from parent
     folders.
       * </p>
       */
      public boolean isIgnoreDefaultVisibility() {
        if (ignoreDefaultVisibility == null || ignoreDefaultVisibility == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return ignoreDefaultVisibility;
      }

      /**
       * Whether to set the 'keepForever' field in the new head revision. This is only applicable to
       * files with binary content in Drive.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean keepRevisionForever;

      /** Whether to set the 'keepForever' field in the new head revision. This is only applicable to files
     with binary content in Drive. [default: false]
       */
      public java.lang.Boolean getKeepRevisionForever() {
        return keepRevisionForever;
      }

      /**
       * Whether to set the 'keepForever' field in the new head revision. This is only applicable to
       * files with binary content in Drive.
       */
      public Copy setKeepRevisionForever(java.lang.Boolean keepRevisionForever) {
        this.keepRevisionForever = keepRevisionForever;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to set the 'keepForever' field in the new head revision. This is only applicable to files
     with binary content in Drive.
       * </p>
       */
      public boolean isKeepRevisionForever() {
        if (keepRevisionForever == null || keepRevisionForever == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return keepRevisionForever;
      }

      /** A language hint for OCR processing during image import (ISO 639-1 code). */
      @com.google.api.client.util.Key
      private java.lang.String ocrLanguage;

      /** A language hint for OCR processing during image import (ISO 639-1 code).
       */
      public java.lang.String getOcrLanguage() {
        return ocrLanguage;
      }

      /** A language hint for OCR processing during image import (ISO 639-1 code). */
      public Copy setOcrLanguage(java.lang.String ocrLanguage) {
        this.ocrLanguage = ocrLanguage;
        return this;
      }

      /** Whether the requesting application supports Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Whether the requesting application supports Team Drives. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Whether the requesting application supports Team Drives. */
      public Copy setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports Team Drives.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      @Override
      public Copy set(String parameterName, Object value) {
        return (Copy) super.set(parameterName, value);
      }
    }
    /**
     * Creates a new file.
     *
     * Create a request for the method "files.create".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.drive.model.File}
     * @return the request
     */
    public Create create(com.google.api.services.drive.model.File content) throws java.io.IOException {
      Create result = new Create(content);
      initialize(result);
      return result;
    }

    /**
     * Creates a new file.
     *
     * Create a request for the method "files.create".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     *
     * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Create create(com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Create result = new Create(content, mediaContent);
      initialize(result);
      return result;
    }

    public class Create extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files";

      /**
       * Creates a new file.
       *
       * Create a request for the method "files.create".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.drive.model.File}
       * @since 1.13
       */
      protected Create(com.google.api.services.drive.model.File content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.File.class);
      }

      /**
       * Creates a new file.
       *
       * Create a request for the method "files.create".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       *
       * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Create(com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(Drive.this, "POST", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.drive.model.File.class);
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUserIp(java.lang.String userIp) {
        return (Create) super.setUserIp(userIp);
      }

      /**
       * Whether to ignore the domain's default visibility settings for the created file. Domain
       * administrators can choose to make all uploaded files visible to the domain by default; this
       * parameter bypasses that behavior for the request. Permissions are still inherited from
       * parent folders.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean ignoreDefaultVisibility;

      /** Whether to ignore the domain's default visibility settings for the created file. Domain
     administrators can choose to make all uploaded files visible to the domain by default; this
     parameter bypasses that behavior for the request. Permissions are still inherited from parent
     folders. [default: false]
       */
      public java.lang.Boolean getIgnoreDefaultVisibility() {
        return ignoreDefaultVisibility;
      }

      /**
       * Whether to ignore the domain's default visibility settings for the created file. Domain
       * administrators can choose to make all uploaded files visible to the domain by default; this
       * parameter bypasses that behavior for the request. Permissions are still inherited from
       * parent folders.
       */
      public Create setIgnoreDefaultVisibility(java.lang.Boolean ignoreDefaultVisibility) {
        this.ignoreDefaultVisibility = ignoreDefaultVisibility;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to ignore the domain's default visibility settings for the created file. Domain
     administrators can choose to make all uploaded files visible to the domain by default; this
     parameter bypasses that behavior for the request. Permissions are still inherited from parent
     folders.
       * </p>
       */
      public boolean isIgnoreDefaultVisibility() {
        if (ignoreDefaultVisibility == null || ignoreDefaultVisibility == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return ignoreDefaultVisibility;
      }

      /**
       * Whether to set the 'keepForever' field in the new head revision. This is only applicable to
       * files with binary content in Drive.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean keepRevisionForever;

      /** Whether to set the 'keepForever' field in the new head revision. This is only applicable to files
     with binary content in Drive. [default: false]
       */
      public java.lang.Boolean getKeepRevisionForever() {
        return keepRevisionForever;
      }

      /**
       * Whether to set the 'keepForever' field in the new head revision. This is only applicable to
       * files with binary content in Drive.
       */
      public Create setKeepRevisionForever(java.lang.Boolean keepRevisionForever) {
        this.keepRevisionForever = keepRevisionForever;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to set the 'keepForever' field in the new head revision. This is only applicable to files
     with binary content in Drive.
       * </p>
       */
      public boolean isKeepRevisionForever() {
        if (keepRevisionForever == null || keepRevisionForever == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return keepRevisionForever;
      }

      /** A language hint for OCR processing during image import (ISO 639-1 code). */
      @com.google.api.client.util.Key
      private java.lang.String ocrLanguage;

      /** A language hint for OCR processing during image import (ISO 639-1 code).
       */
      public java.lang.String getOcrLanguage() {
        return ocrLanguage;
      }

      /** A language hint for OCR processing during image import (ISO 639-1 code). */
      public Create setOcrLanguage(java.lang.String ocrLanguage) {
        this.ocrLanguage = ocrLanguage;
        return this;
      }

      /** Whether the requesting application supports Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Whether the requesting application supports Team Drives. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Whether the requesting application supports Team Drives. */
      public Create setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports Team Drives.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /** Whether to use the uploaded content as indexable text. */
      @com.google.api.client.util.Key
      private java.lang.Boolean useContentAsIndexableText;

      /** Whether to use the uploaded content as indexable text. [default: false]
       */
      public java.lang.Boolean getUseContentAsIndexableText() {
        return useContentAsIndexableText;
      }

      /** Whether to use the uploaded content as indexable text. */
      public Create setUseContentAsIndexableText(java.lang.Boolean useContentAsIndexableText) {
        this.useContentAsIndexableText = useContentAsIndexableText;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to use the uploaded content as indexable text.
       * </p>
       */
      public boolean isUseContentAsIndexableText() {
        if (useContentAsIndexableText == null || useContentAsIndexableText == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useContentAsIndexableText;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Permanently deletes a file owned by the user without moving it to the trash. If the file belongs
     * to a Team Drive the user must be an organizer on the parent. If the target is a folder, all
     * descendants owned by the user are also deleted.
     *
     * Create a request for the method "files.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @return the request
     */
    public Delete delete(java.lang.String fileId) throws java.io.IOException {
      Delete result = new Delete(fileId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}";

      /**
       * Permanently deletes a file owned by the user without moving it to the trash. If the file
       * belongs to a Team Drive the user must be an organizer on the parent. If the target is a folder,
       * all descendants owned by the user are also deleted.
       *
       * Create a request for the method "files.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @since 1.13
       */
      protected Delete(java.lang.String fileId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Delete setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** Whether the requesting application supports Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Whether the requesting application supports Team Drives. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Whether the requesting application supports Team Drives. */
      public Delete setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports Team Drives.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Permanently deletes all of the user's trashed files.
     *
     * Create a request for the method "files.emptyTrash".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link EmptyTrash#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public EmptyTrash emptyTrash() throws java.io.IOException {
      EmptyTrash result = new EmptyTrash();
      initialize(result);
      return result;
    }

    public class EmptyTrash extends DriveRequest<Void> {

      private static final String REST_PATH = "files/trash";

      /**
       * Permanently deletes all of the user's trashed files.
       *
       * Create a request for the method "files.emptyTrash".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link EmptyTrash#execute()} method to invoke the remote operation. <p>
       * {@link
       * EmptyTrash#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected EmptyTrash() {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
      }

      @Override
      public EmptyTrash setAlt(java.lang.String alt) {
        return (EmptyTrash) super.setAlt(alt);
      }

      @Override
      public EmptyTrash setFields(java.lang.String fields) {
        return (EmptyTrash) super.setFields(fields);
      }

      @Override
      public EmptyTrash setKey(java.lang.String key) {
        return (EmptyTrash) super.setKey(key);
      }

      @Override
      public EmptyTrash setOauthToken(java.lang.String oauthToken) {
        return (EmptyTrash) super.setOauthToken(oauthToken);
      }

      @Override
      public EmptyTrash setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (EmptyTrash) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public EmptyTrash setQuotaUser(java.lang.String quotaUser) {
        return (EmptyTrash) super.setQuotaUser(quotaUser);
      }

      @Override
      public EmptyTrash setUserIp(java.lang.String userIp) {
        return (EmptyTrash) super.setUserIp(userIp);
      }

      @Override
      public EmptyTrash set(String parameterName, Object value) {
        return (EmptyTrash) super.set(parameterName, value);
      }
    }
    /**
     * Exports a Google Doc to the requested MIME type and returns the exported content. Please note
     * that the exported content is limited to 10MB.
     *
     * Create a request for the method "files.export".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Export#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param mimeType The MIME type of the format requested for this export.
     * @return the request
     */
    public Export export(java.lang.String fileId, java.lang.String mimeType) throws java.io.IOException {
      Export result = new Export(fileId, mimeType);
      initialize(result);
      return result;
    }

    public class Export extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/export";

      /**
       * Exports a Google Doc to the requested MIME type and returns the exported content. Please note
       * that the exported content is limited to 10MB.
       *
       * Create a request for the method "files.export".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Export#execute()} method to invoke the remote operation. <p> {@link
       * Export#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param mimeType The MIME type of the format requested for this export.
       * @since 1.13
       */
      protected Export(java.lang.String fileId, java.lang.String mimeType) {
        super(Drive.this, "GET", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.mimeType = com.google.api.client.util.Preconditions.checkNotNull(mimeType, "Required parameter mimeType must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Export setAlt(java.lang.String alt) {
        return (Export) super.setAlt(alt);
      }

      @Override
      public Export setFields(java.lang.String fields) {
        return (Export) super.setFields(fields);
      }

      @Override
      public Export setKey(java.lang.String key) {
        return (Export) super.setKey(key);
      }

      @Override
      public Export setOauthToken(java.lang.String oauthToken) {
        return (Export) super.setOauthToken(oauthToken);
      }

      @Override
      public Export setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Export) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Export setQuotaUser(java.lang.String quotaUser) {
        return (Export) super.setQuotaUser(quotaUser);
      }

      @Override
      public Export setUserIp(java.lang.String userIp) {
        return (Export) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Export setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The MIME type of the format requested for this export. */
      @com.google.api.client.util.Key
      private java.lang.String mimeType;

      /** The MIME type of the format requested for this export.
       */
      public java.lang.String getMimeType() {
        return mimeType;
      }

      /** The MIME type of the format requested for this export. */
      public Export setMimeType(java.lang.String mimeType) {
        this.mimeType = mimeType;
        return this;
      }

      @Override
      public Export set(String parameterName, Object value) {
        return (Export) super.set(parameterName, value);
      }
    }
    /**
     * Generates a set of file IDs which can be provided in create requests.
     *
     * Create a request for the method "files.generateIds".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link GenerateIds#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public GenerateIds generateIds() throws java.io.IOException {
      GenerateIds result = new GenerateIds();
      initialize(result);
      return result;
    }

    public class GenerateIds extends DriveRequest<com.google.api.services.drive.model.GeneratedIds> {

      private static final String REST_PATH = "files/generateIds";

      /**
       * Generates a set of file IDs which can be provided in create requests.
       *
       * Create a request for the method "files.generateIds".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link GenerateIds#execute()} method to invoke the remote operation. <p>
       * {@link
       * GenerateIds#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected GenerateIds() {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.GeneratedIds.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GenerateIds setAlt(java.lang.String alt) {
        return (GenerateIds) super.setAlt(alt);
      }

      @Override
      public GenerateIds setFields(java.lang.String fields) {
        return (GenerateIds) super.setFields(fields);
      }

      @Override
      public GenerateIds setKey(java.lang.String key) {
        return (GenerateIds) super.setKey(key);
      }

      @Override
      public GenerateIds setOauthToken(java.lang.String oauthToken) {
        return (GenerateIds) super.setOauthToken(oauthToken);
      }

      @Override
      public GenerateIds setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GenerateIds) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GenerateIds setQuotaUser(java.lang.String quotaUser) {
        return (GenerateIds) super.setQuotaUser(quotaUser);
      }

      @Override
      public GenerateIds setUserIp(java.lang.String userIp) {
        return (GenerateIds) super.setUserIp(userIp);
      }

      /** The number of IDs to return. */
      @com.google.api.client.util.Key
      private java.lang.Integer count;

      /** The number of IDs to return. [default: 10] [minimum: 1] [maximum: 1000]
       */
      public java.lang.Integer getCount() {
        return count;
      }

      /** The number of IDs to return. */
      public GenerateIds setCount(java.lang.Integer count) {
        this.count = count;
        return this;
      }

      /**
       * The space in which the IDs can be used to create new files. Supported values are 'drive'
       * and 'appDataFolder'.
       */
      @com.google.api.client.util.Key
      private java.lang.String space;

      /** The space in which the IDs can be used to create new files. Supported values are 'drive' and
     'appDataFolder'. [default: drive]
       */
      public java.lang.String getSpace() {
        return space;
      }

      /**
       * The space in which the IDs can be used to create new files. Supported values are 'drive'
       * and 'appDataFolder'.
       */
      public GenerateIds setSpace(java.lang.String space) {
        this.space = space;
        return this;
      }

      @Override
      public GenerateIds set(String parameterName, Object value) {
        return (GenerateIds) super.set(parameterName, value);
      }
    }
    /**
     * Gets a file's metadata or content by ID.
     *
     * Create a request for the method "files.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @return the request
     */
    public Get get(java.lang.String fileId) throws java.io.IOException {
      Get result = new Get(fileId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files/{fileId}";

      /**
       * Gets a file's metadata or content by ID.
       *
       * Create a request for the method "files.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @since 1.13
       */
      protected Get(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.File.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public com.google.api.client.http.GenericUrl buildHttpRequestUrl() {
        java.lang.String baseUrl = ("media".equals(get("alt")) && getMediaHttpUploader() == null)
            ? getRootUrl() + "download/" + getServicePath() : getBaseUrl();
        return new com.google.api.client.http.GenericUrl(
            com.google.api.client.http.UriTemplate.expand(baseUrl, getUriTemplate(), this, true));
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * Whether the user is acknowledging the risk of downloading known malware or other abusive
       * files. This is only applicable when alt=media.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean acknowledgeAbuse;

      /** Whether the user is acknowledging the risk of downloading known malware or other abusive files.
     This is only applicable when alt=media. [default: false]
       */
      public java.lang.Boolean getAcknowledgeAbuse() {
        return acknowledgeAbuse;
      }

      /**
       * Whether the user is acknowledging the risk of downloading known malware or other abusive
       * files. This is only applicable when alt=media.
       */
      public Get setAcknowledgeAbuse(java.lang.Boolean acknowledgeAbuse) {
        this.acknowledgeAbuse = acknowledgeAbuse;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the user is acknowledging the risk of downloading known malware or other abusive files.
     This is only applicable when alt=media.
       * </p>
       */
      public boolean isAcknowledgeAbuse() {
        if (acknowledgeAbuse == null || acknowledgeAbuse == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return acknowledgeAbuse;
      }

      /** Whether the requesting application supports Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Whether the requesting application supports Team Drives. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Whether the requesting application supports Team Drives. */
      public Get setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports Team Drives.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists or searches files.
     *
     * Create a request for the method "files.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.FileList> {

      private static final String REST_PATH = "files";

      /**
       * Lists or searches files.
       *
       * Create a request for the method "files.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.FileList.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /**
       * Comma-separated list of bodies of items (files/documents) to which the query applies.
       * Supported bodies are 'user', 'domain', 'teamDrive' and 'allTeamDrives'. 'allTeamDrives'
       * must be combined with 'user'; all other values must be used in isolation. Prefer 'user' or
       * 'teamDrive' to 'allTeamDrives' for efficiency.
       */
      @com.google.api.client.util.Key
      private java.lang.String corpora;

      /** Comma-separated list of bodies of items (files/documents) to which the query applies. Supported
     bodies are 'user', 'domain', 'teamDrive' and 'allTeamDrives'. 'allTeamDrives' must be combined with
     'user'; all other values must be used in isolation. Prefer 'user' or 'teamDrive' to 'allTeamDrives'
     for efficiency.
       */
      public java.lang.String getCorpora() {
        return corpora;
      }

      /**
       * Comma-separated list of bodies of items (files/documents) to which the query applies.
       * Supported bodies are 'user', 'domain', 'teamDrive' and 'allTeamDrives'. 'allTeamDrives'
       * must be combined with 'user'; all other values must be used in isolation. Prefer 'user' or
       * 'teamDrive' to 'allTeamDrives' for efficiency.
       */
      public List setCorpora(java.lang.String corpora) {
        this.corpora = corpora;
        return this;
      }

      /** The source of files to list. Deprecated: use 'corpora' instead. */
      @com.google.api.client.util.Key
      private java.lang.String corpus;

      /** The source of files to list. Deprecated: use 'corpora' instead.
       */
      public java.lang.String getCorpus() {
        return corpus;
      }

      /** The source of files to list. Deprecated: use 'corpora' instead. */
      public List setCorpus(java.lang.String corpus) {
        this.corpus = corpus;
        return this;
      }

      /** Whether Team Drive items should be included in results. */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeTeamDriveItems;

      /** Whether Team Drive items should be included in results. [default: false]
       */
      public java.lang.Boolean getIncludeTeamDriveItems() {
        return includeTeamDriveItems;
      }

      /** Whether Team Drive items should be included in results. */
      public List setIncludeTeamDriveItems(java.lang.Boolean includeTeamDriveItems) {
        this.includeTeamDriveItems = includeTeamDriveItems;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether Team Drive items should be included in results.
       * </p>
       */
      public boolean isIncludeTeamDriveItems() {
        if (includeTeamDriveItems == null || includeTeamDriveItems == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeTeamDriveItems;
      }

      /**
       * A comma-separated list of sort keys. Valid keys are 'createdTime', 'folder',
       * 'modifiedByMeTime', 'modifiedTime', 'name', 'name_natural', 'quotaBytesUsed', 'recency',
       * 'sharedWithMeTime', 'starred', and 'viewedByMeTime'. Each key sorts ascending by default,
       * but may be reversed with the 'desc' modifier. Example usage: ?orderBy=folder,modifiedTime
       * desc,name. Please note that there is a current limitation for users with approximately one
       * million files in which the requested sort order is ignored.
       */
      @com.google.api.client.util.Key
      private java.lang.String orderBy;

      /** A comma-separated list of sort keys. Valid keys are 'createdTime', 'folder', 'modifiedByMeTime',
     'modifiedTime', 'name', 'name_natural', 'quotaBytesUsed', 'recency', 'sharedWithMeTime', 'starred',
     and 'viewedByMeTime'. Each key sorts ascending by default, but may be reversed with the 'desc'
     modifier. Example usage: ?orderBy=folder,modifiedTime desc,name. Please note that there is a
     current limitation for users with approximately one million files in which the requested sort order
     is ignored.
       */
      public java.lang.String getOrderBy() {
        return orderBy;
      }

      /**
       * A comma-separated list of sort keys. Valid keys are 'createdTime', 'folder',
       * 'modifiedByMeTime', 'modifiedTime', 'name', 'name_natural', 'quotaBytesUsed', 'recency',
       * 'sharedWithMeTime', 'starred', and 'viewedByMeTime'. Each key sorts ascending by default,
       * but may be reversed with the 'desc' modifier. Example usage: ?orderBy=folder,modifiedTime
       * desc,name. Please note that there is a current limitation for users with approximately one
       * million files in which the requested sort order is ignored.
       */
      public List setOrderBy(java.lang.String orderBy) {
        this.orderBy = orderBy;
        return this;
      }

      /**
       * The maximum number of files to return per page. Partial or empty result pages are possible
       * even before the end of the files list has been reached.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of files to return per page. Partial or empty result pages are possible even
     before the end of the files list has been reached. [default: 100] [minimum: 1] [maximum: 1000]
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * The maximum number of files to return per page. Partial or empty result pages are possible
       * even before the end of the files list has been reached.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of 'nextPageToken' from the previous response.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * A query for filtering the file results. See the "Search for Files" guide for supported
       * syntax.
       */
      @com.google.api.client.util.Key
      private java.lang.String q;

      /** A query for filtering the file results. See the "Search for Files" guide for supported syntax.
       */
      public java.lang.String getQ() {
        return q;
      }

      /**
       * A query for filtering the file results. See the "Search for Files" guide for supported
       * syntax.
       */
      public List setQ(java.lang.String q) {
        this.q = q;
        return this;
      }

      /**
       * A comma-separated list of spaces to query within the corpus. Supported values are 'drive',
       * 'appDataFolder' and 'photos'.
       */
      @com.google.api.client.util.Key
      private java.lang.String spaces;

      /** A comma-separated list of spaces to query within the corpus. Supported values are 'drive',
     'appDataFolder' and 'photos'. [default: drive]
       */
      public java.lang.String getSpaces() {
        return spaces;
      }

      /**
       * A comma-separated list of spaces to query within the corpus. Supported values are 'drive',
       * 'appDataFolder' and 'photos'.
       */
      public List setSpaces(java.lang.String spaces) {
        this.spaces = spaces;
        return this;
      }

      /** Whether the requesting application supports Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Whether the requesting application supports Team Drives. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Whether the requesting application supports Team Drives. */
      public List setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports Team Drives.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /** ID of Team Drive to search. */
      @com.google.api.client.util.Key
      private java.lang.String teamDriveId;

      /** ID of Team Drive to search.
       */
      public java.lang.String getTeamDriveId() {
        return teamDriveId;
      }

      /** ID of Team Drive to search. */
      public List setTeamDriveId(java.lang.String teamDriveId) {
        this.teamDriveId = teamDriveId;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a file's metadata and/or content with patch semantics.
     *
     * Create a request for the method "files.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param content the {@link com.google.api.services.drive.model.File}
     * @return the request
     */
    public Update update(java.lang.String fileId, com.google.api.services.drive.model.File content) throws java.io.IOException {
      Update result = new Update(fileId, content);
      initialize(result);
      return result;
    }

    /**
     * Updates a file's metadata and/or content with patch semantics.
     *
     * Create a request for the method "files.update".
     *
     * This request holds the parameters needed by the the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * <p>
     * This method should be used for uploading media content.
     * </p>
     *
     * @param fileId The ID of the file.
     * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
     * @param mediaContent The media HTTP content or {@code null} if none.
     * @return the request
     * @throws java.io.IOException if the initialization of the request fails
     */
    public Update update(java.lang.String fileId, com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent) throws java.io.IOException {
      Update result = new Update(fileId, content, mediaContent);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.File> {

      private static final String REST_PATH = "files/{fileId}";

      /**
       * Updates a file's metadata and/or content with patch semantics.
       *
       * Create a request for the method "files.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param content the {@link com.google.api.services.drive.model.File}
       * @since 1.13
       */
      protected Update(java.lang.String fileId, com.google.api.services.drive.model.File content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.File.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      /**
       * Updates a file's metadata and/or content with patch semantics.
       *
       * Create a request for the method "files.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * <p>
       * This constructor should be used for uploading media content.
       * </p>
       *
       * @param fileId The ID of the file.
       * @param content the {@link com.google.api.services.drive.model.File} media metadata or {@code null} if none
       * @param mediaContent The media HTTP content or {@code null} if none.
       * @since 1.13
       */
      protected Update(java.lang.String fileId, com.google.api.services.drive.model.File content, com.google.api.client.http.AbstractInputStreamContent mediaContent) {
        super(Drive.this, "PATCH", "/upload/" + getServicePath() + REST_PATH, content, com.google.api.services.drive.model.File.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        initializeMediaUpload(mediaContent);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Update setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** A comma-separated list of parent IDs to add. */
      @com.google.api.client.util.Key
      private java.lang.String addParents;

      /** A comma-separated list of parent IDs to add.
       */
      public java.lang.String getAddParents() {
        return addParents;
      }

      /** A comma-separated list of parent IDs to add. */
      public Update setAddParents(java.lang.String addParents) {
        this.addParents = addParents;
        return this;
      }

      /**
       * Whether to set the 'keepForever' field in the new head revision. This is only applicable to
       * files with binary content in Drive.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean keepRevisionForever;

      /** Whether to set the 'keepForever' field in the new head revision. This is only applicable to files
     with binary content in Drive. [default: false]
       */
      public java.lang.Boolean getKeepRevisionForever() {
        return keepRevisionForever;
      }

      /**
       * Whether to set the 'keepForever' field in the new head revision. This is only applicable to
       * files with binary content in Drive.
       */
      public Update setKeepRevisionForever(java.lang.Boolean keepRevisionForever) {
        this.keepRevisionForever = keepRevisionForever;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to set the 'keepForever' field in the new head revision. This is only applicable to files
     with binary content in Drive.
       * </p>
       */
      public boolean isKeepRevisionForever() {
        if (keepRevisionForever == null || keepRevisionForever == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return keepRevisionForever;
      }

      /** A language hint for OCR processing during image import (ISO 639-1 code). */
      @com.google.api.client.util.Key
      private java.lang.String ocrLanguage;

      /** A language hint for OCR processing during image import (ISO 639-1 code).
       */
      public java.lang.String getOcrLanguage() {
        return ocrLanguage;
      }

      /** A language hint for OCR processing during image import (ISO 639-1 code). */
      public Update setOcrLanguage(java.lang.String ocrLanguage) {
        this.ocrLanguage = ocrLanguage;
        return this;
      }

      /** A comma-separated list of parent IDs to remove. */
      @com.google.api.client.util.Key
      private java.lang.String removeParents;

      /** A comma-separated list of parent IDs to remove.
       */
      public java.lang.String getRemoveParents() {
        return removeParents;
      }

      /** A comma-separated list of parent IDs to remove. */
      public Update setRemoveParents(java.lang.String removeParents) {
        this.removeParents = removeParents;
        return this;
      }

      /** Whether the requesting application supports Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Whether the requesting application supports Team Drives. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Whether the requesting application supports Team Drives. */
      public Update setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports Team Drives.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /** Whether to use the uploaded content as indexable text. */
      @com.google.api.client.util.Key
      private java.lang.Boolean useContentAsIndexableText;

      /** Whether to use the uploaded content as indexable text. [default: false]
       */
      public java.lang.Boolean getUseContentAsIndexableText() {
        return useContentAsIndexableText;
      }

      /** Whether to use the uploaded content as indexable text. */
      public Update setUseContentAsIndexableText(java.lang.Boolean useContentAsIndexableText) {
        this.useContentAsIndexableText = useContentAsIndexableText;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to use the uploaded content as indexable text.
       * </p>
       */
      public boolean isUseContentAsIndexableText() {
        if (useContentAsIndexableText == null || useContentAsIndexableText == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useContentAsIndexableText;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }
    /**
     * Subscribes to changes to a file
     *
     * Create a request for the method "files.watch".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Watch#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param content the {@link com.google.api.services.drive.model.Channel}
     * @return the request
     */
    public Watch watch(java.lang.String fileId, com.google.api.services.drive.model.Channel content) throws java.io.IOException {
      Watch result = new Watch(fileId, content);
      initialize(result);
      return result;
    }

    public class Watch extends DriveRequest<com.google.api.services.drive.model.Channel> {

      private static final String REST_PATH = "files/{fileId}/watch";

      /**
       * Subscribes to changes to a file
       *
       * Create a request for the method "files.watch".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Watch#execute()} method to invoke the remote operation. <p> {@link
       * Watch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param content the {@link com.google.api.services.drive.model.Channel}
       * @since 1.13
       */
      protected Watch(java.lang.String fileId, com.google.api.services.drive.model.Channel content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.Channel.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public com.google.api.client.http.GenericUrl buildHttpRequestUrl() {
        java.lang.String baseUrl = ("media".equals(get("alt")) && getMediaHttpUploader() == null)
            ? getRootUrl() + "download/" + getServicePath() : getBaseUrl();
        return new com.google.api.client.http.GenericUrl(
            com.google.api.client.http.UriTemplate.expand(baseUrl, getUriTemplate(), this, true));
      }

      @Override
      public Watch setAlt(java.lang.String alt) {
        return (Watch) super.setAlt(alt);
      }

      @Override
      public Watch setFields(java.lang.String fields) {
        return (Watch) super.setFields(fields);
      }

      @Override
      public Watch setKey(java.lang.String key) {
        return (Watch) super.setKey(key);
      }

      @Override
      public Watch setOauthToken(java.lang.String oauthToken) {
        return (Watch) super.setOauthToken(oauthToken);
      }

      @Override
      public Watch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Watch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Watch setQuotaUser(java.lang.String quotaUser) {
        return (Watch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Watch setUserIp(java.lang.String userIp) {
        return (Watch) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Watch setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * Whether the user is acknowledging the risk of downloading known malware or other abusive
       * files. This is only applicable when alt=media.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean acknowledgeAbuse;

      /** Whether the user is acknowledging the risk of downloading known malware or other abusive files.
     This is only applicable when alt=media. [default: false]
       */
      public java.lang.Boolean getAcknowledgeAbuse() {
        return acknowledgeAbuse;
      }

      /**
       * Whether the user is acknowledging the risk of downloading known malware or other abusive
       * files. This is only applicable when alt=media.
       */
      public Watch setAcknowledgeAbuse(java.lang.Boolean acknowledgeAbuse) {
        this.acknowledgeAbuse = acknowledgeAbuse;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the user is acknowledging the risk of downloading known malware or other abusive files.
     This is only applicable when alt=media.
       * </p>
       */
      public boolean isAcknowledgeAbuse() {
        if (acknowledgeAbuse == null || acknowledgeAbuse == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return acknowledgeAbuse;
      }

      /** Whether the requesting application supports Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Whether the requesting application supports Team Drives. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Whether the requesting application supports Team Drives. */
      public Watch setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports Team Drives.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      @Override
      public Watch set(String parameterName, Object value) {
        return (Watch) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Permissions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Permissions.List request = drive.permissions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Permissions permissions() {
    return new Permissions();
  }

  /**
   * The "permissions" collection of methods.
   */
  public class Permissions {

    /**
     * Creates a permission for a file or Team Drive.
     *
     * Create a request for the method "permissions.create".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file or Team Drive.
     * @param content the {@link com.google.api.services.drive.model.Permission}
     * @return the request
     */
    public Create create(java.lang.String fileId, com.google.api.services.drive.model.Permission content) throws java.io.IOException {
      Create result = new Create(fileId, content);
      initialize(result);
      return result;
    }

    public class Create extends DriveRequest<com.google.api.services.drive.model.Permission> {

      private static final String REST_PATH = "files/{fileId}/permissions";

      /**
       * Creates a permission for a file or Team Drive.
       *
       * Create a request for the method "permissions.create".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file or Team Drive.
       * @param content the {@link com.google.api.services.drive.model.Permission}
       * @since 1.13
       */
      protected Create(java.lang.String fileId, com.google.api.services.drive.model.Permission content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.Permission.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getRole(), "Permission.getRole()");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getType(), "Permission.getType()");
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUserIp(java.lang.String userIp) {
        return (Create) super.setUserIp(userIp);
      }

      /** The ID of the file or Team Drive. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file or Team Drive.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file or Team Drive. */
      public Create setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** A plain text custom message to include in the notification email. */
      @com.google.api.client.util.Key
      private java.lang.String emailMessage;

      /** A plain text custom message to include in the notification email.
       */
      public java.lang.String getEmailMessage() {
        return emailMessage;
      }

      /** A plain text custom message to include in the notification email. */
      public Create setEmailMessage(java.lang.String emailMessage) {
        this.emailMessage = emailMessage;
        return this;
      }

      /**
       * Whether to send a notification email when sharing to users or groups. This defaults to true
       * for users and groups, and is not allowed for other requests. It must not be disabled for
       * ownership transfers.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean sendNotificationEmail;

      /** Whether to send a notification email when sharing to users or groups. This defaults to true for
     users and groups, and is not allowed for other requests. It must not be disabled for ownership
     transfers.
       */
      public java.lang.Boolean getSendNotificationEmail() {
        return sendNotificationEmail;
      }

      /**
       * Whether to send a notification email when sharing to users or groups. This defaults to true
       * for users and groups, and is not allowed for other requests. It must not be disabled for
       * ownership transfers.
       */
      public Create setSendNotificationEmail(java.lang.Boolean sendNotificationEmail) {
        this.sendNotificationEmail = sendNotificationEmail;
        return this;
      }

      /** Whether the requesting application supports Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Whether the requesting application supports Team Drives. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Whether the requesting application supports Team Drives. */
      public Create setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports Team Drives.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /**
       * Whether to transfer ownership to the specified user and downgrade the current owner to a
       * writer. This parameter is required as an acknowledgement of the side effect.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean transferOwnership;

      /** Whether to transfer ownership to the specified user and downgrade the current owner to a writer.
     This parameter is required as an acknowledgement of the side effect. [default: false]
       */
      public java.lang.Boolean getTransferOwnership() {
        return transferOwnership;
      }

      /**
       * Whether to transfer ownership to the specified user and downgrade the current owner to a
       * writer. This parameter is required as an acknowledgement of the side effect.
       */
      public Create setTransferOwnership(java.lang.Boolean transferOwnership) {
        this.transferOwnership = transferOwnership;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to transfer ownership to the specified user and downgrade the current owner to a writer.
     This parameter is required as an acknowledgement of the side effect.
       * </p>
       */
      public boolean isTransferOwnership() {
        if (transferOwnership == null || transferOwnership == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return transferOwnership;
      }

      /**
       * Whether the request should be treated as if it was issued by a domain administrator; if set
       * to true, then the requester will be granted access if they are an administrator of the
       * domain to which the item belongs.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Whether the request should be treated as if it was issued by a domain administrator; if set to
     true, then the requester will be granted access if they are an administrator of the domain to which
     the item belongs. [default: false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Whether the request should be treated as if it was issued by a domain administrator; if set
       * to true, then the requester will be granted access if they are an administrator of the
       * domain to which the item belongs.
       */
      public Create setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the request should be treated as if it was issued by a domain administrator; if set to
     true, then the requester will be granted access if they are an administrator of the domain to which
     the item belongs.
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a permission.
     *
     * Create a request for the method "permissions.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file or Team Drive.
     * @param permissionId The ID of the permission.
     * @return the request
     */
    public Delete delete(java.lang.String fileId, java.lang.String permissionId) throws java.io.IOException {
      Delete result = new Delete(fileId, permissionId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";

      /**
       * Deletes a permission.
       *
       * Create a request for the method "permissions.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file or Team Drive.
       * @param permissionId The ID of the permission.
       * @since 1.13
       */
      protected Delete(java.lang.String fileId, java.lang.String permissionId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.permissionId = com.google.api.client.util.Preconditions.checkNotNull(permissionId, "Required parameter permissionId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The ID of the file or Team Drive. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file or Team Drive.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file or Team Drive. */
      public Delete setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the permission. */
      @com.google.api.client.util.Key
      private java.lang.String permissionId;

      /** The ID of the permission.
       */
      public java.lang.String getPermissionId() {
        return permissionId;
      }

      /** The ID of the permission. */
      public Delete setPermissionId(java.lang.String permissionId) {
        this.permissionId = permissionId;
        return this;
      }

      /** Whether the requesting application supports Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Whether the requesting application supports Team Drives. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Whether the requesting application supports Team Drives. */
      public Delete setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports Team Drives.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /**
       * Whether the request should be treated as if it was issued by a domain administrator; if set
       * to true, then the requester will be granted access if they are an administrator of the
       * domain to which the item belongs.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Whether the request should be treated as if it was issued by a domain administrator; if set to
     true, then the requester will be granted access if they are an administrator of the domain to which
     the item belongs. [default: false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Whether the request should be treated as if it was issued by a domain administrator; if set
       * to true, then the requester will be granted access if they are an administrator of the
       * domain to which the item belongs.
       */
      public Delete setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the request should be treated as if it was issued by a domain administrator; if set to
     true, then the requester will be granted access if they are an administrator of the domain to which
     the item belongs.
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a permission by ID.
     *
     * Create a request for the method "permissions.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param permissionId The ID of the permission.
     * @return the request
     */
    public Get get(java.lang.String fileId, java.lang.String permissionId) throws java.io.IOException {
      Get result = new Get(fileId, permissionId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.Permission> {

      private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";

      /**
       * Gets a permission by ID.
       *
       * Create a request for the method "permissions.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param permissionId The ID of the permission.
       * @since 1.13
       */
      protected Get(java.lang.String fileId, java.lang.String permissionId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Permission.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.permissionId = com.google.api.client.util.Preconditions.checkNotNull(permissionId, "Required parameter permissionId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the permission. */
      @com.google.api.client.util.Key
      private java.lang.String permissionId;

      /** The ID of the permission.
       */
      public java.lang.String getPermissionId() {
        return permissionId;
      }

      /** The ID of the permission. */
      public Get setPermissionId(java.lang.String permissionId) {
        this.permissionId = permissionId;
        return this;
      }

      /** Whether the requesting application supports Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Whether the requesting application supports Team Drives. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Whether the requesting application supports Team Drives. */
      public Get setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports Team Drives.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /**
       * Whether the request should be treated as if it was issued by a domain administrator; if set
       * to true, then the requester will be granted access if they are an administrator of the
       * domain to which the item belongs.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Whether the request should be treated as if it was issued by a domain administrator; if set to
     true, then the requester will be granted access if they are an administrator of the domain to which
     the item belongs. [default: false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Whether the request should be treated as if it was issued by a domain administrator; if set
       * to true, then the requester will be granted access if they are an administrator of the
       * domain to which the item belongs.
       */
      public Get setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the request should be treated as if it was issued by a domain administrator; if set to
     true, then the requester will be granted access if they are an administrator of the domain to which
     the item belongs.
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists a file's or Team Drive's permissions.
     *
     * Create a request for the method "permissions.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file or Team Drive.
     * @return the request
     */
    public List list(java.lang.String fileId) throws java.io.IOException {
      List result = new List(fileId);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.PermissionList> {

      private static final String REST_PATH = "files/{fileId}/permissions";

      /**
       * Lists a file's or Team Drive's permissions.
       *
       * Create a request for the method "permissions.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file or Team Drive.
       * @since 1.13
       */
      protected List(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.PermissionList.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The ID of the file or Team Drive. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file or Team Drive.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file or Team Drive. */
      public List setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /**
       * The maximum number of permissions to return per page. When not set for files in a Team
       * Drive, at most 100 results will be returned. When not set for files that are not in a Team
       * Drive, the entire list will be returned.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of permissions to return per page. When not set for files in a Team Drive, at
     most 100 results will be returned. When not set for files that are not in a Team Drive, the entire
     list will be returned.

     [minimum: 1] [maximum: 100]
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * The maximum number of permissions to return per page. When not set for files in a Team
       * Drive, at most 100 results will be returned. When not set for files that are not in a Team
       * Drive, the entire list will be returned.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of 'nextPageToken' from the previous response.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Whether the requesting application supports Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Whether the requesting application supports Team Drives. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Whether the requesting application supports Team Drives. */
      public List setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports Team Drives.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /**
       * Whether the request should be treated as if it was issued by a domain administrator; if set
       * to true, then the requester will be granted access if they are an administrator of the
       * domain to which the item belongs.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Whether the request should be treated as if it was issued by a domain administrator; if set to
     true, then the requester will be granted access if they are an administrator of the domain to which
     the item belongs. [default: false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Whether the request should be treated as if it was issued by a domain administrator; if set
       * to true, then the requester will be granted access if they are an administrator of the
       * domain to which the item belongs.
       */
      public List setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the request should be treated as if it was issued by a domain administrator; if set to
     true, then the requester will be granted access if they are an administrator of the domain to which
     the item belongs.
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a permission with patch semantics.
     *
     * Create a request for the method "permissions.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file or Team Drive.
     * @param permissionId The ID of the permission.
     * @param content the {@link com.google.api.services.drive.model.Permission}
     * @return the request
     */
    public Update update(java.lang.String fileId, java.lang.String permissionId, com.google.api.services.drive.model.Permission content) throws java.io.IOException {
      Update result = new Update(fileId, permissionId, content);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.Permission> {

      private static final String REST_PATH = "files/{fileId}/permissions/{permissionId}";

      /**
       * Updates a permission with patch semantics.
       *
       * Create a request for the method "permissions.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file or Team Drive.
       * @param permissionId The ID of the permission.
       * @param content the {@link com.google.api.services.drive.model.Permission}
       * @since 1.13
       */
      protected Update(java.lang.String fileId, java.lang.String permissionId, com.google.api.services.drive.model.Permission content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.Permission.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.permissionId = com.google.api.client.util.Preconditions.checkNotNull(permissionId, "Required parameter permissionId must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** The ID of the file or Team Drive. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file or Team Drive.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file or Team Drive. */
      public Update setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the permission. */
      @com.google.api.client.util.Key
      private java.lang.String permissionId;

      /** The ID of the permission.
       */
      public java.lang.String getPermissionId() {
        return permissionId;
      }

      /** The ID of the permission. */
      public Update setPermissionId(java.lang.String permissionId) {
        this.permissionId = permissionId;
        return this;
      }

      /** Whether to remove the expiration date. */
      @com.google.api.client.util.Key
      private java.lang.Boolean removeExpiration;

      /** Whether to remove the expiration date. [default: false]
       */
      public java.lang.Boolean getRemoveExpiration() {
        return removeExpiration;
      }

      /** Whether to remove the expiration date. */
      public Update setRemoveExpiration(java.lang.Boolean removeExpiration) {
        this.removeExpiration = removeExpiration;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to remove the expiration date.
       * </p>
       */
      public boolean isRemoveExpiration() {
        if (removeExpiration == null || removeExpiration == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return removeExpiration;
      }

      /** Whether the requesting application supports Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.Boolean supportsTeamDrives;

      /** Whether the requesting application supports Team Drives. [default: false]
       */
      public java.lang.Boolean getSupportsTeamDrives() {
        return supportsTeamDrives;
      }

      /** Whether the requesting application supports Team Drives. */
      public Update setSupportsTeamDrives(java.lang.Boolean supportsTeamDrives) {
        this.supportsTeamDrives = supportsTeamDrives;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the requesting application supports Team Drives.
       * </p>
       */
      public boolean isSupportsTeamDrives() {
        if (supportsTeamDrives == null || supportsTeamDrives == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return supportsTeamDrives;
      }

      /**
       * Whether to transfer ownership to the specified user and downgrade the current owner to a
       * writer. This parameter is required as an acknowledgement of the side effect.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean transferOwnership;

      /** Whether to transfer ownership to the specified user and downgrade the current owner to a writer.
     This parameter is required as an acknowledgement of the side effect. [default: false]
       */
      public java.lang.Boolean getTransferOwnership() {
        return transferOwnership;
      }

      /**
       * Whether to transfer ownership to the specified user and downgrade the current owner to a
       * writer. This parameter is required as an acknowledgement of the side effect.
       */
      public Update setTransferOwnership(java.lang.Boolean transferOwnership) {
        this.transferOwnership = transferOwnership;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to transfer ownership to the specified user and downgrade the current owner to a writer.
     This parameter is required as an acknowledgement of the side effect.
       * </p>
       */
      public boolean isTransferOwnership() {
        if (transferOwnership == null || transferOwnership == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return transferOwnership;
      }

      /**
       * Whether the request should be treated as if it was issued by a domain administrator; if set
       * to true, then the requester will be granted access if they are an administrator of the
       * domain to which the item belongs.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Whether the request should be treated as if it was issued by a domain administrator; if set to
     true, then the requester will be granted access if they are an administrator of the domain to which
     the item belongs. [default: false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Whether the request should be treated as if it was issued by a domain administrator; if set
       * to true, then the requester will be granted access if they are an administrator of the
       * domain to which the item belongs.
       */
      public Update setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the request should be treated as if it was issued by a domain administrator; if set to
     true, then the requester will be granted access if they are an administrator of the domain to which
     the item belongs.
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Replies collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Replies.List request = drive.replies().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Replies replies() {
    return new Replies();
  }

  /**
   * The "replies" collection of methods.
   */
  public class Replies {

    /**
     * Creates a new reply to a comment.
     *
     * Create a request for the method "replies.create".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @param content the {@link com.google.api.services.drive.model.Reply}
     * @return the request
     */
    public Create create(java.lang.String fileId, java.lang.String commentId, com.google.api.services.drive.model.Reply content) throws java.io.IOException {
      Create result = new Create(fileId, commentId, content);
      initialize(result);
      return result;
    }

    public class Create extends DriveRequest<com.google.api.services.drive.model.Reply> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies";

      /**
       * Creates a new reply to a comment.
       *
       * Create a request for the method "replies.create".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @param content the {@link com.google.api.services.drive.model.Reply}
       * @since 1.13
       */
      protected Create(java.lang.String fileId, java.lang.String commentId, com.google.api.services.drive.model.Reply content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.Reply.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUserIp(java.lang.String userIp) {
        return (Create) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Create setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Create setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Deletes a reply.
     *
     * Create a request for the method "replies.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @param replyId The ID of the reply.
     * @return the request
     */
    public Delete delete(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId) throws java.io.IOException {
      Delete result = new Delete(fileId, commentId, replyId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";

      /**
       * Deletes a reply.
       *
       * Create a request for the method "replies.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @param replyId The ID of the reply.
       * @since 1.13
       */
      protected Delete(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
        this.replyId = com.google.api.client.util.Preconditions.checkNotNull(replyId, "Required parameter replyId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Delete setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Delete setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      /** The ID of the reply. */
      @com.google.api.client.util.Key
      private java.lang.String replyId;

      /** The ID of the reply.
       */
      public java.lang.String getReplyId() {
        return replyId;
      }

      /** The ID of the reply. */
      public Delete setReplyId(java.lang.String replyId) {
        this.replyId = replyId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a reply by ID.
     *
     * Create a request for the method "replies.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @param replyId The ID of the reply.
     * @return the request
     */
    public Get get(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId) throws java.io.IOException {
      Get result = new Get(fileId, commentId, replyId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.Reply> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";

      /**
       * Gets a reply by ID.
       *
       * Create a request for the method "replies.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @param replyId The ID of the reply.
       * @since 1.13
       */
      protected Get(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Reply.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
        this.replyId = com.google.api.client.util.Preconditions.checkNotNull(replyId, "Required parameter replyId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Get setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      /** The ID of the reply. */
      @com.google.api.client.util.Key
      private java.lang.String replyId;

      /** The ID of the reply.
       */
      public java.lang.String getReplyId() {
        return replyId;
      }

      /** The ID of the reply. */
      public Get setReplyId(java.lang.String replyId) {
        this.replyId = replyId;
        return this;
      }

      /**
       * Whether to return deleted replies. Deleted replies will not include their original content.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeDeleted;

      /** Whether to return deleted replies. Deleted replies will not include their original content.
     [default: false]
       */
      public java.lang.Boolean getIncludeDeleted() {
        return includeDeleted;
      }

      /**
       * Whether to return deleted replies. Deleted replies will not include their original content.
       */
      public Get setIncludeDeleted(java.lang.Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to return deleted replies. Deleted replies will not include their original content.
       * </p>
       */
      public boolean isIncludeDeleted() {
        if (includeDeleted == null || includeDeleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeDeleted;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists a comment's replies.
     *
     * Create a request for the method "replies.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @return the request
     */
    public List list(java.lang.String fileId, java.lang.String commentId) throws java.io.IOException {
      List result = new List(fileId, commentId);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.ReplyList> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies";

      /**
       * Lists a comment's replies.
       *
       * Create a request for the method "replies.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @since 1.13
       */
      protected List(java.lang.String fileId, java.lang.String commentId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.ReplyList.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public List setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public List setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      /**
       * Whether to include deleted replies. Deleted replies will not include their original
       * content.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean includeDeleted;

      /** Whether to include deleted replies. Deleted replies will not include their original content.
     [default: false]
       */
      public java.lang.Boolean getIncludeDeleted() {
        return includeDeleted;
      }

      /**
       * Whether to include deleted replies. Deleted replies will not include their original
       * content.
       */
      public List setIncludeDeleted(java.lang.Boolean includeDeleted) {
        this.includeDeleted = includeDeleted;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether to include deleted replies. Deleted replies will not include their original content.
       * </p>
       */
      public boolean isIncludeDeleted() {
        if (includeDeleted == null || includeDeleted == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return includeDeleted;
      }

      /** The maximum number of replies to return per page. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of replies to return per page. [default: 20] [minimum: 1] [maximum: 100]
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** The maximum number of replies to return per page. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of 'nextPageToken' from the previous response.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a reply with patch semantics.
     *
     * Create a request for the method "replies.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param commentId The ID of the comment.
     * @param replyId The ID of the reply.
     * @param content the {@link com.google.api.services.drive.model.Reply}
     * @return the request
     */
    public Update update(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId, com.google.api.services.drive.model.Reply content) throws java.io.IOException {
      Update result = new Update(fileId, commentId, replyId, content);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.Reply> {

      private static final String REST_PATH = "files/{fileId}/comments/{commentId}/replies/{replyId}";

      /**
       * Updates a reply with patch semantics.
       *
       * Create a request for the method "replies.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param commentId The ID of the comment.
       * @param replyId The ID of the reply.
       * @param content the {@link com.google.api.services.drive.model.Reply}
       * @since 1.13
       */
      protected Update(java.lang.String fileId, java.lang.String commentId, java.lang.String replyId, com.google.api.services.drive.model.Reply content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.Reply.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.commentId = com.google.api.client.util.Preconditions.checkNotNull(commentId, "Required parameter commentId must be specified.");
        this.replyId = com.google.api.client.util.Preconditions.checkNotNull(replyId, "Required parameter replyId must be specified.");
        checkRequiredParameter(content, "content");
        checkRequiredParameter(content.getContent(), "Reply.getContent()");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Update setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the comment. */
      @com.google.api.client.util.Key
      private java.lang.String commentId;

      /** The ID of the comment.
       */
      public java.lang.String getCommentId() {
        return commentId;
      }

      /** The ID of the comment. */
      public Update setCommentId(java.lang.String commentId) {
        this.commentId = commentId;
        return this;
      }

      /** The ID of the reply. */
      @com.google.api.client.util.Key
      private java.lang.String replyId;

      /** The ID of the reply.
       */
      public java.lang.String getReplyId() {
        return replyId;
      }

      /** The ID of the reply. */
      public Update setReplyId(java.lang.String replyId) {
        this.replyId = replyId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Revisions collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Revisions.List request = drive.revisions().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Revisions revisions() {
    return new Revisions();
  }

  /**
   * The "revisions" collection of methods.
   */
  public class Revisions {

    /**
     * Permanently deletes a revision. This method is only applicable to files with binary content in
     * Drive.
     *
     * Create a request for the method "revisions.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param revisionId The ID of the revision.
     * @return the request
     */
    public Delete delete(java.lang.String fileId, java.lang.String revisionId) throws java.io.IOException {
      Delete result = new Delete(fileId, revisionId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";

      /**
       * Permanently deletes a revision. This method is only applicable to files with binary content in
       * Drive.
       *
       * Create a request for the method "revisions.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param revisionId The ID of the revision.
       * @since 1.13
       */
      protected Delete(java.lang.String fileId, java.lang.String revisionId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.revisionId = com.google.api.client.util.Preconditions.checkNotNull(revisionId, "Required parameter revisionId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Delete setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the revision. */
      @com.google.api.client.util.Key
      private java.lang.String revisionId;

      /** The ID of the revision.
       */
      public java.lang.String getRevisionId() {
        return revisionId;
      }

      /** The ID of the revision. */
      public Delete setRevisionId(java.lang.String revisionId) {
        this.revisionId = revisionId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a revision's metadata or content by ID.
     *
     * Create a request for the method "revisions.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param revisionId The ID of the revision.
     * @return the request
     */
    public Get get(java.lang.String fileId, java.lang.String revisionId) throws java.io.IOException {
      Get result = new Get(fileId, revisionId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.Revision> {

      private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";

      /**
       * Gets a revision's metadata or content by ID.
       *
       * Create a request for the method "revisions.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param revisionId The ID of the revision.
       * @since 1.13
       */
      protected Get(java.lang.String fileId, java.lang.String revisionId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.Revision.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.revisionId = com.google.api.client.util.Preconditions.checkNotNull(revisionId, "Required parameter revisionId must be specified.");
        initializeMediaDownload();
      }

      @Override
      public void executeMediaAndDownloadTo(java.io.OutputStream outputStream) throws java.io.IOException {
        super.executeMediaAndDownloadTo(outputStream);
      }

      @Override
      public java.io.InputStream executeMediaAsInputStream() throws java.io.IOException {
        return super.executeMediaAsInputStream();
      }

      @Override
      public com.google.api.client.http.HttpResponse executeMedia() throws java.io.IOException {
        return super.executeMedia();
      }

      @Override
      public com.google.api.client.http.GenericUrl buildHttpRequestUrl() {
        java.lang.String baseUrl = ("media".equals(get("alt")) && getMediaHttpUploader() == null)
            ? getRootUrl() + "download/" + getServicePath() : getBaseUrl();
        return new com.google.api.client.http.GenericUrl(
            com.google.api.client.http.UriTemplate.expand(baseUrl, getUriTemplate(), this, true));
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Get setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the revision. */
      @com.google.api.client.util.Key
      private java.lang.String revisionId;

      /** The ID of the revision.
       */
      public java.lang.String getRevisionId() {
        return revisionId;
      }

      /** The ID of the revision. */
      public Get setRevisionId(java.lang.String revisionId) {
        this.revisionId = revisionId;
        return this;
      }

      /**
       * Whether the user is acknowledging the risk of downloading known malware or other abusive
       * files. This is only applicable when alt=media.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean acknowledgeAbuse;

      /** Whether the user is acknowledging the risk of downloading known malware or other abusive files.
     This is only applicable when alt=media. [default: false]
       */
      public java.lang.Boolean getAcknowledgeAbuse() {
        return acknowledgeAbuse;
      }

      /**
       * Whether the user is acknowledging the risk of downloading known malware or other abusive
       * files. This is only applicable when alt=media.
       */
      public Get setAcknowledgeAbuse(java.lang.Boolean acknowledgeAbuse) {
        this.acknowledgeAbuse = acknowledgeAbuse;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the user is acknowledging the risk of downloading known malware or other abusive files.
     This is only applicable when alt=media.
       * </p>
       */
      public boolean isAcknowledgeAbuse() {
        if (acknowledgeAbuse == null || acknowledgeAbuse == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return acknowledgeAbuse;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists a file's revisions.
     *
     * Create a request for the method "revisions.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @return the request
     */
    public List list(java.lang.String fileId) throws java.io.IOException {
      List result = new List(fileId);
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.RevisionList> {

      private static final String REST_PATH = "files/{fileId}/revisions";

      /**
       * Lists a file's revisions.
       *
       * Create a request for the method "revisions.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @since 1.13
       */
      protected List(java.lang.String fileId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.RevisionList.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public List setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The maximum number of revisions to return per page. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** The maximum number of revisions to return per page. [default: 200] [minimum: 1] [maximum: 1000]
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** The maximum number of revisions to return per page. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** The token for continuing a previous list request on the next page. This should be set to the value
     of 'nextPageToken' from the previous response.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * The token for continuing a previous list request on the next page. This should be set to
       * the value of 'nextPageToken' from the previous response.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a revision with patch semantics.
     *
     * Create a request for the method "revisions.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param fileId The ID of the file.
     * @param revisionId The ID of the revision.
     * @param content the {@link com.google.api.services.drive.model.Revision}
     * @return the request
     */
    public Update update(java.lang.String fileId, java.lang.String revisionId, com.google.api.services.drive.model.Revision content) throws java.io.IOException {
      Update result = new Update(fileId, revisionId, content);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.Revision> {

      private static final String REST_PATH = "files/{fileId}/revisions/{revisionId}";

      /**
       * Updates a revision with patch semantics.
       *
       * Create a request for the method "revisions.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param fileId The ID of the file.
       * @param revisionId The ID of the revision.
       * @param content the {@link com.google.api.services.drive.model.Revision}
       * @since 1.13
       */
      protected Update(java.lang.String fileId, java.lang.String revisionId, com.google.api.services.drive.model.Revision content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.Revision.class);
        this.fileId = com.google.api.client.util.Preconditions.checkNotNull(fileId, "Required parameter fileId must be specified.");
        this.revisionId = com.google.api.client.util.Preconditions.checkNotNull(revisionId, "Required parameter revisionId must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** The ID of the file. */
      @com.google.api.client.util.Key
      private java.lang.String fileId;

      /** The ID of the file.
       */
      public java.lang.String getFileId() {
        return fileId;
      }

      /** The ID of the file. */
      public Update setFileId(java.lang.String fileId) {
        this.fileId = fileId;
        return this;
      }

      /** The ID of the revision. */
      @com.google.api.client.util.Key
      private java.lang.String revisionId;

      /** The ID of the revision.
       */
      public java.lang.String getRevisionId() {
        return revisionId;
      }

      /** The ID of the revision. */
      public Update setRevisionId(java.lang.String revisionId) {
        this.revisionId = revisionId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Teamdrives collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code Drive drive = new Drive(...);}
   *   {@code Drive.Teamdrives.List request = drive.teamdrives().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Teamdrives teamdrives() {
    return new Teamdrives();
  }

  /**
   * The "teamdrives" collection of methods.
   */
  public class Teamdrives {

    /**
     * Creates a new Team Drive.
     *
     * Create a request for the method "teamdrives.create".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param requestId An ID, such as a random UUID, which uniquely identifies this user's request for idempotent creation
     *        of a Team Drive. A repeated request by the same user and with the same request ID will
     *        avoid creating duplicates by attempting to create the same Team Drive. If the Team Drive
     *        already exists a 409 error will be returned.
     * @param content the {@link com.google.api.services.drive.model.TeamDrive}
     * @return the request
     */
    public Create create(java.lang.String requestId, com.google.api.services.drive.model.TeamDrive content) throws java.io.IOException {
      Create result = new Create(requestId, content);
      initialize(result);
      return result;
    }

    public class Create extends DriveRequest<com.google.api.services.drive.model.TeamDrive> {

      private static final String REST_PATH = "teamdrives";

      /**
       * Creates a new Team Drive.
       *
       * Create a request for the method "teamdrives.create".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param requestId An ID, such as a random UUID, which uniquely identifies this user's request for idempotent creation
     *        of a Team Drive. A repeated request by the same user and with the same request ID will
     *        avoid creating duplicates by attempting to create the same Team Drive. If the Team Drive
     *        already exists a 409 error will be returned.
       * @param content the {@link com.google.api.services.drive.model.TeamDrive}
       * @since 1.13
       */
      protected Create(java.lang.String requestId, com.google.api.services.drive.model.TeamDrive content) {
        super(Drive.this, "POST", REST_PATH, content, com.google.api.services.drive.model.TeamDrive.class);
        this.requestId = com.google.api.client.util.Preconditions.checkNotNull(requestId, "Required parameter requestId must be specified.");
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUserIp(java.lang.String userIp) {
        return (Create) super.setUserIp(userIp);
      }

      /**
       * An ID, such as a random UUID, which uniquely identifies this user's request for idempotent
       * creation of a Team Drive. A repeated request by the same user and with the same request ID
       * will avoid creating duplicates by attempting to create the same Team Drive. If the Team
       * Drive already exists a 409 error will be returned.
       */
      @com.google.api.client.util.Key
      private java.lang.String requestId;

      /** An ID, such as a random UUID, which uniquely identifies this user's request for idempotent creation
     of a Team Drive. A repeated request by the same user and with the same request ID will avoid
     creating duplicates by attempting to create the same Team Drive. If the Team Drive already exists a
     409 error will be returned.
       */
      public java.lang.String getRequestId() {
        return requestId;
      }

      /**
       * An ID, such as a random UUID, which uniquely identifies this user's request for idempotent
       * creation of a Team Drive. A repeated request by the same user and with the same request ID
       * will avoid creating duplicates by attempting to create the same Team Drive. If the Team
       * Drive already exists a 409 error will be returned.
       */
      public Create setRequestId(java.lang.String requestId) {
        this.requestId = requestId;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Permanently deletes a Team Drive for which the user is an organizer. The Team Drive cannot
     * contain any untrashed items.
     *
     * Create a request for the method "teamdrives.delete".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
     *
     * @param teamDriveId The ID of the Team Drive
     * @return the request
     */
    public Delete delete(java.lang.String teamDriveId) throws java.io.IOException {
      Delete result = new Delete(teamDriveId);
      initialize(result);
      return result;
    }

    public class Delete extends DriveRequest<Void> {

      private static final String REST_PATH = "teamdrives/{teamDriveId}";

      /**
       * Permanently deletes a Team Drive for which the user is an organizer. The Team Drive cannot
       * contain any untrashed items.
       *
       * Create a request for the method "teamdrives.delete".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation. <p> {@link
       * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param teamDriveId The ID of the Team Drive
       * @since 1.13
       */
      protected Delete(java.lang.String teamDriveId) {
        super(Drive.this, "DELETE", REST_PATH, null, Void.class);
        this.teamDriveId = com.google.api.client.util.Preconditions.checkNotNull(teamDriveId, "Required parameter teamDriveId must be specified.");
      }

      @Override
      public Delete setAlt(java.lang.String alt) {
        return (Delete) super.setAlt(alt);
      }

      @Override
      public Delete setFields(java.lang.String fields) {
        return (Delete) super.setFields(fields);
      }

      @Override
      public Delete setKey(java.lang.String key) {
        return (Delete) super.setKey(key);
      }

      @Override
      public Delete setOauthToken(java.lang.String oauthToken) {
        return (Delete) super.setOauthToken(oauthToken);
      }

      @Override
      public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Delete) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Delete setQuotaUser(java.lang.String quotaUser) {
        return (Delete) super.setQuotaUser(quotaUser);
      }

      @Override
      public Delete setUserIp(java.lang.String userIp) {
        return (Delete) super.setUserIp(userIp);
      }

      /** The ID of the Team Drive */
      @com.google.api.client.util.Key
      private java.lang.String teamDriveId;

      /** The ID of the Team Drive
       */
      public java.lang.String getTeamDriveId() {
        return teamDriveId;
      }

      /** The ID of the Team Drive */
      public Delete setTeamDriveId(java.lang.String teamDriveId) {
        this.teamDriveId = teamDriveId;
        return this;
      }

      @Override
      public Delete set(String parameterName, Object value) {
        return (Delete) super.set(parameterName, value);
      }
    }
    /**
     * Gets a Team Drive's metadata by ID.
     *
     * Create a request for the method "teamdrives.get".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param teamDriveId The ID of the Team Drive
     * @return the request
     */
    public Get get(java.lang.String teamDriveId) throws java.io.IOException {
      Get result = new Get(teamDriveId);
      initialize(result);
      return result;
    }

    public class Get extends DriveRequest<com.google.api.services.drive.model.TeamDrive> {

      private static final String REST_PATH = "teamdrives/{teamDriveId}";

      /**
       * Gets a Team Drive's metadata by ID.
       *
       * Create a request for the method "teamdrives.get".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param teamDriveId The ID of the Team Drive
       * @since 1.13
       */
      protected Get(java.lang.String teamDriveId) {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.TeamDrive.class);
        this.teamDriveId = com.google.api.client.util.Preconditions.checkNotNull(teamDriveId, "Required parameter teamDriveId must be specified.");
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUserIp(java.lang.String userIp) {
        return (Get) super.setUserIp(userIp);
      }

      /** The ID of the Team Drive */
      @com.google.api.client.util.Key
      private java.lang.String teamDriveId;

      /** The ID of the Team Drive
       */
      public java.lang.String getTeamDriveId() {
        return teamDriveId;
      }

      /** The ID of the Team Drive */
      public Get setTeamDriveId(java.lang.String teamDriveId) {
        this.teamDriveId = teamDriveId;
        return this;
      }

      /**
       * Whether the request should be treated as if it was issued by a domain administrator; if set
       * to true, then the requester will be granted access if they are an administrator of the
       * domain to which the Team Drive belongs.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Whether the request should be treated as if it was issued by a domain administrator; if set to
     true, then the requester will be granted access if they are an administrator of the domain to which
     the Team Drive belongs. [default: false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Whether the request should be treated as if it was issued by a domain administrator; if set
       * to true, then the requester will be granted access if they are an administrator of the
       * domain to which the Team Drive belongs.
       */
      public Get setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the request should be treated as if it was issued by a domain administrator; if set to
     true, then the requester will be granted access if they are an administrator of the domain to which
     the Team Drive belongs.
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists the user's Team Drives.
     *
     * Create a request for the method "teamdrives.list".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends DriveRequest<com.google.api.services.drive.model.TeamDriveList> {

      private static final String REST_PATH = "teamdrives";

      /**
       * Lists the user's Team Drives.
       *
       * Create a request for the method "teamdrives.list".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(Drive.this, "GET", REST_PATH, null, com.google.api.services.drive.model.TeamDriveList.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUserIp(java.lang.String userIp) {
        return (List) super.setUserIp(userIp);
      }

      /** Maximum number of Team Drives to return. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Maximum number of Team Drives to return. [default: 10] [minimum: 1] [maximum: 100]
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** Maximum number of Team Drives to return. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /** Page token for Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Page token for Team Drives.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** Page token for Team Drives. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** Query string for searching Team Drives. */
      @com.google.api.client.util.Key
      private java.lang.String q;

      /** Query string for searching Team Drives.
       */
      public java.lang.String getQ() {
        return q;
      }

      /** Query string for searching Team Drives. */
      public List setQ(java.lang.String q) {
        this.q = q;
        return this;
      }

      /**
       * Whether the request should be treated as if it was issued by a domain administrator; if set
       * to true, then all Team Drives of the domain in which the requester is an administrator are
       * returned.
       */
      @com.google.api.client.util.Key
      private java.lang.Boolean useDomainAdminAccess;

      /** Whether the request should be treated as if it was issued by a domain administrator; if set to
     true, then all Team Drives of the domain in which the requester is an administrator are returned.
     [default: false]
       */
      public java.lang.Boolean getUseDomainAdminAccess() {
        return useDomainAdminAccess;
      }

      /**
       * Whether the request should be treated as if it was issued by a domain administrator; if set
       * to true, then all Team Drives of the domain in which the requester is an administrator are
       * returned.
       */
      public List setUseDomainAdminAccess(java.lang.Boolean useDomainAdminAccess) {
        this.useDomainAdminAccess = useDomainAdminAccess;
        return this;
      }

      /**
       * Convenience method that returns only {@link Boolean#TRUE} or {@link Boolean#FALSE}.
       *
       * <p>
       * Boolean properties can have four possible values:
       * {@code null}, {@link com.google.api.client.util.Data#NULL_BOOLEAN}, {@link Boolean#TRUE}
       * or {@link Boolean#FALSE}.
       * </p>
       *
       * <p>
       * This method returns {@link Boolean#TRUE} if the default of the property is {@link Boolean#TRUE}
       * and it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * {@link Boolean#FALSE} is returned if the default of the property is {@link Boolean#FALSE} and
       * it is {@code null} or {@link com.google.api.client.util.Data#NULL_BOOLEAN}.
       * </p>
       *
       * <p>
       * Whether the request should be treated as if it was issued by a domain administrator; if set to
     true, then all Team Drives of the domain in which the requester is an administrator are returned.
       * </p>
       */
      public boolean isUseDomainAdminAccess() {
        if (useDomainAdminAccess == null || useDomainAdminAccess == com.google.api.client.util.Data.NULL_BOOLEAN) {
          return false;
        }
        return useDomainAdminAccess;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates a Team Drive's metadata
     *
     * Create a request for the method "teamdrives.update".
     *
     * This request holds the parameters needed by the drive server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param teamDriveId The ID of the Team Drive
     * @param content the {@link com.google.api.services.drive.model.TeamDrive}
     * @return the request
     */
    public Update update(java.lang.String teamDriveId, com.google.api.services.drive.model.TeamDrive content) throws java.io.IOException {
      Update result = new Update(teamDriveId, content);
      initialize(result);
      return result;
    }

    public class Update extends DriveRequest<com.google.api.services.drive.model.TeamDrive> {

      private static final String REST_PATH = "teamdrives/{teamDriveId}";

      /**
       * Updates a Team Drive's metadata
       *
       * Create a request for the method "teamdrives.update".
       *
       * This request holds the parameters needed by the the drive server.  After setting any optional
       * parameters, call the {@link Update#execute()} method to invoke the remote operation. <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param teamDriveId The ID of the Team Drive
       * @param content the {@link com.google.api.services.drive.model.TeamDrive}
       * @since 1.13
       */
      protected Update(java.lang.String teamDriveId, com.google.api.services.drive.model.TeamDrive content) {
        super(Drive.this, "PATCH", REST_PATH, content, com.google.api.services.drive.model.TeamDrive.class);
        this.teamDriveId = com.google.api.client.util.Preconditions.checkNotNull(teamDriveId, "Required parameter teamDriveId must be specified.");
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUserIp(java.lang.String userIp) {
        return (Update) super.setUserIp(userIp);
      }

      /** The ID of the Team Drive */
      @com.google.api.client.util.Key
      private java.lang.String teamDriveId;

      /** The ID of the Team Drive
       */
      public java.lang.String getTeamDriveId() {
        return teamDriveId;
      }

      /** The ID of the Team Drive */
      public Update setTeamDriveId(java.lang.String teamDriveId) {
        this.teamDriveId = teamDriveId;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link Drive}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link Drive}. */
    @Override
    public Drive build() {
      return new Drive(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link DriveRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setDriveRequestInitializer(
        DriveRequestInitializer driveRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(driveRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
