/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-01-08 17:48:37 UTC)
 * on 2016-02-11 at 02:31:25 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A list of changes for a user.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChangeList extends com.google.api.client.json.GenericJson {

  /**
   * The page of changes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Change> changes;

  /**
   * This is always drive#changeList.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The starting page token for future changes. This will be present only if the end of the current
   * changes list has been reached.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String newStartPageToken;

  /**
   * The page token for the next page of changes. This will be absent if the end of the current
   * changes list has been reached.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The page of changes.
   * @return value or {@code null} for none
   */
  public java.util.List<Change> getChanges() {
    return changes;
  }

  /**
   * The page of changes.
   * @param changes changes or {@code null} for none
   */
  public ChangeList setChanges(java.util.List<Change> changes) {
    this.changes = changes;
    return this;
  }

  /**
   * This is always drive#changeList.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#changeList.
   * @param kind kind or {@code null} for none
   */
  public ChangeList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The starting page token for future changes. This will be present only if the end of the current
   * changes list has been reached.
   * @return value or {@code null} for none
   */
  public java.lang.String getNewStartPageToken() {
    return newStartPageToken;
  }

  /**
   * The starting page token for future changes. This will be present only if the end of the current
   * changes list has been reached.
   * @param newStartPageToken newStartPageToken or {@code null} for none
   */
  public ChangeList setNewStartPageToken(java.lang.String newStartPageToken) {
    this.newStartPageToken = newStartPageToken;
    return this;
  }

  /**
   * The page token for the next page of changes. This will be absent if the end of the current
   * changes list has been reached.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The page token for the next page of changes. This will be absent if the end of the current
   * changes list has been reached.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ChangeList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ChangeList set(String fieldName, Object value) {
    return (ChangeList) super.set(fieldName, value);
  }

  @Override
  public ChangeList clone() {
    return (ChangeList) super.clone();
  }

}
