/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-09-26 19:19:48 UTC)
 * on 2017-10-19 at 08:56:28 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A reply to a comment on a file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Reply extends com.google.api.client.json.GenericJson {

  /**
   * The action the reply performed to the parent comment. Valid values are: - resolve  - reopen
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String action;

  /**
   * The user who created the reply.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User author;

  /**
   * The plain text content of the reply. This field is used for setting the content, while
   * htmlContent should be displayed. This is required on creates if no action is specified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String content;

  /**
   * The time at which the reply was created (RFC 3339 date-time).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime createdTime;

  /**
   * Whether the reply has been deleted. A deleted reply has no content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean deleted;

  /**
   * The content of the reply with HTML formatting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String htmlContent;

  /**
   * The ID of the reply.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "drive#reply".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The last time the reply was modified (RFC 3339 date-time).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime modifiedTime;

  /**
   * The action the reply performed to the parent comment. Valid values are: - resolve  - reopen
   * @return value or {@code null} for none
   */
  public java.lang.String getAction() {
    return action;
  }

  /**
   * The action the reply performed to the parent comment. Valid values are: - resolve  - reopen
   * @param action action or {@code null} for none
   */
  public Reply setAction(java.lang.String action) {
    this.action = action;
    return this;
  }

  /**
   * The user who created the reply.
   * @return value or {@code null} for none
   */
  public User getAuthor() {
    return author;
  }

  /**
   * The user who created the reply.
   * @param author author or {@code null} for none
   */
  public Reply setAuthor(User author) {
    this.author = author;
    return this;
  }

  /**
   * The plain text content of the reply. This field is used for setting the content, while
   * htmlContent should be displayed. This is required on creates if no action is specified.
   * @return value or {@code null} for none
   */
  public java.lang.String getContent() {
    return content;
  }

  /**
   * The plain text content of the reply. This field is used for setting the content, while
   * htmlContent should be displayed. This is required on creates if no action is specified.
   * @param content content or {@code null} for none
   */
  public Reply setContent(java.lang.String content) {
    this.content = content;
    return this;
  }

  /**
   * The time at which the reply was created (RFC 3339 date-time).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreatedTime() {
    return createdTime;
  }

  /**
   * The time at which the reply was created (RFC 3339 date-time).
   * @param createdTime createdTime or {@code null} for none
   */
  public Reply setCreatedTime(com.google.api.client.util.DateTime createdTime) {
    this.createdTime = createdTime;
    return this;
  }

  /**
   * Whether the reply has been deleted. A deleted reply has no content.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDeleted() {
    return deleted;
  }

  /**
   * Whether the reply has been deleted. A deleted reply has no content.
   * @param deleted deleted or {@code null} for none
   */
  public Reply setDeleted(java.lang.Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

  /**
   * The content of the reply with HTML formatting.
   * @return value or {@code null} for none
   */
  public java.lang.String getHtmlContent() {
    return htmlContent;
  }

  /**
   * The content of the reply with HTML formatting.
   * @param htmlContent htmlContent or {@code null} for none
   */
  public Reply setHtmlContent(java.lang.String htmlContent) {
    this.htmlContent = htmlContent;
    return this;
  }

  /**
   * The ID of the reply.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of the reply.
   * @param id id or {@code null} for none
   */
  public Reply setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "drive#reply".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "drive#reply".
   * @param kind kind or {@code null} for none
   */
  public Reply setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The last time the reply was modified (RFC 3339 date-time).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getModifiedTime() {
    return modifiedTime;
  }

  /**
   * The last time the reply was modified (RFC 3339 date-time).
   * @param modifiedTime modifiedTime or {@code null} for none
   */
  public Reply setModifiedTime(com.google.api.client.util.DateTime modifiedTime) {
    this.modifiedTime = modifiedTime;
    return this;
  }

  @Override
  public Reply set(String fieldName, Object value) {
    return (Reply) super.set(fieldName, value);
  }

  @Override
  public Reply clone() {
    return (Reply) super.clone();
  }

}
