/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-04-03 at 23:34:54 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A comment on a file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Comment extends com.google.api.client.json.GenericJson {

  /**
   * A region of the document represented as a JSON string. See anchor documentation for details on
   * how to define and interpret anchor properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String anchor;

  /**
   * The user who created the comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User author;

  /**
   * The plain text content of the comment. This field is used for setting the content, while
   * htmlContent should be displayed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String content;

  /**
   * The time at which the comment was created (RFC 3339 date-time).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime createdTime;

  /**
   * Whether the comment has been deleted. A deleted comment has no content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean deleted;

  /**
   * The content of the comment with HTML formatting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String htmlContent;

  /**
   * The ID of the comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "drive#comment".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The last time the comment or any of its replies was modified (RFC 3339 date-time).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime modifiedTime;

  /**
   * The file content to which the comment refers, typically within the anchor region. For a text
   * file, for example, this would be the text at the location of the comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private QuotedFileContent quotedFileContent;

  /**
   * The full list of replies to the comment in chronological order.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Reply> replies;

  /**
   * Whether the comment has been resolved by one of its replies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean resolved;

  /**
   * A region of the document represented as a JSON string. See anchor documentation for details on
   * how to define and interpret anchor properties.
   * @return value or {@code null} for none
   */
  public java.lang.String getAnchor() {
    return anchor;
  }

  /**
   * A region of the document represented as a JSON string. See anchor documentation for details on
   * how to define and interpret anchor properties.
   * @param anchor anchor or {@code null} for none
   */
  public Comment setAnchor(java.lang.String anchor) {
    this.anchor = anchor;
    return this;
  }

  /**
   * The user who created the comment.
   * @return value or {@code null} for none
   */
  public User getAuthor() {
    return author;
  }

  /**
   * The user who created the comment.
   * @param author author or {@code null} for none
   */
  public Comment setAuthor(User author) {
    this.author = author;
    return this;
  }

  /**
   * The plain text content of the comment. This field is used for setting the content, while
   * htmlContent should be displayed.
   * @return value or {@code null} for none
   */
  public java.lang.String getContent() {
    return content;
  }

  /**
   * The plain text content of the comment. This field is used for setting the content, while
   * htmlContent should be displayed.
   * @param content content or {@code null} for none
   */
  public Comment setContent(java.lang.String content) {
    this.content = content;
    return this;
  }

  /**
   * The time at which the comment was created (RFC 3339 date-time).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreatedTime() {
    return createdTime;
  }

  /**
   * The time at which the comment was created (RFC 3339 date-time).
   * @param createdTime createdTime or {@code null} for none
   */
  public Comment setCreatedTime(com.google.api.client.util.DateTime createdTime) {
    this.createdTime = createdTime;
    return this;
  }

  /**
   * Whether the comment has been deleted. A deleted comment has no content.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDeleted() {
    return deleted;
  }

  /**
   * Whether the comment has been deleted. A deleted comment has no content.
   * @param deleted deleted or {@code null} for none
   */
  public Comment setDeleted(java.lang.Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

  /**
   * The content of the comment with HTML formatting.
   * @return value or {@code null} for none
   */
  public java.lang.String getHtmlContent() {
    return htmlContent;
  }

  /**
   * The content of the comment with HTML formatting.
   * @param htmlContent htmlContent or {@code null} for none
   */
  public Comment setHtmlContent(java.lang.String htmlContent) {
    this.htmlContent = htmlContent;
    return this;
  }

  /**
   * The ID of the comment.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of the comment.
   * @param id id or {@code null} for none
   */
  public Comment setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "drive#comment".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "drive#comment".
   * @param kind kind or {@code null} for none
   */
  public Comment setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The last time the comment or any of its replies was modified (RFC 3339 date-time).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getModifiedTime() {
    return modifiedTime;
  }

  /**
   * The last time the comment or any of its replies was modified (RFC 3339 date-time).
   * @param modifiedTime modifiedTime or {@code null} for none
   */
  public Comment setModifiedTime(com.google.api.client.util.DateTime modifiedTime) {
    this.modifiedTime = modifiedTime;
    return this;
  }

  /**
   * The file content to which the comment refers, typically within the anchor region. For a text
   * file, for example, this would be the text at the location of the comment.
   * @return value or {@code null} for none
   */
  public QuotedFileContent getQuotedFileContent() {
    return quotedFileContent;
  }

  /**
   * The file content to which the comment refers, typically within the anchor region. For a text
   * file, for example, this would be the text at the location of the comment.
   * @param quotedFileContent quotedFileContent or {@code null} for none
   */
  public Comment setQuotedFileContent(QuotedFileContent quotedFileContent) {
    this.quotedFileContent = quotedFileContent;
    return this;
  }

  /**
   * The full list of replies to the comment in chronological order.
   * @return value or {@code null} for none
   */
  public java.util.List<Reply> getReplies() {
    return replies;
  }

  /**
   * The full list of replies to the comment in chronological order.
   * @param replies replies or {@code null} for none
   */
  public Comment setReplies(java.util.List<Reply> replies) {
    this.replies = replies;
    return this;
  }

  /**
   * Whether the comment has been resolved by one of its replies.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getResolved() {
    return resolved;
  }

  /**
   * Whether the comment has been resolved by one of its replies.
   * @param resolved resolved or {@code null} for none
   */
  public Comment setResolved(java.lang.Boolean resolved) {
    this.resolved = resolved;
    return this;
  }

  @Override
  public Comment set(String fieldName, Object value) {
    return (Comment) super.set(fieldName, value);
  }

  @Override
  public Comment clone() {
    return (Comment) super.clone();
  }

  /**
   * The file content to which the comment refers, typically within the anchor region. For a text
   * file, for example, this would be the text at the location of the comment.
   */
  public static final class QuotedFileContent extends com.google.api.client.json.GenericJson {

    /**
     * The MIME type of the quoted content.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String mimeType;

    /**
     * The quoted content itself. This is interpreted as plain text if set through the API.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String value;

    /**
     * The MIME type of the quoted content.
     * @return value or {@code null} for none
     */
    public java.lang.String getMimeType() {
      return mimeType;
    }

    /**
     * The MIME type of the quoted content.
     * @param mimeType mimeType or {@code null} for none
     */
    public QuotedFileContent setMimeType(java.lang.String mimeType) {
      this.mimeType = mimeType;
      return this;
    }

    /**
     * The quoted content itself. This is interpreted as plain text if set through the API.
     * @return value or {@code null} for none
     */
    public java.lang.String getValue() {
      return value;
    }

    /**
     * The quoted content itself. This is interpreted as plain text if set through the API.
     * @param value value or {@code null} for none
     */
    public QuotedFileContent setValue(java.lang.String value) {
      this.value = value;
      return this;
    }

    @Override
    public QuotedFileContent set(String fieldName, Object value) {
      return (QuotedFileContent) super.set(fieldName, value);
    }

    @Override
    public QuotedFileContent clone() {
      return (QuotedFileContent) super.clone();
    }

  }

}
