/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-02-15 17:18:02 UTC)
 * on 2017-03-15 at 19:47:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * Representation of a Team Drive.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TeamDrive extends com.google.api.client.json.GenericJson {

  /**
   * Capabilities the current user has on this Team Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Capabilities capabilities;

  /**
   * The ID of this Team Drive which is also the ID of the top level folder for this Team Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Identifies what kind of resource this is. Value: the fixed string "drive#teamDrive".
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The name of this Team Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Capabilities the current user has on this Team Drive.
   * @return value or {@code null} for none
   */
  public Capabilities getCapabilities() {
    return capabilities;
  }

  /**
   * Capabilities the current user has on this Team Drive.
   * @param capabilities capabilities or {@code null} for none
   */
  public TeamDrive setCapabilities(Capabilities capabilities) {
    this.capabilities = capabilities;
    return this;
  }

  /**
   * The ID of this Team Drive which is also the ID of the top level folder for this Team Drive.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of this Team Drive which is also the ID of the top level folder for this Team Drive.
   * @param id id or {@code null} for none
   */
  public TeamDrive setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "drive#teamDrive".
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Identifies what kind of resource this is. Value: the fixed string "drive#teamDrive".
   * @param kind kind or {@code null} for none
   */
  public TeamDrive setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The name of this Team Drive.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name of this Team Drive.
   * @param name name or {@code null} for none
   */
  public TeamDrive setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public TeamDrive set(String fieldName, Object value) {
    return (TeamDrive) super.set(fieldName, value);
  }

  @Override
  public TeamDrive clone() {
    return (TeamDrive) super.clone();
  }

  /**
   * Capabilities the current user has on this Team Drive.
   */
  public static final class Capabilities extends com.google.api.client.json.GenericJson {

    /**
     * Whether the current user can add children to folders in this Team Drive.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canAddChildren;

    /**
     * Whether the current user can comment on files in this Team Drive.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canComment;

    /**
     * Whether files in this Team Drive can be copied by the current user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canCopy;

    /**
     * Whether this Team Drive can be deleted by the current user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canDeleteTeamDrive;

    /**
     * Whether files in this Team Drive can be downloaded by the current user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canDownload;

    /**
     * Whether files in this Team Drive can be edited by the current user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canEdit;

    /**
     * Whether the current user can list the children of folders in this Team Drive.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canListChildren;

    /**
     * Whether the current user can add members to this Team Drive or remove them or change their
     * role.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canManageMembers;

    /**
     * Whether the current user has read access to the Revisions resource of files in this Team Drive.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canReadRevisions;

    /**
     * Whether the current user can remove children from folders in this Team Drive.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canRemoveChildren;

    /**
     * Whether files or folders in this Team Drive can be renamed by the current user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canRename;

    /**
     * Whether this Team Drive can be renamed by the current user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canRenameTeamDrive;

    /**
     * Whether the current user can share files or folders in this Team Drive.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canShare;

    /**
     * Whether the current user can add children to folders in this Team Drive.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanAddChildren() {
      return canAddChildren;
    }

    /**
     * Whether the current user can add children to folders in this Team Drive.
     * @param canAddChildren canAddChildren or {@code null} for none
     */
    public Capabilities setCanAddChildren(java.lang.Boolean canAddChildren) {
      this.canAddChildren = canAddChildren;
      return this;
    }

    /**
     * Whether the current user can comment on files in this Team Drive.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanComment() {
      return canComment;
    }

    /**
     * Whether the current user can comment on files in this Team Drive.
     * @param canComment canComment or {@code null} for none
     */
    public Capabilities setCanComment(java.lang.Boolean canComment) {
      this.canComment = canComment;
      return this;
    }

    /**
     * Whether files in this Team Drive can be copied by the current user.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanCopy() {
      return canCopy;
    }

    /**
     * Whether files in this Team Drive can be copied by the current user.
     * @param canCopy canCopy or {@code null} for none
     */
    public Capabilities setCanCopy(java.lang.Boolean canCopy) {
      this.canCopy = canCopy;
      return this;
    }

    /**
     * Whether this Team Drive can be deleted by the current user.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanDeleteTeamDrive() {
      return canDeleteTeamDrive;
    }

    /**
     * Whether this Team Drive can be deleted by the current user.
     * @param canDeleteTeamDrive canDeleteTeamDrive or {@code null} for none
     */
    public Capabilities setCanDeleteTeamDrive(java.lang.Boolean canDeleteTeamDrive) {
      this.canDeleteTeamDrive = canDeleteTeamDrive;
      return this;
    }

    /**
     * Whether files in this Team Drive can be downloaded by the current user.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanDownload() {
      return canDownload;
    }

    /**
     * Whether files in this Team Drive can be downloaded by the current user.
     * @param canDownload canDownload or {@code null} for none
     */
    public Capabilities setCanDownload(java.lang.Boolean canDownload) {
      this.canDownload = canDownload;
      return this;
    }

    /**
     * Whether files in this Team Drive can be edited by the current user.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanEdit() {
      return canEdit;
    }

    /**
     * Whether files in this Team Drive can be edited by the current user.
     * @param canEdit canEdit or {@code null} for none
     */
    public Capabilities setCanEdit(java.lang.Boolean canEdit) {
      this.canEdit = canEdit;
      return this;
    }

    /**
     * Whether the current user can list the children of folders in this Team Drive.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanListChildren() {
      return canListChildren;
    }

    /**
     * Whether the current user can list the children of folders in this Team Drive.
     * @param canListChildren canListChildren or {@code null} for none
     */
    public Capabilities setCanListChildren(java.lang.Boolean canListChildren) {
      this.canListChildren = canListChildren;
      return this;
    }

    /**
     * Whether the current user can add members to this Team Drive or remove them or change their
     * role.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanManageMembers() {
      return canManageMembers;
    }

    /**
     * Whether the current user can add members to this Team Drive or remove them or change their
     * role.
     * @param canManageMembers canManageMembers or {@code null} for none
     */
    public Capabilities setCanManageMembers(java.lang.Boolean canManageMembers) {
      this.canManageMembers = canManageMembers;
      return this;
    }

    /**
     * Whether the current user has read access to the Revisions resource of files in this Team Drive.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanReadRevisions() {
      return canReadRevisions;
    }

    /**
     * Whether the current user has read access to the Revisions resource of files in this Team Drive.
     * @param canReadRevisions canReadRevisions or {@code null} for none
     */
    public Capabilities setCanReadRevisions(java.lang.Boolean canReadRevisions) {
      this.canReadRevisions = canReadRevisions;
      return this;
    }

    /**
     * Whether the current user can remove children from folders in this Team Drive.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanRemoveChildren() {
      return canRemoveChildren;
    }

    /**
     * Whether the current user can remove children from folders in this Team Drive.
     * @param canRemoveChildren canRemoveChildren or {@code null} for none
     */
    public Capabilities setCanRemoveChildren(java.lang.Boolean canRemoveChildren) {
      this.canRemoveChildren = canRemoveChildren;
      return this;
    }

    /**
     * Whether files or folders in this Team Drive can be renamed by the current user.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanRename() {
      return canRename;
    }

    /**
     * Whether files or folders in this Team Drive can be renamed by the current user.
     * @param canRename canRename or {@code null} for none
     */
    public Capabilities setCanRename(java.lang.Boolean canRename) {
      this.canRename = canRename;
      return this;
    }

    /**
     * Whether this Team Drive can be renamed by the current user.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanRenameTeamDrive() {
      return canRenameTeamDrive;
    }

    /**
     * Whether this Team Drive can be renamed by the current user.
     * @param canRenameTeamDrive canRenameTeamDrive or {@code null} for none
     */
    public Capabilities setCanRenameTeamDrive(java.lang.Boolean canRenameTeamDrive) {
      this.canRenameTeamDrive = canRenameTeamDrive;
      return this;
    }

    /**
     * Whether the current user can share files or folders in this Team Drive.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanShare() {
      return canShare;
    }

    /**
     * Whether the current user can share files or folders in this Team Drive.
     * @param canShare canShare or {@code null} for none
     */
    public Capabilities setCanShare(java.lang.Boolean canShare) {
      this.canShare = canShare;
      return this;
    }

    @Override
    public Capabilities set(String fieldName, Object value) {
      return (Capabilities) super.set(fieldName, value);
    }

    @Override
    public Capabilities clone() {
      return (Capabilities) super.clone();
    }

  }

}
