/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-01-08 17:48:37 UTC)
 * on 2016-01-15 at 19:43:44 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A list of replies to a comment on a file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ReplyList extends com.google.api.client.json.GenericJson {

  /**
   * This is always drive#replyList.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The page token for the next page of replies. This will be absent if the end of the replies list
   * has been reached.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The page of replies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Reply> replies;

  /**
   * This is always drive#replyList.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#replyList.
   * @param kind kind or {@code null} for none
   */
  public ReplyList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The page token for the next page of replies. This will be absent if the end of the replies list
   * has been reached.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The page token for the next page of replies. This will be absent if the end of the replies list
   * has been reached.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ReplyList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The page of replies.
   * @return value or {@code null} for none
   */
  public java.util.List<Reply> getReplies() {
    return replies;
  }

  /**
   * The page of replies.
   * @param replies replies or {@code null} for none
   */
  public ReplyList setReplies(java.util.List<Reply> replies) {
    this.replies = replies;
    return this;
  }

  @Override
  public ReplyList set(String fieldName, Object value) {
    return (ReplyList) super.set(fieldName, value);
  }

  @Override
  public ReplyList clone() {
    return (ReplyList) super.clone();
  }

}
