/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2016-05-27 16:00:31 UTC)
 * on 2016-07-28 at 20:39:16 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A list of files.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FileList extends com.google.api.client.json.GenericJson {

  /**
   * The page of files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<File> files;

  static {
    // hack to force ProGuard to consider File used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(File.class);
  }

  /**
   * This is always drive#fileList.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The page token for the next page of files. This will be absent if the end of the files list has
   * been reached.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The page of files.
   * @return value or {@code null} for none
   */
  public java.util.List<File> getFiles() {
    return files;
  }

  /**
   * The page of files.
   * @param files files or {@code null} for none
   */
  public FileList setFiles(java.util.List<File> files) {
    this.files = files;
    return this;
  }

  /**
   * This is always drive#fileList.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#fileList.
   * @param kind kind or {@code null} for none
   */
  public FileList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The page token for the next page of files. This will be absent if the end of the files list has
   * been reached.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The page token for the next page of files. This will be absent if the end of the files list has
   * been reached.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public FileList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public FileList set(String fieldName, Object value) {
    return (FileList) super.set(fieldName, value);
  }

  @Override
  public FileList clone() {
    return (FileList) super.clone();
  }

}
