/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2013-06-26 16:27:34 UTC)
 * on 2013-08-01 at 00:36:35 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * Model definition for Channel.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Channel extends com.google.api.client.json.GenericJson {

  /**
   * The address of the receiving entity where events are delivered. Specific to the channel type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String address;

  /**
   * The expiration instant for this channel if it is defined.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long expiration;

  /**
   * A UUID for the channel
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * A channel watching an API resource
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * Additional parameters controlling delivery channel behavior
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> params;

  /**
   * An opaque id that identifies the resource that is being watched. Stable across different API
   * versions
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resourceId;

  /**
   * The canonicalized ID of the watched resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resourceUri;

  /**
   * An arbitrary string associated with the channel that is delivered to the target address with
   * each event delivered over this channel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String token;

  /**
   * The type of delivery mechanism used by this channel
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The address of the receiving entity where events are delivered. Specific to the channel type.
   * @return value or {@code null} for none
   */
  public java.lang.String getAddress() {
    return address;
  }

  /**
   * The address of the receiving entity where events are delivered. Specific to the channel type.
   * @param address address or {@code null} for none
   */
  public Channel setAddress(java.lang.String address) {
    this.address = address;
    return this;
  }

  /**
   * The expiration instant for this channel if it is defined.
   * @return value or {@code null} for none
   */
  public java.lang.Long getExpiration() {
    return expiration;
  }

  /**
   * The expiration instant for this channel if it is defined.
   * @param expiration expiration or {@code null} for none
   */
  public Channel setExpiration(java.lang.Long expiration) {
    this.expiration = expiration;
    return this;
  }

  /**
   * A UUID for the channel
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * A UUID for the channel
   * @param id id or {@code null} for none
   */
  public Channel setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * A channel watching an API resource
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * A channel watching an API resource
   * @param kind kind or {@code null} for none
   */
  public Channel setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Additional parameters controlling delivery channel behavior
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getParams() {
    return params;
  }

  /**
   * Additional parameters controlling delivery channel behavior
   * @param params params or {@code null} for none
   */
  public Channel setParams(java.util.Map<String, java.lang.String> params) {
    this.params = params;
    return this;
  }

  /**
   * An opaque id that identifies the resource that is being watched. Stable across different API
   * versions
   * @return value or {@code null} for none
   */
  public java.lang.String getResourceId() {
    return resourceId;
  }

  /**
   * An opaque id that identifies the resource that is being watched. Stable across different API
   * versions
   * @param resourceId resourceId or {@code null} for none
   */
  public Channel setResourceId(java.lang.String resourceId) {
    this.resourceId = resourceId;
    return this;
  }

  /**
   * The canonicalized ID of the watched resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getResourceUri() {
    return resourceUri;
  }

  /**
   * The canonicalized ID of the watched resource.
   * @param resourceUri resourceUri or {@code null} for none
   */
  public Channel setResourceUri(java.lang.String resourceUri) {
    this.resourceUri = resourceUri;
    return this;
  }

  /**
   * An arbitrary string associated with the channel that is delivered to the target address with
   * each event delivered over this channel.
   * @return value or {@code null} for none
   */
  public java.lang.String getToken() {
    return token;
  }

  /**
   * An arbitrary string associated with the channel that is delivered to the target address with
   * each event delivered over this channel.
   * @param token token or {@code null} for none
   */
  public Channel setToken(java.lang.String token) {
    this.token = token;
    return this;
  }

  /**
   * The type of delivery mechanism used by this channel
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of delivery mechanism used by this channel
   * @param type type or {@code null} for none
   */
  public Channel setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Channel set(String fieldName, Object value) {
    return (Channel) super.set(fieldName, value);
  }

  @Override
  public Channel clone() {
    return (Channel) super.clone();
  }

}
