/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.drive.model;

import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonString;

/**
 * Model definition for Channel.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Channel extends GenericJson {

  /**
   * The address of the receiving entity where events are delivered. Specific to the channel type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String address;

  /**
   * The expiration instant for this channel if it is defined.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @JsonString
  private Long expiration;

  /**
   * A UUID for the channel
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String id;

  /**
   * A channel watching an API resource
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * Additional parameters controlling delivery channel behavior
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, String> params;

  /**
   * An opaque id that identifies the resource that is being watched. Stable across different API
   * versions
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String resourceId;

  /**
   * The canonicalized ID of the watched resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String resourceUri;

  /**
   * An arbitrary string associated with the channel that is delivered to the target address with
   * each event delivered over this channel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String token;

  /**
   * The type of delivery mechanism used by this channel
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String type;

  /**
   * The address of the receiving entity where events are delivered. Specific to the channel type.
   * The value returned may be {@code null}.
   */
  public String getAddress() {
    return address;
  }

  /**
   * The address of the receiving entity where events are delivered. Specific to the channel type.
   * The value set may be {@code null}.
   */
  public Channel setAddress(String address) {
    this.address = address;
    return this;
  }

  /**
   * The expiration instant for this channel if it is defined.
   * The value returned may be {@code null}.
   */
  public Long getExpiration() {
    return expiration;
  }

  /**
   * The expiration instant for this channel if it is defined.
   * The value set may be {@code null}.
   */
  public Channel setExpiration(Long expiration) {
    this.expiration = expiration;
    return this;
  }

  /**
   * A UUID for the channel
   * The value returned may be {@code null}.
   */
  public String getId() {
    return id;
  }

  /**
   * A UUID for the channel
   * The value set may be {@code null}.
   */
  public Channel setId(String id) {
    this.id = id;
    return this;
  }

  /**
   * A channel watching an API resource
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * A channel watching an API resource
   * The value set may be {@code null}.
   */
  public Channel setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * Additional parameters controlling delivery channel behavior
   * The value returned may be {@code null}.
   */
  public java.util.Map<String, String> getParams() {
    return params;
  }

  /**
   * Additional parameters controlling delivery channel behavior
   * The value set may be {@code null}.
   */
  public Channel setParams(java.util.Map<String, String> params) {
    this.params = params;
    return this;
  }

  /**
   * An opaque id that identifies the resource that is being watched. Stable across different API
   * versions
   * The value returned may be {@code null}.
   */
  public String getResourceId() {
    return resourceId;
  }

  /**
   * An opaque id that identifies the resource that is being watched. Stable across different API
   * versions
   * The value set may be {@code null}.
   */
  public Channel setResourceId(String resourceId) {
    this.resourceId = resourceId;
    return this;
  }

  /**
   * The canonicalized ID of the watched resource.
   * The value returned may be {@code null}.
   */
  public String getResourceUri() {
    return resourceUri;
  }

  /**
   * The canonicalized ID of the watched resource.
   * The value set may be {@code null}.
   */
  public Channel setResourceUri(String resourceUri) {
    this.resourceUri = resourceUri;
    return this;
  }

  /**
   * An arbitrary string associated with the channel that is delivered to the target address with
   * each event delivered over this channel.
   * The value returned may be {@code null}.
   */
  public String getToken() {
    return token;
  }

  /**
   * An arbitrary string associated with the channel that is delivered to the target address with
   * each event delivered over this channel.
   * The value set may be {@code null}.
   */
  public Channel setToken(String token) {
    this.token = token;
    return this;
  }

  /**
   * The type of delivery mechanism used by this channel
   * The value returned may be {@code null}.
   */
  public String getType() {
    return type;
  }

  /**
   * The type of delivery mechanism used by this channel
   * The value set may be {@code null}.
   */
  public Channel setType(String type) {
    this.type = type;
    return this;
  }

}
