/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * Warning! This file is generated. Modify at your own risk.
 */

package com.google.api.services.drive.model;

import com.google.api.client.json.GenericJson;

/**
 * A key-value pair that is either public or private to an application.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * <p>
 * Upgrade warning: starting with version 1.12 {@code getResponseHeaders()} is removed, instead use
 * {@link com.google.api.client.http.json.JsonHttpRequest#getLastResponseHeaders()}
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Property extends GenericJson {

  /**
   * ETag of the property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String etag;

  /**
   * The key of this property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String key;

  /**
   * This is always drive#property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String kind;

  /**
   * The link back to this property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String selfLink;

  /**
   * The value of this property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String value;

  /**
   * The visibility of this property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String visibility;

  /**
   * ETag of the property.
   * The value returned may be {@code null}.
   */
  public String getEtag() {
    return etag;
  }

  /**
   * ETag of the property.
   * The value set may be {@code null}.
   */
  public Property setEtag(String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The key of this property.
   * The value returned may be {@code null}.
   */
  public String getKey() {
    return key;
  }

  /**
   * The key of this property.
   * The value set may be {@code null}.
   */
  public Property setKey(String key) {
    this.key = key;
    return this;
  }

  /**
   * This is always drive#property.
   * The value returned may be {@code null}.
   */
  public String getKind() {
    return kind;
  }

  /**
   * This is always drive#property.
   * The value set may be {@code null}.
   */
  public Property setKind(String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The link back to this property.
   * The value returned may be {@code null}.
   */
  public String getSelfLink() {
    return selfLink;
  }

  /**
   * The link back to this property.
   * The value set may be {@code null}.
   */
  public Property setSelfLink(String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * The value of this property.
   * The value returned may be {@code null}.
   */
  public String getValue() {
    return value;
  }

  /**
   * The value of this property.
   * The value set may be {@code null}.
   */
  public Property setValue(String value) {
    this.value = value;
    return this;
  }

  /**
   * The visibility of this property.
   * The value returned may be {@code null}.
   */
  public String getVisibility() {
    return visibility;
  }

  /**
   * The visibility of this property.
   * The value set may be {@code null}.
   */
  public Property setVisibility(String visibility) {
    this.visibility = visibility;
    return this;
  }

}
