/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-10-08 17:45:39 UTC)
 * on 2019-04-18 at 05:17:25 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * Representation of a change to a file or shared drive.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Change extends com.google.api.client.json.GenericJson {

  /**
   * The type of the change. Possible values are file and drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String changeType;

  /**
   * Whether the file or shared drive has been removed from this list of changes, for example by
   * deletion or loss of access.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean deleted;

  /**
   * The updated state of the shared drive. Present if the changeType is drive, the user is still a
   * member of the shared drive, and the shared drive has not been deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Drive drive;

  /**
   * The ID of the shared drive associated with this change.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String driveId;

  /**
   * The updated state of the file. Present if the type is file and the file has not been removed
   * from this list of changes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private File file;

  /**
   * The ID of the file associated with this change.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileId;

  /**
   * The ID of the change.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long id;

  /**
   * This is always drive#change.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The time of this modification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime modificationDate;

  /**
   * A link back to this change.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Deprecated - use drive instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TeamDrive teamDrive;

  /**
   * Deprecated - use driveId instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String teamDriveId;

  /**
   * Deprecated - use changeType instead.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The type of the change. Possible values are file and drive.
   * @return value or {@code null} for none
   */
  public java.lang.String getChangeType() {
    return changeType;
  }

  /**
   * The type of the change. Possible values are file and drive.
   * @param changeType changeType or {@code null} for none
   */
  public Change setChangeType(java.lang.String changeType) {
    this.changeType = changeType;
    return this;
  }

  /**
   * Whether the file or shared drive has been removed from this list of changes, for example by
   * deletion or loss of access.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDeleted() {
    return deleted;
  }

  /**
   * Whether the file or shared drive has been removed from this list of changes, for example by
   * deletion or loss of access.
   * @param deleted deleted or {@code null} for none
   */
  public Change setDeleted(java.lang.Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

  /**
   * The updated state of the shared drive. Present if the changeType is drive, the user is still a
   * member of the shared drive, and the shared drive has not been deleted.
   * @return value or {@code null} for none
   */
  public Drive getDrive() {
    return drive;
  }

  /**
   * The updated state of the shared drive. Present if the changeType is drive, the user is still a
   * member of the shared drive, and the shared drive has not been deleted.
   * @param drive drive or {@code null} for none
   */
  public Change setDrive(Drive drive) {
    this.drive = drive;
    return this;
  }

  /**
   * The ID of the shared drive associated with this change.
   * @return value or {@code null} for none
   */
  public java.lang.String getDriveId() {
    return driveId;
  }

  /**
   * The ID of the shared drive associated with this change.
   * @param driveId driveId or {@code null} for none
   */
  public Change setDriveId(java.lang.String driveId) {
    this.driveId = driveId;
    return this;
  }

  /**
   * The updated state of the file. Present if the type is file and the file has not been removed
   * from this list of changes.
   * @return value or {@code null} for none
   */
  public File getFile() {
    return file;
  }

  /**
   * The updated state of the file. Present if the type is file and the file has not been removed
   * from this list of changes.
   * @param file file or {@code null} for none
   */
  public Change setFile(File file) {
    this.file = file;
    return this;
  }

  /**
   * The ID of the file associated with this change.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileId() {
    return fileId;
  }

  /**
   * The ID of the file associated with this change.
   * @param fileId fileId or {@code null} for none
   */
  public Change setFileId(java.lang.String fileId) {
    this.fileId = fileId;
    return this;
  }

  /**
   * The ID of the change.
   * @return value or {@code null} for none
   */
  public java.lang.Long getId() {
    return id;
  }

  /**
   * The ID of the change.
   * @param id id or {@code null} for none
   */
  public Change setId(java.lang.Long id) {
    this.id = id;
    return this;
  }

  /**
   * This is always drive#change.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#change.
   * @param kind kind or {@code null} for none
   */
  public Change setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The time of this modification.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getModificationDate() {
    return modificationDate;
  }

  /**
   * The time of this modification.
   * @param modificationDate modificationDate or {@code null} for none
   */
  public Change setModificationDate(com.google.api.client.util.DateTime modificationDate) {
    this.modificationDate = modificationDate;
    return this;
  }

  /**
   * A link back to this change.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * A link back to this change.
   * @param selfLink selfLink or {@code null} for none
   */
  public Change setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Deprecated - use drive instead.
   * @return value or {@code null} for none
   */
  public TeamDrive getTeamDrive() {
    return teamDrive;
  }

  /**
   * Deprecated - use drive instead.
   * @param teamDrive teamDrive or {@code null} for none
   */
  public Change setTeamDrive(TeamDrive teamDrive) {
    this.teamDrive = teamDrive;
    return this;
  }

  /**
   * Deprecated - use driveId instead.
   * @return value or {@code null} for none
   */
  public java.lang.String getTeamDriveId() {
    return teamDriveId;
  }

  /**
   * Deprecated - use driveId instead.
   * @param teamDriveId teamDriveId or {@code null} for none
   */
  public Change setTeamDriveId(java.lang.String teamDriveId) {
    this.teamDriveId = teamDriveId;
    return this;
  }

  /**
   * Deprecated - use changeType instead.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Deprecated - use changeType instead.
   * @param type type or {@code null} for none
   */
  public Change setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Change set(String fieldName, Object value) {
    return (Change) super.set(fieldName, value);
  }

  @Override
  public Change clone() {
    return (Change) super.clone();
  }

}
