/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2018-05-04 17:28:03 UTC)
 * on 2018-07-10 at 14:57:24 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A list of Team Drives.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TeamDriveList extends com.google.api.client.json.GenericJson {

  /**
   * The list of Team Drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TeamDrive> items;

  static {
    // hack to force ProGuard to consider TeamDrive used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(TeamDrive.class);
  }

  /**
   * This is always drive#teamDriveList
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The page token for the next page of Team Drives.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The list of Team Drives.
   * @return value or {@code null} for none
   */
  public java.util.List<TeamDrive> getItems() {
    return items;
  }

  /**
   * The list of Team Drives.
   * @param items items or {@code null} for none
   */
  public TeamDriveList setItems(java.util.List<TeamDrive> items) {
    this.items = items;
    return this;
  }

  /**
   * This is always drive#teamDriveList
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#teamDriveList
   * @param kind kind or {@code null} for none
   */
  public TeamDriveList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The page token for the next page of Team Drives.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The page token for the next page of Team Drives.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public TeamDriveList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public TeamDriveList set(String fieldName, Object value) {
    return (TeamDriveList) super.set(fieldName, value);
  }

  @Override
  public TeamDriveList clone() {
    return (TeamDriveList) super.clone();
  }

}
