/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2017-11-07 19:12:12 UTC)
 * on 2018-01-25 at 08:43:38 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * The metadata for a file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class File extends com.google.api.client.json.GenericJson {

  /**
   * A link for opening the file in a relevant Google editor or viewer.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String alternateLink;

  /**
   * Whether this file is in the Application Data folder.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean appDataContents;

  /**
   * Deprecated: use capabilities/canComment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canComment;

  /**
   * Deprecated: use capabilities/canReadRevisions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canReadRevisions;

  /**
   * Capabilities the current user has on this file. Each capability corresponds to a fine-grained
   * action that a user may take.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Capabilities capabilities;

  /**
   * Deprecated: use capabilities/canCopy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean copyable;

  /**
   * Create time for this file (formatted RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime createdDate;

  /**
   * A link to open this file with the user's default app for this file. Only populated when the
   * drive.apps.readonly scope is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultOpenWithLink;

  /**
   * A short description of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String downloadUrl;

  /**
   * Deprecated: use capabilities/canEdit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean editable;

  /**
   * A link for embedding the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String embedLink;

  /**
   * ETag of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Whether this file has been explicitly trashed, as opposed to recursively trashed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean explicitlyTrashed;

  /**
   * Links for exporting Google Docs to specific formats.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> exportLinks;

  /**
   * The final component of fullFileExtension with trailing text that does not appear to be part of
   * the extension removed. This field is only populated for files with content stored in Drive; it
   * is not populated for Google Docs or shortcut files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileExtension;

  /**
   * The size of the file in bytes. This field is only populated for files with content stored in
   * Drive; it is not populated for Google Docs or shortcut files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long fileSize;

  /**
   * Folder color as an RGB hex string if the file is a folder. The list of supported colors is
   * available in the folderColorPalette field of the About resource. If an unsupported color is
   * specified, it will be changed to the closest color in the palette. Not populated for Team Drive
   * files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String folderColorRgb;

  /**
   * The full file extension; extracted from the title. May contain multiple concatenated
   * extensions, such as "tar.gz". Removing an extension from the title does not clear this field;
   * however, changing the extension on the title does update this field. This field is only
   * populated for files with content stored in Drive; it is not populated for Google Docs or
   * shortcut files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fullFileExtension;

  /**
   * Whether any users are granted file access directly on this file. This field is only populated
   * for Team Drive files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasAugmentedPermissions;

  /**
   * Whether this file has a thumbnail. This does not indicate whether the requesting app has access
   * to the thumbnail. To check access, look for the presence of the thumbnailLink field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean hasThumbnail;

  /**
   * The ID of the file's head revision. This field is only populated for files with content stored
   * in Drive; it is not populated for Google Docs or shortcut files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String headRevisionId;

  /**
   * A link to the file's icon.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String iconLink;

  /**
   * The ID of the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Metadata about image media. This will only be present for image types, and its contents will
   * depend on what can be parsed from the image content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ImageMediaMetadata imageMediaMetadata;

  /**
   * Indexable text attributes for the file (can only be written)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private IndexableText indexableText;

  /**
   * Whether the file was created or opened by the requesting app.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isAppAuthorized;

  /**
   * The type of file. This is always drive#file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A group of labels for the file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Labels labels;

  /**
   * The last user to modify this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User lastModifyingUser;

  /**
   * Name of the last user to modify this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lastModifyingUserName;

  /**
   * Last time this file was viewed by the user (formatted RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime lastViewedByMeDate;

  /**
   * Deprecated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime markedViewedByMeDate;

  /**
   * An MD5 checksum for the content of this file. This field is only populated for files with
   * content stored in Drive; it is not populated for Google Docs or shortcut files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String md5Checksum;

  /**
   * The MIME type of the file. This is only mutable on update when uploading new content. This
   * field can be left blank, and the mimetype will be determined from the uploaded content's MIME
   * type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mimeType;

  /**
   * Last time this file was modified by the user (formatted RFC 3339 timestamp). Note that setting
   * modifiedDate will also update the modifiedByMe date for the user which set the date.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime modifiedByMeDate;

  /**
   * Last time this file was modified by anyone (formatted RFC 3339 timestamp). This is only mutable
   * on update when the setModifiedDate parameter is set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime modifiedDate;

  /**
   * A map of the id of each of the user's apps to a link to open this file with that app. Only
   * populated when the drive.apps.readonly scope is used.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> openWithLinks;

  /**
   * The original filename of the uploaded content if available, or else the original value of the
   * title field. This is only available for files with binary content in Drive.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String originalFilename;

  /**
   * Whether the file is owned by the current user. Not populated for Team Drive files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean ownedByMe;

  /**
   * Name(s) of the owner(s) of this file. Not populated for Team Drive files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> ownerNames;

  /**
   * The owner(s) of this file. Not populated for Team Drive files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<User> owners;

  /**
   * Collection of parent folders which contain this file. If not specified as part of an insert
   * request, the file will be placed directly in the user's My Drive folder. If not specified as
   * part of a copy request, the file will inherit any discoverable parents of the source file.
   * Update requests can also use the addParents and removeParents parameters to modify the parents
   * list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ParentReference> parents;

  /**
   * List of permission IDs for users with access to this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> permissionIds;

  /**
   * The list of permissions for users with access to this file. Not populated for Team Drive files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Permission> permissions;

  /**
   * The list of properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Property> properties;

  /**
   * The number of quota bytes used by this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long quotaBytesUsed;

  /**
   * A link back to this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Deprecated: use capabilities/canShare.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean shareable;

  /**
   * Whether the file has been shared. Not populated for Team Drive files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean shared;

  /**
   * Time at which this file was shared with the user (formatted RFC 3339 timestamp).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime sharedWithMeDate;

  /**
   * User that shared the item with the current user, if available.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User sharingUser;

  /**
   * The list of spaces which contain the file. Supported values are 'drive', 'appDataFolder' and
   * 'photos'.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> spaces;

  /**
   * ID of the Team Drive the file resides in.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String teamDriveId;

  /**
   * A thumbnail for the file. This will only be used if Drive cannot generate a standard thumbnail.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Thumbnail thumbnail;

  /**
   * A short-lived link to the file's thumbnail. Typically lasts on the order of hours. Only
   * populated when the requesting app can access the file's content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String thumbnailLink;

  /**
   * The thumbnail version for use in thumbnail cache invalidation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long thumbnailVersion;

  /**
   * The title of this file. Note that for immutable items such as the top level folders of Team
   * Drives, My Drive root folder, and Application Data folder the title is constant.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String title;

  /**
   * The time that the item was trashed (formatted RFC 3339 timestamp). Only populated for Team
   * Drive files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime trashedDate;

  /**
   * If the file has been explicitly trashed, the user who trashed it. Only populated for Team Drive
   * files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User trashingUser;

  /**
   * The permissions for the authenticated user on this file.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Permission userPermission;

  /**
   * A monotonically increasing version number for the file. This reflects every change made to the
   * file on the server, even those not visible to the requesting user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long version;

  /**
   * Metadata about video media. This will only be present for video types.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private VideoMediaMetadata videoMediaMetadata;

  /**
   * A link for downloading the content of the file in a browser using cookie based authentication.
   * In cases where the content is shared publicly, the content can be downloaded without any
   * credentials.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String webContentLink;

  /**
   * A link only available on public folders for viewing their static web assets (HTML, CSS, JS,
   * etc) via Google Drive's Website Hosting.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String webViewLink;

  /**
   * Whether writers can share the document with other users. Not populated for Team Drive files.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean writersCanShare;

  /**
   * A link for opening the file in a relevant Google editor or viewer.
   * @return value or {@code null} for none
   */
  public java.lang.String getAlternateLink() {
    return alternateLink;
  }

  /**
   * A link for opening the file in a relevant Google editor or viewer.
   * @param alternateLink alternateLink or {@code null} for none
   */
  public File setAlternateLink(java.lang.String alternateLink) {
    this.alternateLink = alternateLink;
    return this;
  }

  /**
   * Whether this file is in the Application Data folder.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAppDataContents() {
    return appDataContents;
  }

  /**
   * Whether this file is in the Application Data folder.
   * @param appDataContents appDataContents or {@code null} for none
   */
  public File setAppDataContents(java.lang.Boolean appDataContents) {
    this.appDataContents = appDataContents;
    return this;
  }

  /**
   * Deprecated: use capabilities/canComment.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanComment() {
    return canComment;
  }

  /**
   * Deprecated: use capabilities/canComment.
   * @param canComment canComment or {@code null} for none
   */
  public File setCanComment(java.lang.Boolean canComment) {
    this.canComment = canComment;
    return this;
  }

  /**
   * Deprecated: use capabilities/canReadRevisions.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanReadRevisions() {
    return canReadRevisions;
  }

  /**
   * Deprecated: use capabilities/canReadRevisions.
   * @param canReadRevisions canReadRevisions or {@code null} for none
   */
  public File setCanReadRevisions(java.lang.Boolean canReadRevisions) {
    this.canReadRevisions = canReadRevisions;
    return this;
  }

  /**
   * Capabilities the current user has on this file. Each capability corresponds to a fine-grained
   * action that a user may take.
   * @return value or {@code null} for none
   */
  public Capabilities getCapabilities() {
    return capabilities;
  }

  /**
   * Capabilities the current user has on this file. Each capability corresponds to a fine-grained
   * action that a user may take.
   * @param capabilities capabilities or {@code null} for none
   */
  public File setCapabilities(Capabilities capabilities) {
    this.capabilities = capabilities;
    return this;
  }

  /**
   * Deprecated: use capabilities/canCopy.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCopyable() {
    return copyable;
  }

  /**
   * Deprecated: use capabilities/canCopy.
   * @param copyable copyable or {@code null} for none
   */
  public File setCopyable(java.lang.Boolean copyable) {
    this.copyable = copyable;
    return this;
  }

  /**
   * Create time for this file (formatted RFC 3339 timestamp).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreatedDate() {
    return createdDate;
  }

  /**
   * Create time for this file (formatted RFC 3339 timestamp).
   * @param createdDate createdDate or {@code null} for none
   */
  public File setCreatedDate(com.google.api.client.util.DateTime createdDate) {
    this.createdDate = createdDate;
    return this;
  }

  /**
   * A link to open this file with the user's default app for this file. Only populated when the
   * drive.apps.readonly scope is used.
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultOpenWithLink() {
    return defaultOpenWithLink;
  }

  /**
   * A link to open this file with the user's default app for this file. Only populated when the
   * drive.apps.readonly scope is used.
   * @param defaultOpenWithLink defaultOpenWithLink or {@code null} for none
   */
  public File setDefaultOpenWithLink(java.lang.String defaultOpenWithLink) {
    this.defaultOpenWithLink = defaultOpenWithLink;
    return this;
  }

  /**
   * A short description of the file.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * A short description of the file.
   * @param description description or {@code null} for none
   */
  public File setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * @return value or {@code null} for none
   */
  public java.lang.String getDownloadUrl() {
    return downloadUrl;
  }

  /**
   * @param downloadUrl downloadUrl or {@code null} for none
   */
  public File setDownloadUrl(java.lang.String downloadUrl) {
    this.downloadUrl = downloadUrl;
    return this;
  }

  /**
   * Deprecated: use capabilities/canEdit.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEditable() {
    return editable;
  }

  /**
   * Deprecated: use capabilities/canEdit.
   * @param editable editable or {@code null} for none
   */
  public File setEditable(java.lang.Boolean editable) {
    this.editable = editable;
    return this;
  }

  /**
   * A link for embedding the file.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmbedLink() {
    return embedLink;
  }

  /**
   * A link for embedding the file.
   * @param embedLink embedLink or {@code null} for none
   */
  public File setEmbedLink(java.lang.String embedLink) {
    this.embedLink = embedLink;
    return this;
  }

  /**
   * ETag of the file.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * ETag of the file.
   * @param etag etag or {@code null} for none
   */
  public File setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Whether this file has been explicitly trashed, as opposed to recursively trashed.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getExplicitlyTrashed() {
    return explicitlyTrashed;
  }

  /**
   * Whether this file has been explicitly trashed, as opposed to recursively trashed.
   * @param explicitlyTrashed explicitlyTrashed or {@code null} for none
   */
  public File setExplicitlyTrashed(java.lang.Boolean explicitlyTrashed) {
    this.explicitlyTrashed = explicitlyTrashed;
    return this;
  }

  /**
   * Links for exporting Google Docs to specific formats.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getExportLinks() {
    return exportLinks;
  }

  /**
   * Links for exporting Google Docs to specific formats.
   * @param exportLinks exportLinks or {@code null} for none
   */
  public File setExportLinks(java.util.Map<String, java.lang.String> exportLinks) {
    this.exportLinks = exportLinks;
    return this;
  }

  /**
   * The final component of fullFileExtension with trailing text that does not appear to be part of
   * the extension removed. This field is only populated for files with content stored in Drive; it
   * is not populated for Google Docs or shortcut files.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileExtension() {
    return fileExtension;
  }

  /**
   * The final component of fullFileExtension with trailing text that does not appear to be part of
   * the extension removed. This field is only populated for files with content stored in Drive; it
   * is not populated for Google Docs or shortcut files.
   * @param fileExtension fileExtension or {@code null} for none
   */
  public File setFileExtension(java.lang.String fileExtension) {
    this.fileExtension = fileExtension;
    return this;
  }

  /**
   * The size of the file in bytes. This field is only populated for files with content stored in
   * Drive; it is not populated for Google Docs or shortcut files.
   * @return value or {@code null} for none
   */
  public java.lang.Long getFileSize() {
    return fileSize;
  }

  /**
   * The size of the file in bytes. This field is only populated for files with content stored in
   * Drive; it is not populated for Google Docs or shortcut files.
   * @param fileSize fileSize or {@code null} for none
   */
  public File setFileSize(java.lang.Long fileSize) {
    this.fileSize = fileSize;
    return this;
  }

  /**
   * Folder color as an RGB hex string if the file is a folder. The list of supported colors is
   * available in the folderColorPalette field of the About resource. If an unsupported color is
   * specified, it will be changed to the closest color in the palette. Not populated for Team Drive
   * files.
   * @return value or {@code null} for none
   */
  public java.lang.String getFolderColorRgb() {
    return folderColorRgb;
  }

  /**
   * Folder color as an RGB hex string if the file is a folder. The list of supported colors is
   * available in the folderColorPalette field of the About resource. If an unsupported color is
   * specified, it will be changed to the closest color in the palette. Not populated for Team Drive
   * files.
   * @param folderColorRgb folderColorRgb or {@code null} for none
   */
  public File setFolderColorRgb(java.lang.String folderColorRgb) {
    this.folderColorRgb = folderColorRgb;
    return this;
  }

  /**
   * The full file extension; extracted from the title. May contain multiple concatenated
   * extensions, such as "tar.gz". Removing an extension from the title does not clear this field;
   * however, changing the extension on the title does update this field. This field is only
   * populated for files with content stored in Drive; it is not populated for Google Docs or
   * shortcut files.
   * @return value or {@code null} for none
   */
  public java.lang.String getFullFileExtension() {
    return fullFileExtension;
  }

  /**
   * The full file extension; extracted from the title. May contain multiple concatenated
   * extensions, such as "tar.gz". Removing an extension from the title does not clear this field;
   * however, changing the extension on the title does update this field. This field is only
   * populated for files with content stored in Drive; it is not populated for Google Docs or
   * shortcut files.
   * @param fullFileExtension fullFileExtension or {@code null} for none
   */
  public File setFullFileExtension(java.lang.String fullFileExtension) {
    this.fullFileExtension = fullFileExtension;
    return this;
  }

  /**
   * Whether any users are granted file access directly on this file. This field is only populated
   * for Team Drive files.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasAugmentedPermissions() {
    return hasAugmentedPermissions;
  }

  /**
   * Whether any users are granted file access directly on this file. This field is only populated
   * for Team Drive files.
   * @param hasAugmentedPermissions hasAugmentedPermissions or {@code null} for none
   */
  public File setHasAugmentedPermissions(java.lang.Boolean hasAugmentedPermissions) {
    this.hasAugmentedPermissions = hasAugmentedPermissions;
    return this;
  }

  /**
   * Whether this file has a thumbnail. This does not indicate whether the requesting app has access
   * to the thumbnail. To check access, look for the presence of the thumbnailLink field.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getHasThumbnail() {
    return hasThumbnail;
  }

  /**
   * Whether this file has a thumbnail. This does not indicate whether the requesting app has access
   * to the thumbnail. To check access, look for the presence of the thumbnailLink field.
   * @param hasThumbnail hasThumbnail or {@code null} for none
   */
  public File setHasThumbnail(java.lang.Boolean hasThumbnail) {
    this.hasThumbnail = hasThumbnail;
    return this;
  }

  /**
   * The ID of the file's head revision. This field is only populated for files with content stored
   * in Drive; it is not populated for Google Docs or shortcut files.
   * @return value or {@code null} for none
   */
  public java.lang.String getHeadRevisionId() {
    return headRevisionId;
  }

  /**
   * The ID of the file's head revision. This field is only populated for files with content stored
   * in Drive; it is not populated for Google Docs or shortcut files.
   * @param headRevisionId headRevisionId or {@code null} for none
   */
  public File setHeadRevisionId(java.lang.String headRevisionId) {
    this.headRevisionId = headRevisionId;
    return this;
  }

  /**
   * A link to the file's icon.
   * @return value or {@code null} for none
   */
  public java.lang.String getIconLink() {
    return iconLink;
  }

  /**
   * A link to the file's icon.
   * @param iconLink iconLink or {@code null} for none
   */
  public File setIconLink(java.lang.String iconLink) {
    this.iconLink = iconLink;
    return this;
  }

  /**
   * The ID of the file.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of the file.
   * @param id id or {@code null} for none
   */
  public File setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Metadata about image media. This will only be present for image types, and its contents will
   * depend on what can be parsed from the image content.
   * @return value or {@code null} for none
   */
  public ImageMediaMetadata getImageMediaMetadata() {
    return imageMediaMetadata;
  }

  /**
   * Metadata about image media. This will only be present for image types, and its contents will
   * depend on what can be parsed from the image content.
   * @param imageMediaMetadata imageMediaMetadata or {@code null} for none
   */
  public File setImageMediaMetadata(ImageMediaMetadata imageMediaMetadata) {
    this.imageMediaMetadata = imageMediaMetadata;
    return this;
  }

  /**
   * Indexable text attributes for the file (can only be written)
   * @return value or {@code null} for none
   */
  public IndexableText getIndexableText() {
    return indexableText;
  }

  /**
   * Indexable text attributes for the file (can only be written)
   * @param indexableText indexableText or {@code null} for none
   */
  public File setIndexableText(IndexableText indexableText) {
    this.indexableText = indexableText;
    return this;
  }

  /**
   * Whether the file was created or opened by the requesting app.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsAppAuthorized() {
    return isAppAuthorized;
  }

  /**
   * Whether the file was created or opened by the requesting app.
   * @param isAppAuthorized isAppAuthorized or {@code null} for none
   */
  public File setIsAppAuthorized(java.lang.Boolean isAppAuthorized) {
    this.isAppAuthorized = isAppAuthorized;
    return this;
  }

  /**
   * The type of file. This is always drive#file.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The type of file. This is always drive#file.
   * @param kind kind or {@code null} for none
   */
  public File setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A group of labels for the file.
   * @return value or {@code null} for none
   */
  public Labels getLabels() {
    return labels;
  }

  /**
   * A group of labels for the file.
   * @param labels labels or {@code null} for none
   */
  public File setLabels(Labels labels) {
    this.labels = labels;
    return this;
  }

  /**
   * The last user to modify this file.
   * @return value or {@code null} for none
   */
  public User getLastModifyingUser() {
    return lastModifyingUser;
  }

  /**
   * The last user to modify this file.
   * @param lastModifyingUser lastModifyingUser or {@code null} for none
   */
  public File setLastModifyingUser(User lastModifyingUser) {
    this.lastModifyingUser = lastModifyingUser;
    return this;
  }

  /**
   * Name of the last user to modify this file.
   * @return value or {@code null} for none
   */
  public java.lang.String getLastModifyingUserName() {
    return lastModifyingUserName;
  }

  /**
   * Name of the last user to modify this file.
   * @param lastModifyingUserName lastModifyingUserName or {@code null} for none
   */
  public File setLastModifyingUserName(java.lang.String lastModifyingUserName) {
    this.lastModifyingUserName = lastModifyingUserName;
    return this;
  }

  /**
   * Last time this file was viewed by the user (formatted RFC 3339 timestamp).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getLastViewedByMeDate() {
    return lastViewedByMeDate;
  }

  /**
   * Last time this file was viewed by the user (formatted RFC 3339 timestamp).
   * @param lastViewedByMeDate lastViewedByMeDate or {@code null} for none
   */
  public File setLastViewedByMeDate(com.google.api.client.util.DateTime lastViewedByMeDate) {
    this.lastViewedByMeDate = lastViewedByMeDate;
    return this;
  }

  /**
   * Deprecated.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getMarkedViewedByMeDate() {
    return markedViewedByMeDate;
  }

  /**
   * Deprecated.
   * @param markedViewedByMeDate markedViewedByMeDate or {@code null} for none
   */
  public File setMarkedViewedByMeDate(com.google.api.client.util.DateTime markedViewedByMeDate) {
    this.markedViewedByMeDate = markedViewedByMeDate;
    return this;
  }

  /**
   * An MD5 checksum for the content of this file. This field is only populated for files with
   * content stored in Drive; it is not populated for Google Docs or shortcut files.
   * @return value or {@code null} for none
   */
  public java.lang.String getMd5Checksum() {
    return md5Checksum;
  }

  /**
   * An MD5 checksum for the content of this file. This field is only populated for files with
   * content stored in Drive; it is not populated for Google Docs or shortcut files.
   * @param md5Checksum md5Checksum or {@code null} for none
   */
  public File setMd5Checksum(java.lang.String md5Checksum) {
    this.md5Checksum = md5Checksum;
    return this;
  }

  /**
   * The MIME type of the file. This is only mutable on update when uploading new content. This
   * field can be left blank, and the mimetype will be determined from the uploaded content's MIME
   * type.
   * @return value or {@code null} for none
   */
  public java.lang.String getMimeType() {
    return mimeType;
  }

  /**
   * The MIME type of the file. This is only mutable on update when uploading new content. This
   * field can be left blank, and the mimetype will be determined from the uploaded content's MIME
   * type.
   * @param mimeType mimeType or {@code null} for none
   */
  public File setMimeType(java.lang.String mimeType) {
    this.mimeType = mimeType;
    return this;
  }

  /**
   * Last time this file was modified by the user (formatted RFC 3339 timestamp). Note that setting
   * modifiedDate will also update the modifiedByMe date for the user which set the date.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getModifiedByMeDate() {
    return modifiedByMeDate;
  }

  /**
   * Last time this file was modified by the user (formatted RFC 3339 timestamp). Note that setting
   * modifiedDate will also update the modifiedByMe date for the user which set the date.
   * @param modifiedByMeDate modifiedByMeDate or {@code null} for none
   */
  public File setModifiedByMeDate(com.google.api.client.util.DateTime modifiedByMeDate) {
    this.modifiedByMeDate = modifiedByMeDate;
    return this;
  }

  /**
   * Last time this file was modified by anyone (formatted RFC 3339 timestamp). This is only mutable
   * on update when the setModifiedDate parameter is set.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getModifiedDate() {
    return modifiedDate;
  }

  /**
   * Last time this file was modified by anyone (formatted RFC 3339 timestamp). This is only mutable
   * on update when the setModifiedDate parameter is set.
   * @param modifiedDate modifiedDate or {@code null} for none
   */
  public File setModifiedDate(com.google.api.client.util.DateTime modifiedDate) {
    this.modifiedDate = modifiedDate;
    return this;
  }

  /**
   * A map of the id of each of the user's apps to a link to open this file with that app. Only
   * populated when the drive.apps.readonly scope is used.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getOpenWithLinks() {
    return openWithLinks;
  }

  /**
   * A map of the id of each of the user's apps to a link to open this file with that app. Only
   * populated when the drive.apps.readonly scope is used.
   * @param openWithLinks openWithLinks or {@code null} for none
   */
  public File setOpenWithLinks(java.util.Map<String, java.lang.String> openWithLinks) {
    this.openWithLinks = openWithLinks;
    return this;
  }

  /**
   * The original filename of the uploaded content if available, or else the original value of the
   * title field. This is only available for files with binary content in Drive.
   * @return value or {@code null} for none
   */
  public java.lang.String getOriginalFilename() {
    return originalFilename;
  }

  /**
   * The original filename of the uploaded content if available, or else the original value of the
   * title field. This is only available for files with binary content in Drive.
   * @param originalFilename originalFilename or {@code null} for none
   */
  public File setOriginalFilename(java.lang.String originalFilename) {
    this.originalFilename = originalFilename;
    return this;
  }

  /**
   * Whether the file is owned by the current user. Not populated for Team Drive files.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getOwnedByMe() {
    return ownedByMe;
  }

  /**
   * Whether the file is owned by the current user. Not populated for Team Drive files.
   * @param ownedByMe ownedByMe or {@code null} for none
   */
  public File setOwnedByMe(java.lang.Boolean ownedByMe) {
    this.ownedByMe = ownedByMe;
    return this;
  }

  /**
   * Name(s) of the owner(s) of this file. Not populated for Team Drive files.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getOwnerNames() {
    return ownerNames;
  }

  /**
   * Name(s) of the owner(s) of this file. Not populated for Team Drive files.
   * @param ownerNames ownerNames or {@code null} for none
   */
  public File setOwnerNames(java.util.List<java.lang.String> ownerNames) {
    this.ownerNames = ownerNames;
    return this;
  }

  /**
   * The owner(s) of this file. Not populated for Team Drive files.
   * @return value or {@code null} for none
   */
  public java.util.List<User> getOwners() {
    return owners;
  }

  /**
   * The owner(s) of this file. Not populated for Team Drive files.
   * @param owners owners or {@code null} for none
   */
  public File setOwners(java.util.List<User> owners) {
    this.owners = owners;
    return this;
  }

  /**
   * Collection of parent folders which contain this file. If not specified as part of an insert
   * request, the file will be placed directly in the user's My Drive folder. If not specified as
   * part of a copy request, the file will inherit any discoverable parents of the source file.
   * Update requests can also use the addParents and removeParents parameters to modify the parents
   * list.
   * @return value or {@code null} for none
   */
  public java.util.List<ParentReference> getParents() {
    return parents;
  }

  /**
   * Collection of parent folders which contain this file. If not specified as part of an insert
   * request, the file will be placed directly in the user's My Drive folder. If not specified as
   * part of a copy request, the file will inherit any discoverable parents of the source file.
   * Update requests can also use the addParents and removeParents parameters to modify the parents
   * list.
   * @param parents parents or {@code null} for none
   */
  public File setParents(java.util.List<ParentReference> parents) {
    this.parents = parents;
    return this;
  }

  /**
   * List of permission IDs for users with access to this file.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPermissionIds() {
    return permissionIds;
  }

  /**
   * List of permission IDs for users with access to this file.
   * @param permissionIds permissionIds or {@code null} for none
   */
  public File setPermissionIds(java.util.List<java.lang.String> permissionIds) {
    this.permissionIds = permissionIds;
    return this;
  }

  /**
   * The list of permissions for users with access to this file. Not populated for Team Drive files.
   * @return value or {@code null} for none
   */
  public java.util.List<Permission> getPermissions() {
    return permissions;
  }

  /**
   * The list of permissions for users with access to this file. Not populated for Team Drive files.
   * @param permissions permissions or {@code null} for none
   */
  public File setPermissions(java.util.List<Permission> permissions) {
    this.permissions = permissions;
    return this;
  }

  /**
   * The list of properties.
   * @return value or {@code null} for none
   */
  public java.util.List<Property> getProperties() {
    return properties;
  }

  /**
   * The list of properties.
   * @param properties properties or {@code null} for none
   */
  public File setProperties(java.util.List<Property> properties) {
    this.properties = properties;
    return this;
  }

  /**
   * The number of quota bytes used by this file.
   * @return value or {@code null} for none
   */
  public java.lang.Long getQuotaBytesUsed() {
    return quotaBytesUsed;
  }

  /**
   * The number of quota bytes used by this file.
   * @param quotaBytesUsed quotaBytesUsed or {@code null} for none
   */
  public File setQuotaBytesUsed(java.lang.Long quotaBytesUsed) {
    this.quotaBytesUsed = quotaBytesUsed;
    return this;
  }

  /**
   * A link back to this file.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * A link back to this file.
   * @param selfLink selfLink or {@code null} for none
   */
  public File setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Deprecated: use capabilities/canShare.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getShareable() {
    return shareable;
  }

  /**
   * Deprecated: use capabilities/canShare.
   * @param shareable shareable or {@code null} for none
   */
  public File setShareable(java.lang.Boolean shareable) {
    this.shareable = shareable;
    return this;
  }

  /**
   * Whether the file has been shared. Not populated for Team Drive files.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getShared() {
    return shared;
  }

  /**
   * Whether the file has been shared. Not populated for Team Drive files.
   * @param shared shared or {@code null} for none
   */
  public File setShared(java.lang.Boolean shared) {
    this.shared = shared;
    return this;
  }

  /**
   * Time at which this file was shared with the user (formatted RFC 3339 timestamp).
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getSharedWithMeDate() {
    return sharedWithMeDate;
  }

  /**
   * Time at which this file was shared with the user (formatted RFC 3339 timestamp).
   * @param sharedWithMeDate sharedWithMeDate or {@code null} for none
   */
  public File setSharedWithMeDate(com.google.api.client.util.DateTime sharedWithMeDate) {
    this.sharedWithMeDate = sharedWithMeDate;
    return this;
  }

  /**
   * User that shared the item with the current user, if available.
   * @return value or {@code null} for none
   */
  public User getSharingUser() {
    return sharingUser;
  }

  /**
   * User that shared the item with the current user, if available.
   * @param sharingUser sharingUser or {@code null} for none
   */
  public File setSharingUser(User sharingUser) {
    this.sharingUser = sharingUser;
    return this;
  }

  /**
   * The list of spaces which contain the file. Supported values are 'drive', 'appDataFolder' and
   * 'photos'.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSpaces() {
    return spaces;
  }

  /**
   * The list of spaces which contain the file. Supported values are 'drive', 'appDataFolder' and
   * 'photos'.
   * @param spaces spaces or {@code null} for none
   */
  public File setSpaces(java.util.List<java.lang.String> spaces) {
    this.spaces = spaces;
    return this;
  }

  /**
   * ID of the Team Drive the file resides in.
   * @return value or {@code null} for none
   */
  public java.lang.String getTeamDriveId() {
    return teamDriveId;
  }

  /**
   * ID of the Team Drive the file resides in.
   * @param teamDriveId teamDriveId or {@code null} for none
   */
  public File setTeamDriveId(java.lang.String teamDriveId) {
    this.teamDriveId = teamDriveId;
    return this;
  }

  /**
   * A thumbnail for the file. This will only be used if Drive cannot generate a standard thumbnail.
   * @return value or {@code null} for none
   */
  public Thumbnail getThumbnail() {
    return thumbnail;
  }

  /**
   * A thumbnail for the file. This will only be used if Drive cannot generate a standard thumbnail.
   * @param thumbnail thumbnail or {@code null} for none
   */
  public File setThumbnail(Thumbnail thumbnail) {
    this.thumbnail = thumbnail;
    return this;
  }

  /**
   * A short-lived link to the file's thumbnail. Typically lasts on the order of hours. Only
   * populated when the requesting app can access the file's content.
   * @return value or {@code null} for none
   */
  public java.lang.String getThumbnailLink() {
    return thumbnailLink;
  }

  /**
   * A short-lived link to the file's thumbnail. Typically lasts on the order of hours. Only
   * populated when the requesting app can access the file's content.
   * @param thumbnailLink thumbnailLink or {@code null} for none
   */
  public File setThumbnailLink(java.lang.String thumbnailLink) {
    this.thumbnailLink = thumbnailLink;
    return this;
  }

  /**
   * The thumbnail version for use in thumbnail cache invalidation.
   * @return value or {@code null} for none
   */
  public java.lang.Long getThumbnailVersion() {
    return thumbnailVersion;
  }

  /**
   * The thumbnail version for use in thumbnail cache invalidation.
   * @param thumbnailVersion thumbnailVersion or {@code null} for none
   */
  public File setThumbnailVersion(java.lang.Long thumbnailVersion) {
    this.thumbnailVersion = thumbnailVersion;
    return this;
  }

  /**
   * The title of this file. Note that for immutable items such as the top level folders of Team
   * Drives, My Drive root folder, and Application Data folder the title is constant.
   * @return value or {@code null} for none
   */
  public java.lang.String getTitle() {
    return title;
  }

  /**
   * The title of this file. Note that for immutable items such as the top level folders of Team
   * Drives, My Drive root folder, and Application Data folder the title is constant.
   * @param title title or {@code null} for none
   */
  public File setTitle(java.lang.String title) {
    this.title = title;
    return this;
  }

  /**
   * The time that the item was trashed (formatted RFC 3339 timestamp). Only populated for Team
   * Drive files.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getTrashedDate() {
    return trashedDate;
  }

  /**
   * The time that the item was trashed (formatted RFC 3339 timestamp). Only populated for Team
   * Drive files.
   * @param trashedDate trashedDate or {@code null} for none
   */
  public File setTrashedDate(com.google.api.client.util.DateTime trashedDate) {
    this.trashedDate = trashedDate;
    return this;
  }

  /**
   * If the file has been explicitly trashed, the user who trashed it. Only populated for Team Drive
   * files.
   * @return value or {@code null} for none
   */
  public User getTrashingUser() {
    return trashingUser;
  }

  /**
   * If the file has been explicitly trashed, the user who trashed it. Only populated for Team Drive
   * files.
   * @param trashingUser trashingUser or {@code null} for none
   */
  public File setTrashingUser(User trashingUser) {
    this.trashingUser = trashingUser;
    return this;
  }

  /**
   * The permissions for the authenticated user on this file.
   * @return value or {@code null} for none
   */
  public Permission getUserPermission() {
    return userPermission;
  }

  /**
   * The permissions for the authenticated user on this file.
   * @param userPermission userPermission or {@code null} for none
   */
  public File setUserPermission(Permission userPermission) {
    this.userPermission = userPermission;
    return this;
  }

  /**
   * A monotonically increasing version number for the file. This reflects every change made to the
   * file on the server, even those not visible to the requesting user.
   * @return value or {@code null} for none
   */
  public java.lang.Long getVersion() {
    return version;
  }

  /**
   * A monotonically increasing version number for the file. This reflects every change made to the
   * file on the server, even those not visible to the requesting user.
   * @param version version or {@code null} for none
   */
  public File setVersion(java.lang.Long version) {
    this.version = version;
    return this;
  }

  /**
   * Metadata about video media. This will only be present for video types.
   * @return value or {@code null} for none
   */
  public VideoMediaMetadata getVideoMediaMetadata() {
    return videoMediaMetadata;
  }

  /**
   * Metadata about video media. This will only be present for video types.
   * @param videoMediaMetadata videoMediaMetadata or {@code null} for none
   */
  public File setVideoMediaMetadata(VideoMediaMetadata videoMediaMetadata) {
    this.videoMediaMetadata = videoMediaMetadata;
    return this;
  }

  /**
   * A link for downloading the content of the file in a browser using cookie based authentication.
   * In cases where the content is shared publicly, the content can be downloaded without any
   * credentials.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebContentLink() {
    return webContentLink;
  }

  /**
   * A link for downloading the content of the file in a browser using cookie based authentication.
   * In cases where the content is shared publicly, the content can be downloaded without any
   * credentials.
   * @param webContentLink webContentLink or {@code null} for none
   */
  public File setWebContentLink(java.lang.String webContentLink) {
    this.webContentLink = webContentLink;
    return this;
  }

  /**
   * A link only available on public folders for viewing their static web assets (HTML, CSS, JS,
   * etc) via Google Drive's Website Hosting.
   * @return value or {@code null} for none
   */
  public java.lang.String getWebViewLink() {
    return webViewLink;
  }

  /**
   * A link only available on public folders for viewing their static web assets (HTML, CSS, JS,
   * etc) via Google Drive's Website Hosting.
   * @param webViewLink webViewLink or {@code null} for none
   */
  public File setWebViewLink(java.lang.String webViewLink) {
    this.webViewLink = webViewLink;
    return this;
  }

  /**
   * Whether writers can share the document with other users. Not populated for Team Drive files.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWritersCanShare() {
    return writersCanShare;
  }

  /**
   * Whether writers can share the document with other users. Not populated for Team Drive files.
   * @param writersCanShare writersCanShare or {@code null} for none
   */
  public File setWritersCanShare(java.lang.Boolean writersCanShare) {
    this.writersCanShare = writersCanShare;
    return this;
  }

  @Override
  public File set(String fieldName, Object value) {
    return (File) super.set(fieldName, value);
  }

  @Override
  public File clone() {
    return (File) super.clone();
  }

  /**
   * Capabilities the current user has on this file. Each capability corresponds to a fine-grained
   * action that a user may take.
   */
  public static final class Capabilities extends com.google.api.client.json.GenericJson {

    /**
     * Whether the current user can add children to this folder. This is always false when the item is
     * not a folder.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canAddChildren;

    /**
     * Whether the current user can change the restricted download label of this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canChangeRestrictedDownload;

    /**
     * Whether the current user can comment on this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canComment;

    /**
     * Whether the current user can copy this file. For a Team Drive item, whether the current user
     * can copy non-folder descendants of this item, or this item itself if it is not a folder.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canCopy;

    /**
     * Whether the current user can delete this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canDelete;

    /**
     * Whether the current user can download this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canDownload;

    /**
     * Whether the current user can edit this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canEdit;

    /**
     * Whether the current user can list the children of this folder. This is always false when the
     * item is not a folder.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canListChildren;

    /**
     * Whether the current user can move this item into a Team Drive. If the item is in a Team Drive,
     * this field is equivalent to canMoveTeamDriveItem.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveItemIntoTeamDrive;

    /**
     * Whether the current user can move this Team Drive item by changing its parent. Note that a
     * request to change the parent for this item may still fail depending on the new parent that is
     * being added. Only populated for Team Drive files.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canMoveTeamDriveItem;

    /**
     * Whether the current user can read the revisions resource of this file. For a Team Drive item,
     * whether revisions of non-folder descendants of this item, or this item itself if it is not a
     * folder, can be read.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canReadRevisions;

    /**
     * Whether the current user can read the Team Drive to which this file belongs. Only populated for
     * Team Drive files.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canReadTeamDrive;

    /**
     * Whether the current user can remove children from this folder. This is always false when the
     * item is not a folder.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canRemoveChildren;

    /**
     * Whether the current user can rename this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canRename;

    /**
     * Whether the current user can modify the sharing settings for this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canShare;

    /**
     * Whether the current user can move this file to trash.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canTrash;

    /**
     * Whether the current user can restore this file from trash.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean canUntrash;

    /**
     * Whether the current user can add children to this folder. This is always false when the item is
     * not a folder.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanAddChildren() {
      return canAddChildren;
    }

    /**
     * Whether the current user can add children to this folder. This is always false when the item is
     * not a folder.
     * @param canAddChildren canAddChildren or {@code null} for none
     */
    public Capabilities setCanAddChildren(java.lang.Boolean canAddChildren) {
      this.canAddChildren = canAddChildren;
      return this;
    }

    /**
     * Whether the current user can change the restricted download label of this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanChangeRestrictedDownload() {
      return canChangeRestrictedDownload;
    }

    /**
     * Whether the current user can change the restricted download label of this file.
     * @param canChangeRestrictedDownload canChangeRestrictedDownload or {@code null} for none
     */
    public Capabilities setCanChangeRestrictedDownload(java.lang.Boolean canChangeRestrictedDownload) {
      this.canChangeRestrictedDownload = canChangeRestrictedDownload;
      return this;
    }

    /**
     * Whether the current user can comment on this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanComment() {
      return canComment;
    }

    /**
     * Whether the current user can comment on this file.
     * @param canComment canComment or {@code null} for none
     */
    public Capabilities setCanComment(java.lang.Boolean canComment) {
      this.canComment = canComment;
      return this;
    }

    /**
     * Whether the current user can copy this file. For a Team Drive item, whether the current user
     * can copy non-folder descendants of this item, or this item itself if it is not a folder.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanCopy() {
      return canCopy;
    }

    /**
     * Whether the current user can copy this file. For a Team Drive item, whether the current user
     * can copy non-folder descendants of this item, or this item itself if it is not a folder.
     * @param canCopy canCopy or {@code null} for none
     */
    public Capabilities setCanCopy(java.lang.Boolean canCopy) {
      this.canCopy = canCopy;
      return this;
    }

    /**
     * Whether the current user can delete this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanDelete() {
      return canDelete;
    }

    /**
     * Whether the current user can delete this file.
     * @param canDelete canDelete or {@code null} for none
     */
    public Capabilities setCanDelete(java.lang.Boolean canDelete) {
      this.canDelete = canDelete;
      return this;
    }

    /**
     * Whether the current user can download this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanDownload() {
      return canDownload;
    }

    /**
     * Whether the current user can download this file.
     * @param canDownload canDownload or {@code null} for none
     */
    public Capabilities setCanDownload(java.lang.Boolean canDownload) {
      this.canDownload = canDownload;
      return this;
    }

    /**
     * Whether the current user can edit this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanEdit() {
      return canEdit;
    }

    /**
     * Whether the current user can edit this file.
     * @param canEdit canEdit or {@code null} for none
     */
    public Capabilities setCanEdit(java.lang.Boolean canEdit) {
      this.canEdit = canEdit;
      return this;
    }

    /**
     * Whether the current user can list the children of this folder. This is always false when the
     * item is not a folder.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanListChildren() {
      return canListChildren;
    }

    /**
     * Whether the current user can list the children of this folder. This is always false when the
     * item is not a folder.
     * @param canListChildren canListChildren or {@code null} for none
     */
    public Capabilities setCanListChildren(java.lang.Boolean canListChildren) {
      this.canListChildren = canListChildren;
      return this;
    }

    /**
     * Whether the current user can move this item into a Team Drive. If the item is in a Team Drive,
     * this field is equivalent to canMoveTeamDriveItem.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveItemIntoTeamDrive() {
      return canMoveItemIntoTeamDrive;
    }

    /**
     * Whether the current user can move this item into a Team Drive. If the item is in a Team Drive,
     * this field is equivalent to canMoveTeamDriveItem.
     * @param canMoveItemIntoTeamDrive canMoveItemIntoTeamDrive or {@code null} for none
     */
    public Capabilities setCanMoveItemIntoTeamDrive(java.lang.Boolean canMoveItemIntoTeamDrive) {
      this.canMoveItemIntoTeamDrive = canMoveItemIntoTeamDrive;
      return this;
    }

    /**
     * Whether the current user can move this Team Drive item by changing its parent. Note that a
     * request to change the parent for this item may still fail depending on the new parent that is
     * being added. Only populated for Team Drive files.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanMoveTeamDriveItem() {
      return canMoveTeamDriveItem;
    }

    /**
     * Whether the current user can move this Team Drive item by changing its parent. Note that a
     * request to change the parent for this item may still fail depending on the new parent that is
     * being added. Only populated for Team Drive files.
     * @param canMoveTeamDriveItem canMoveTeamDriveItem or {@code null} for none
     */
    public Capabilities setCanMoveTeamDriveItem(java.lang.Boolean canMoveTeamDriveItem) {
      this.canMoveTeamDriveItem = canMoveTeamDriveItem;
      return this;
    }

    /**
     * Whether the current user can read the revisions resource of this file. For a Team Drive item,
     * whether revisions of non-folder descendants of this item, or this item itself if it is not a
     * folder, can be read.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanReadRevisions() {
      return canReadRevisions;
    }

    /**
     * Whether the current user can read the revisions resource of this file. For a Team Drive item,
     * whether revisions of non-folder descendants of this item, or this item itself if it is not a
     * folder, can be read.
     * @param canReadRevisions canReadRevisions or {@code null} for none
     */
    public Capabilities setCanReadRevisions(java.lang.Boolean canReadRevisions) {
      this.canReadRevisions = canReadRevisions;
      return this;
    }

    /**
     * Whether the current user can read the Team Drive to which this file belongs. Only populated for
     * Team Drive files.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanReadTeamDrive() {
      return canReadTeamDrive;
    }

    /**
     * Whether the current user can read the Team Drive to which this file belongs. Only populated for
     * Team Drive files.
     * @param canReadTeamDrive canReadTeamDrive or {@code null} for none
     */
    public Capabilities setCanReadTeamDrive(java.lang.Boolean canReadTeamDrive) {
      this.canReadTeamDrive = canReadTeamDrive;
      return this;
    }

    /**
     * Whether the current user can remove children from this folder. This is always false when the
     * item is not a folder.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanRemoveChildren() {
      return canRemoveChildren;
    }

    /**
     * Whether the current user can remove children from this folder. This is always false when the
     * item is not a folder.
     * @param canRemoveChildren canRemoveChildren or {@code null} for none
     */
    public Capabilities setCanRemoveChildren(java.lang.Boolean canRemoveChildren) {
      this.canRemoveChildren = canRemoveChildren;
      return this;
    }

    /**
     * Whether the current user can rename this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanRename() {
      return canRename;
    }

    /**
     * Whether the current user can rename this file.
     * @param canRename canRename or {@code null} for none
     */
    public Capabilities setCanRename(java.lang.Boolean canRename) {
      this.canRename = canRename;
      return this;
    }

    /**
     * Whether the current user can modify the sharing settings for this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanShare() {
      return canShare;
    }

    /**
     * Whether the current user can modify the sharing settings for this file.
     * @param canShare canShare or {@code null} for none
     */
    public Capabilities setCanShare(java.lang.Boolean canShare) {
      this.canShare = canShare;
      return this;
    }

    /**
     * Whether the current user can move this file to trash.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanTrash() {
      return canTrash;
    }

    /**
     * Whether the current user can move this file to trash.
     * @param canTrash canTrash or {@code null} for none
     */
    public Capabilities setCanTrash(java.lang.Boolean canTrash) {
      this.canTrash = canTrash;
      return this;
    }

    /**
     * Whether the current user can restore this file from trash.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getCanUntrash() {
      return canUntrash;
    }

    /**
     * Whether the current user can restore this file from trash.
     * @param canUntrash canUntrash or {@code null} for none
     */
    public Capabilities setCanUntrash(java.lang.Boolean canUntrash) {
      this.canUntrash = canUntrash;
      return this;
    }

    @Override
    public Capabilities set(String fieldName, Object value) {
      return (Capabilities) super.set(fieldName, value);
    }

    @Override
    public Capabilities clone() {
      return (Capabilities) super.clone();
    }

  }

  /**
   * Metadata about image media. This will only be present for image types, and its contents will
   * depend on what can be parsed from the image content.
   */
  public static final class ImageMediaMetadata extends com.google.api.client.json.GenericJson {

    /**
     * The aperture used to create the photo (f-number).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Float aperture;

    /**
     * The make of the camera used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String cameraMake;

    /**
     * The model of the camera used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String cameraModel;

    /**
     * The color space of the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String colorSpace;

    /**
     * The date and time the photo was taken (EXIF format timestamp).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String date;

    /**
     * The exposure bias of the photo (APEX value).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Float exposureBias;

    /**
     * The exposure mode used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String exposureMode;

    /**
     * The length of the exposure, in seconds.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Float exposureTime;

    /**
     * Whether a flash was used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean flashUsed;

    /**
     * The focal length used to create the photo, in millimeters.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Float focalLength;

    /**
     * The height of the image in pixels.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer height;

    /**
     * The ISO speed used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer isoSpeed;

    /**
     * The lens used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String lens;

    /**
     * Geographic location information stored in the image.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private Location location;

    /**
     * The smallest f-number of the lens at the focal length used to create the photo (APEX value).
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Float maxApertureValue;

    /**
     * The metering mode used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String meteringMode;

    /**
     * The rotation in clockwise degrees from the image's original orientation.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer rotation;

    /**
     * The type of sensor used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String sensor;

    /**
     * The distance to the subject of the photo, in meters.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer subjectDistance;

    /**
     * The white balance mode used to create the photo.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String whiteBalance;

    /**
     * The width of the image in pixels.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer width;

    /**
     * The aperture used to create the photo (f-number).
     * @return value or {@code null} for none
     */
    public java.lang.Float getAperture() {
      return aperture;
    }

    /**
     * The aperture used to create the photo (f-number).
     * @param aperture aperture or {@code null} for none
     */
    public ImageMediaMetadata setAperture(java.lang.Float aperture) {
      this.aperture = aperture;
      return this;
    }

    /**
     * The make of the camera used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getCameraMake() {
      return cameraMake;
    }

    /**
     * The make of the camera used to create the photo.
     * @param cameraMake cameraMake or {@code null} for none
     */
    public ImageMediaMetadata setCameraMake(java.lang.String cameraMake) {
      this.cameraMake = cameraMake;
      return this;
    }

    /**
     * The model of the camera used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getCameraModel() {
      return cameraModel;
    }

    /**
     * The model of the camera used to create the photo.
     * @param cameraModel cameraModel or {@code null} for none
     */
    public ImageMediaMetadata setCameraModel(java.lang.String cameraModel) {
      this.cameraModel = cameraModel;
      return this;
    }

    /**
     * The color space of the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getColorSpace() {
      return colorSpace;
    }

    /**
     * The color space of the photo.
     * @param colorSpace colorSpace or {@code null} for none
     */
    public ImageMediaMetadata setColorSpace(java.lang.String colorSpace) {
      this.colorSpace = colorSpace;
      return this;
    }

    /**
     * The date and time the photo was taken (EXIF format timestamp).
     * @return value or {@code null} for none
     */
    public java.lang.String getDate() {
      return date;
    }

    /**
     * The date and time the photo was taken (EXIF format timestamp).
     * @param date date or {@code null} for none
     */
    public ImageMediaMetadata setDate(java.lang.String date) {
      this.date = date;
      return this;
    }

    /**
     * The exposure bias of the photo (APEX value).
     * @return value or {@code null} for none
     */
    public java.lang.Float getExposureBias() {
      return exposureBias;
    }

    /**
     * The exposure bias of the photo (APEX value).
     * @param exposureBias exposureBias or {@code null} for none
     */
    public ImageMediaMetadata setExposureBias(java.lang.Float exposureBias) {
      this.exposureBias = exposureBias;
      return this;
    }

    /**
     * The exposure mode used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getExposureMode() {
      return exposureMode;
    }

    /**
     * The exposure mode used to create the photo.
     * @param exposureMode exposureMode or {@code null} for none
     */
    public ImageMediaMetadata setExposureMode(java.lang.String exposureMode) {
      this.exposureMode = exposureMode;
      return this;
    }

    /**
     * The length of the exposure, in seconds.
     * @return value or {@code null} for none
     */
    public java.lang.Float getExposureTime() {
      return exposureTime;
    }

    /**
     * The length of the exposure, in seconds.
     * @param exposureTime exposureTime or {@code null} for none
     */
    public ImageMediaMetadata setExposureTime(java.lang.Float exposureTime) {
      this.exposureTime = exposureTime;
      return this;
    }

    /**
     * Whether a flash was used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getFlashUsed() {
      return flashUsed;
    }

    /**
     * Whether a flash was used to create the photo.
     * @param flashUsed flashUsed or {@code null} for none
     */
    public ImageMediaMetadata setFlashUsed(java.lang.Boolean flashUsed) {
      this.flashUsed = flashUsed;
      return this;
    }

    /**
     * The focal length used to create the photo, in millimeters.
     * @return value or {@code null} for none
     */
    public java.lang.Float getFocalLength() {
      return focalLength;
    }

    /**
     * The focal length used to create the photo, in millimeters.
     * @param focalLength focalLength or {@code null} for none
     */
    public ImageMediaMetadata setFocalLength(java.lang.Float focalLength) {
      this.focalLength = focalLength;
      return this;
    }

    /**
     * The height of the image in pixels.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getHeight() {
      return height;
    }

    /**
     * The height of the image in pixels.
     * @param height height or {@code null} for none
     */
    public ImageMediaMetadata setHeight(java.lang.Integer height) {
      this.height = height;
      return this;
    }

    /**
     * The ISO speed used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getIsoSpeed() {
      return isoSpeed;
    }

    /**
     * The ISO speed used to create the photo.
     * @param isoSpeed isoSpeed or {@code null} for none
     */
    public ImageMediaMetadata setIsoSpeed(java.lang.Integer isoSpeed) {
      this.isoSpeed = isoSpeed;
      return this;
    }

    /**
     * The lens used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getLens() {
      return lens;
    }

    /**
     * The lens used to create the photo.
     * @param lens lens or {@code null} for none
     */
    public ImageMediaMetadata setLens(java.lang.String lens) {
      this.lens = lens;
      return this;
    }

    /**
     * Geographic location information stored in the image.
     * @return value or {@code null} for none
     */
    public Location getLocation() {
      return location;
    }

    /**
     * Geographic location information stored in the image.
     * @param location location or {@code null} for none
     */
    public ImageMediaMetadata setLocation(Location location) {
      this.location = location;
      return this;
    }

    /**
     * The smallest f-number of the lens at the focal length used to create the photo (APEX value).
     * @return value or {@code null} for none
     */
    public java.lang.Float getMaxApertureValue() {
      return maxApertureValue;
    }

    /**
     * The smallest f-number of the lens at the focal length used to create the photo (APEX value).
     * @param maxApertureValue maxApertureValue or {@code null} for none
     */
    public ImageMediaMetadata setMaxApertureValue(java.lang.Float maxApertureValue) {
      this.maxApertureValue = maxApertureValue;
      return this;
    }

    /**
     * The metering mode used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getMeteringMode() {
      return meteringMode;
    }

    /**
     * The metering mode used to create the photo.
     * @param meteringMode meteringMode or {@code null} for none
     */
    public ImageMediaMetadata setMeteringMode(java.lang.String meteringMode) {
      this.meteringMode = meteringMode;
      return this;
    }

    /**
     * The rotation in clockwise degrees from the image's original orientation.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getRotation() {
      return rotation;
    }

    /**
     * The rotation in clockwise degrees from the image's original orientation.
     * @param rotation rotation or {@code null} for none
     */
    public ImageMediaMetadata setRotation(java.lang.Integer rotation) {
      this.rotation = rotation;
      return this;
    }

    /**
     * The type of sensor used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getSensor() {
      return sensor;
    }

    /**
     * The type of sensor used to create the photo.
     * @param sensor sensor or {@code null} for none
     */
    public ImageMediaMetadata setSensor(java.lang.String sensor) {
      this.sensor = sensor;
      return this;
    }

    /**
     * The distance to the subject of the photo, in meters.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getSubjectDistance() {
      return subjectDistance;
    }

    /**
     * The distance to the subject of the photo, in meters.
     * @param subjectDistance subjectDistance or {@code null} for none
     */
    public ImageMediaMetadata setSubjectDistance(java.lang.Integer subjectDistance) {
      this.subjectDistance = subjectDistance;
      return this;
    }

    /**
     * The white balance mode used to create the photo.
     * @return value or {@code null} for none
     */
    public java.lang.String getWhiteBalance() {
      return whiteBalance;
    }

    /**
     * The white balance mode used to create the photo.
     * @param whiteBalance whiteBalance or {@code null} for none
     */
    public ImageMediaMetadata setWhiteBalance(java.lang.String whiteBalance) {
      this.whiteBalance = whiteBalance;
      return this;
    }

    /**
     * The width of the image in pixels.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getWidth() {
      return width;
    }

    /**
     * The width of the image in pixels.
     * @param width width or {@code null} for none
     */
    public ImageMediaMetadata setWidth(java.lang.Integer width) {
      this.width = width;
      return this;
    }

    @Override
    public ImageMediaMetadata set(String fieldName, Object value) {
      return (ImageMediaMetadata) super.set(fieldName, value);
    }

    @Override
    public ImageMediaMetadata clone() {
      return (ImageMediaMetadata) super.clone();
    }

    /**
     * Geographic location information stored in the image.
     */
    public static final class Location extends com.google.api.client.json.GenericJson {

      /**
       * The altitude stored in the image.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Double altitude;

      /**
       * The latitude stored in the image.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Double latitude;

      /**
       * The longitude stored in the image.
       * The value may be {@code null}.
       */
      @com.google.api.client.util.Key
      private java.lang.Double longitude;

      /**
       * The altitude stored in the image.
       * @return value or {@code null} for none
       */
      public java.lang.Double getAltitude() {
        return altitude;
      }

      /**
       * The altitude stored in the image.
       * @param altitude altitude or {@code null} for none
       */
      public Location setAltitude(java.lang.Double altitude) {
        this.altitude = altitude;
        return this;
      }

      /**
       * The latitude stored in the image.
       * @return value or {@code null} for none
       */
      public java.lang.Double getLatitude() {
        return latitude;
      }

      /**
       * The latitude stored in the image.
       * @param latitude latitude or {@code null} for none
       */
      public Location setLatitude(java.lang.Double latitude) {
        this.latitude = latitude;
        return this;
      }

      /**
       * The longitude stored in the image.
       * @return value or {@code null} for none
       */
      public java.lang.Double getLongitude() {
        return longitude;
      }

      /**
       * The longitude stored in the image.
       * @param longitude longitude or {@code null} for none
       */
      public Location setLongitude(java.lang.Double longitude) {
        this.longitude = longitude;
        return this;
      }

      @Override
      public Location set(String fieldName, Object value) {
        return (Location) super.set(fieldName, value);
      }

      @Override
      public Location clone() {
        return (Location) super.clone();
      }

    }
  }

  /**
   * Indexable text attributes for the file (can only be written)
   */
  public static final class IndexableText extends com.google.api.client.json.GenericJson {

    /**
     * The text to be indexed for this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String text;

    /**
     * The text to be indexed for this file.
     * @return value or {@code null} for none
     */
    public java.lang.String getText() {
      return text;
    }

    /**
     * The text to be indexed for this file.
     * @param text text or {@code null} for none
     */
    public IndexableText setText(java.lang.String text) {
      this.text = text;
      return this;
    }

    @Override
    public IndexableText set(String fieldName, Object value) {
      return (IndexableText) super.set(fieldName, value);
    }

    @Override
    public IndexableText clone() {
      return (IndexableText) super.clone();
    }

  }

  /**
   * A group of labels for the file.
   */
  public static final class Labels extends com.google.api.client.json.GenericJson {

    /**
     * Deprecated.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean hidden;

    /**
     * Whether the file has been modified by this user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean modified;

    /**
     * Whether viewers and commenters are prevented from downloading, printing, and copying this file.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean restricted;

    /**
     * Whether this file is starred by the user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean starred;

    /**
     * Whether this file has been trashed. This label applies to all users accessing the file;
     * however, only owners are allowed to see and untrash files.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean trashed;

    /**
     * Whether this file has been viewed by this user.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Boolean viewed;

    /**
     * Deprecated.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getHidden() {
      return hidden;
    }

    /**
     * Deprecated.
     * @param hidden hidden or {@code null} for none
     */
    public Labels setHidden(java.lang.Boolean hidden) {
      this.hidden = hidden;
      return this;
    }

    /**
     * Whether the file has been modified by this user.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getModified() {
      return modified;
    }

    /**
     * Whether the file has been modified by this user.
     * @param modified modified or {@code null} for none
     */
    public Labels setModified(java.lang.Boolean modified) {
      this.modified = modified;
      return this;
    }

    /**
     * Whether viewers and commenters are prevented from downloading, printing, and copying this file.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getRestricted() {
      return restricted;
    }

    /**
     * Whether viewers and commenters are prevented from downloading, printing, and copying this file.
     * @param restricted restricted or {@code null} for none
     */
    public Labels setRestricted(java.lang.Boolean restricted) {
      this.restricted = restricted;
      return this;
    }

    /**
     * Whether this file is starred by the user.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getStarred() {
      return starred;
    }

    /**
     * Whether this file is starred by the user.
     * @param starred starred or {@code null} for none
     */
    public Labels setStarred(java.lang.Boolean starred) {
      this.starred = starred;
      return this;
    }

    /**
     * Whether this file has been trashed. This label applies to all users accessing the file;
     * however, only owners are allowed to see and untrash files.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getTrashed() {
      return trashed;
    }

    /**
     * Whether this file has been trashed. This label applies to all users accessing the file;
     * however, only owners are allowed to see and untrash files.
     * @param trashed trashed or {@code null} for none
     */
    public Labels setTrashed(java.lang.Boolean trashed) {
      this.trashed = trashed;
      return this;
    }

    /**
     * Whether this file has been viewed by this user.
     * @return value or {@code null} for none
     */
    public java.lang.Boolean getViewed() {
      return viewed;
    }

    /**
     * Whether this file has been viewed by this user.
     * @param viewed viewed or {@code null} for none
     */
    public Labels setViewed(java.lang.Boolean viewed) {
      this.viewed = viewed;
      return this;
    }

    @Override
    public Labels set(String fieldName, Object value) {
      return (Labels) super.set(fieldName, value);
    }

    @Override
    public Labels clone() {
      return (Labels) super.clone();
    }

  }

  /**
   * A thumbnail for the file. This will only be used if Drive cannot generate a standard thumbnail.
   */
  public static final class Thumbnail extends com.google.api.client.json.GenericJson {

    /**
     * The URL-safe Base64 encoded bytes of the thumbnail image. It should conform to RFC 4648 section
     * 5.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String image;

    /**
     * The MIME type of the thumbnail.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String mimeType;

    /**
     * The URL-safe Base64 encoded bytes of the thumbnail image. It should conform to RFC 4648 section
     * 5.
     * @see #decodeImage()
     * @return value or {@code null} for none
     */
    public java.lang.String getImage() {
      return image;
    }

    /**
     * The URL-safe Base64 encoded bytes of the thumbnail image. It should conform to RFC 4648 section
     * 5.
     * @see #getImage()
     * @return Base64 decoded value or {@code null} for none
     *
     * @since 1.14
     */
    public byte[] decodeImage() {
      return com.google.api.client.util.Base64.decodeBase64(image);
    }

    /**
     * The URL-safe Base64 encoded bytes of the thumbnail image. It should conform to RFC 4648 section
     * 5.
     * @see #encodeImage()
     * @param image image or {@code null} for none
     */
    public Thumbnail setImage(java.lang.String image) {
      this.image = image;
      return this;
    }

    /**
     * The URL-safe Base64 encoded bytes of the thumbnail image. It should conform to RFC 4648 section
     * 5.
     * @see #setImage()
     *
     * <p>
     * The value is encoded Base64 or {@code null} for none.
     * </p>
     *
     * @since 1.14
     */
    public Thumbnail encodeImage(byte[] image) {
      this.image = com.google.api.client.util.Base64.encodeBase64URLSafeString(image);
      return this;
    }

    /**
     * The MIME type of the thumbnail.
     * @return value or {@code null} for none
     */
    public java.lang.String getMimeType() {
      return mimeType;
    }

    /**
     * The MIME type of the thumbnail.
     * @param mimeType mimeType or {@code null} for none
     */
    public Thumbnail setMimeType(java.lang.String mimeType) {
      this.mimeType = mimeType;
      return this;
    }

    @Override
    public Thumbnail set(String fieldName, Object value) {
      return (Thumbnail) super.set(fieldName, value);
    }

    @Override
    public Thumbnail clone() {
      return (Thumbnail) super.clone();
    }

  }

  /**
   * Metadata about video media. This will only be present for video types.
   */
  public static final class VideoMediaMetadata extends com.google.api.client.json.GenericJson {

    /**
     * The duration of the video in milliseconds.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key @com.google.api.client.json.JsonString
    private java.lang.Long durationMillis;

    /**
     * The height of the video in pixels.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer height;

    /**
     * The width of the video in pixels.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.Integer width;

    /**
     * The duration of the video in milliseconds.
     * @return value or {@code null} for none
     */
    public java.lang.Long getDurationMillis() {
      return durationMillis;
    }

    /**
     * The duration of the video in milliseconds.
     * @param durationMillis durationMillis or {@code null} for none
     */
    public VideoMediaMetadata setDurationMillis(java.lang.Long durationMillis) {
      this.durationMillis = durationMillis;
      return this;
    }

    /**
     * The height of the video in pixels.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getHeight() {
      return height;
    }

    /**
     * The height of the video in pixels.
     * @param height height or {@code null} for none
     */
    public VideoMediaMetadata setHeight(java.lang.Integer height) {
      this.height = height;
      return this;
    }

    /**
     * The width of the video in pixels.
     * @return value or {@code null} for none
     */
    public java.lang.Integer getWidth() {
      return width;
    }

    /**
     * The width of the video in pixels.
     * @param width width or {@code null} for none
     */
    public VideoMediaMetadata setWidth(java.lang.Integer width) {
      this.width = width;
      return this;
    }

    @Override
    public VideoMediaMetadata set(String fieldName, Object value) {
      return (VideoMediaMetadata) super.set(fieldName, value);
    }

    @Override
    public VideoMediaMetadata clone() {
      return (VideoMediaMetadata) super.clone();
    }

  }

}
