/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2017-01-11 18:31:16 UTC)
 * on 2017-01-13 at 02:48:19 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A list of third-party applications which the user has installed or given access to Google Drive.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AppList extends com.google.api.client.json.GenericJson {

  /**
   * List of app IDs that the user has specified to use by default. The list is in reverse-priority
   * order (lowest to highest).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> defaultAppIds;

  /**
   * The ETag of the list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The list of apps.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<App> items;

  static {
    // hack to force ProGuard to consider App used, since otherwise it would be stripped out
    // see http://code.google.com/p/google-api-java-client/issues/detail?id=528
    com.google.api.client.util.Data.nullOf(App.class);
  }

  /**
   * This is always drive#appList.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A link back to this list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * List of app IDs that the user has specified to use by default. The list is in reverse-priority
   * order (lowest to highest).
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDefaultAppIds() {
    return defaultAppIds;
  }

  /**
   * List of app IDs that the user has specified to use by default. The list is in reverse-priority
   * order (lowest to highest).
   * @param defaultAppIds defaultAppIds or {@code null} for none
   */
  public AppList setDefaultAppIds(java.util.List<java.lang.String> defaultAppIds) {
    this.defaultAppIds = defaultAppIds;
    return this;
  }

  /**
   * The ETag of the list.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * The ETag of the list.
   * @param etag etag or {@code null} for none
   */
  public AppList setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The list of apps.
   * @return value or {@code null} for none
   */
  public java.util.List<App> getItems() {
    return items;
  }

  /**
   * The list of apps.
   * @param items items or {@code null} for none
   */
  public AppList setItems(java.util.List<App> items) {
    this.items = items;
    return this;
  }

  /**
   * This is always drive#appList.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#appList.
   * @param kind kind or {@code null} for none
   */
  public AppList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A link back to this list.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * A link back to this list.
   * @param selfLink selfLink or {@code null} for none
   */
  public AppList setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public AppList set(String fieldName, Object value) {
    return (AppList) super.set(fieldName, value);
  }

  @Override
  public AppList clone() {
    return (AppList) super.clone();
  }

}
