/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 2016-05-04 15:59:39 UTC)
 * on 2016-05-19 at 17:56:36 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A reference to a file's parent.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ParentReference extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the parent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Whether or not the parent is the root folder.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isRoot;

  /**
   * This is always drive#parentReference.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * A link to the parent.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parentLink;

  /**
   * A link back to this reference.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The ID of the parent.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * The ID of the parent.
   * @param id id or {@code null} for none
   */
  public ParentReference setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Whether or not the parent is the root folder.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsRoot() {
    return isRoot;
  }

  /**
   * Whether or not the parent is the root folder.
   * @param isRoot isRoot or {@code null} for none
   */
  public ParentReference setIsRoot(java.lang.Boolean isRoot) {
    this.isRoot = isRoot;
    return this;
  }

  /**
   * This is always drive#parentReference.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#parentReference.
   * @param kind kind or {@code null} for none
   */
  public ParentReference setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * A link to the parent.
   * @return value or {@code null} for none
   */
  public java.lang.String getParentLink() {
    return parentLink;
  }

  /**
   * A link to the parent.
   * @param parentLink parentLink or {@code null} for none
   */
  public ParentReference setParentLink(java.lang.String parentLink) {
    this.parentLink = parentLink;
    return this;
  }

  /**
   * A link back to this reference.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * A link back to this reference.
   * @param selfLink selfLink or {@code null} for none
   */
  public ParentReference setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public ParentReference set(String fieldName, Object value) {
    return (ParentReference) super.set(fieldName, value);
  }

  @Override
  public ParentReference clone() {
    return (ParentReference) super.clone();
  }

}
