/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A comment on a file in Google Drive. Some resource methods (such as `comments.update`) require a
 * `commentId`. Use the `comments.list` method to retrieve the ID for a comment in a file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Comment extends com.google.api.client.json.GenericJson {

  /**
   * A region of the document represented as a JSON string. For details on defining anchor
   * properties, refer to [Add comments and
   * replies](https://developers.google.com/drive/api/v2/manage-comments).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String anchor;

  /**
   * Output only. The author of the comment. The author's email address and permission ID will not
   * be populated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User author;

  /**
   * Output only. The ID of the comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String commentId;

  /**
   * The plain text content used to create this comment. This is not HTML safe and should only be
   * used as a starting point to make edits to a comment's content.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String content;

  /**
   * The context of the file which is being commented on.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Context context;

  /**
   * The date when this comment was first created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime createdDate;

  /**
   * Output only. Whether this comment has been deleted. If a comment has been deleted the content
   * will be cleared and this will only represent a comment that once existed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean deleted;

  /**
   * Output only. The file which this comment is addressing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileId;

  /**
   * Output only. The title of the file which this comment is addressing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fileTitle;

  /**
   * Output only. HTML formatted content for this comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String htmlContent;

  /**
   * Output only. This is always `drive#comment`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The date when this comment or any of its replies were last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime modifiedDate;

  /**
   * Output only. Replies to this post.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<CommentReply> replies;

  /**
   * Output only. A link back to this comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * Output only. The status of this comment. Status can be changed by posting a reply to a comment
   * with the desired status. * `open` - The comment is still open. * `resolved` - The comment has
   * been resolved by one of its replies.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * A region of the document represented as a JSON string. For details on defining anchor
   * properties, refer to [Add comments and
   * replies](https://developers.google.com/drive/api/v2/manage-comments).
   * @return value or {@code null} for none
   */
  public java.lang.String getAnchor() {
    return anchor;
  }

  /**
   * A region of the document represented as a JSON string. For details on defining anchor
   * properties, refer to [Add comments and
   * replies](https://developers.google.com/drive/api/v2/manage-comments).
   * @param anchor anchor or {@code null} for none
   */
  public Comment setAnchor(java.lang.String anchor) {
    this.anchor = anchor;
    return this;
  }

  /**
   * Output only. The author of the comment. The author's email address and permission ID will not
   * be populated.
   * @return value or {@code null} for none
   */
  public User getAuthor() {
    return author;
  }

  /**
   * Output only. The author of the comment. The author's email address and permission ID will not
   * be populated.
   * @param author author or {@code null} for none
   */
  public Comment setAuthor(User author) {
    this.author = author;
    return this;
  }

  /**
   * Output only. The ID of the comment.
   * @return value or {@code null} for none
   */
  public java.lang.String getCommentId() {
    return commentId;
  }

  /**
   * Output only. The ID of the comment.
   * @param commentId commentId or {@code null} for none
   */
  public Comment setCommentId(java.lang.String commentId) {
    this.commentId = commentId;
    return this;
  }

  /**
   * The plain text content used to create this comment. This is not HTML safe and should only be
   * used as a starting point to make edits to a comment's content.
   * @return value or {@code null} for none
   */
  public java.lang.String getContent() {
    return content;
  }

  /**
   * The plain text content used to create this comment. This is not HTML safe and should only be
   * used as a starting point to make edits to a comment's content.
   * @param content content or {@code null} for none
   */
  public Comment setContent(java.lang.String content) {
    this.content = content;
    return this;
  }

  /**
   * The context of the file which is being commented on.
   * @return value or {@code null} for none
   */
  public Context getContext() {
    return context;
  }

  /**
   * The context of the file which is being commented on.
   * @param context context or {@code null} for none
   */
  public Comment setContext(Context context) {
    this.context = context;
    return this;
  }

  /**
   * The date when this comment was first created.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreatedDate() {
    return createdDate;
  }

  /**
   * The date when this comment was first created.
   * @param createdDate createdDate or {@code null} for none
   */
  public Comment setCreatedDate(com.google.api.client.util.DateTime createdDate) {
    this.createdDate = createdDate;
    return this;
  }

  /**
   * Output only. Whether this comment has been deleted. If a comment has been deleted the content
   * will be cleared and this will only represent a comment that once existed.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDeleted() {
    return deleted;
  }

  /**
   * Output only. Whether this comment has been deleted. If a comment has been deleted the content
   * will be cleared and this will only represent a comment that once existed.
   * @param deleted deleted or {@code null} for none
   */
  public Comment setDeleted(java.lang.Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

  /**
   * Output only. The file which this comment is addressing.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileId() {
    return fileId;
  }

  /**
   * Output only. The file which this comment is addressing.
   * @param fileId fileId or {@code null} for none
   */
  public Comment setFileId(java.lang.String fileId) {
    this.fileId = fileId;
    return this;
  }

  /**
   * Output only. The title of the file which this comment is addressing.
   * @return value or {@code null} for none
   */
  public java.lang.String getFileTitle() {
    return fileTitle;
  }

  /**
   * Output only. The title of the file which this comment is addressing.
   * @param fileTitle fileTitle or {@code null} for none
   */
  public Comment setFileTitle(java.lang.String fileTitle) {
    this.fileTitle = fileTitle;
    return this;
  }

  /**
   * Output only. HTML formatted content for this comment.
   * @return value or {@code null} for none
   */
  public java.lang.String getHtmlContent() {
    return htmlContent;
  }

  /**
   * Output only. HTML formatted content for this comment.
   * @param htmlContent htmlContent or {@code null} for none
   */
  public Comment setHtmlContent(java.lang.String htmlContent) {
    this.htmlContent = htmlContent;
    return this;
  }

  /**
   * Output only. This is always `drive#comment`.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Output only. This is always `drive#comment`.
   * @param kind kind or {@code null} for none
   */
  public Comment setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The date when this comment or any of its replies were last modified.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getModifiedDate() {
    return modifiedDate;
  }

  /**
   * The date when this comment or any of its replies were last modified.
   * @param modifiedDate modifiedDate or {@code null} for none
   */
  public Comment setModifiedDate(com.google.api.client.util.DateTime modifiedDate) {
    this.modifiedDate = modifiedDate;
    return this;
  }

  /**
   * Output only. Replies to this post.
   * @return value or {@code null} for none
   */
  public java.util.List<CommentReply> getReplies() {
    return replies;
  }

  /**
   * Output only. Replies to this post.
   * @param replies replies or {@code null} for none
   */
  public Comment setReplies(java.util.List<CommentReply> replies) {
    this.replies = replies;
    return this;
  }

  /**
   * Output only. A link back to this comment.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * Output only. A link back to this comment.
   * @param selfLink selfLink or {@code null} for none
   */
  public Comment setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  /**
   * Output only. The status of this comment. Status can be changed by posting a reply to a comment
   * with the desired status. * `open` - The comment is still open. * `resolved` - The comment has
   * been resolved by one of its replies.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Output only. The status of this comment. Status can be changed by posting a reply to a comment
   * with the desired status. * `open` - The comment is still open. * `resolved` - The comment has
   * been resolved by one of its replies.
   * @param status status or {@code null} for none
   */
  public Comment setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public Comment set(String fieldName, Object value) {
    return (Comment) super.set(fieldName, value);
  }

  @Override
  public Comment clone() {
    return (Comment) super.clone();
  }

  /**
   * The context of the file which is being commented on.
   */
  public static final class Context extends com.google.api.client.json.GenericJson {

    /**
     * The MIME type of the context snippet.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * Data representation of the segment of the file being commented on. In the case of a text file
     * for example, this would be the actual text that the comment is about.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String value;

    /**
     * The MIME type of the context snippet.
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * The MIME type of the context snippet.
     * @param type type or {@code null} for none
     */
    public Context setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    /**
     * Data representation of the segment of the file being commented on. In the case of a text file
     * for example, this would be the actual text that the comment is about.
     * @return value or {@code null} for none
     */
    public java.lang.String getValue() {
      return value;
    }

    /**
     * Data representation of the segment of the file being commented on. In the case of a text file
     * for example, this would be the actual text that the comment is about.
     * @param value value or {@code null} for none
     */
    public Context setValue(java.lang.String value) {
      this.value = value;
      return this;
    }

    @Override
    public Context set(String fieldName, Object value) {
      return (Context) super.set(fieldName, value);
    }

    @Override
    public Context clone() {
      return (Context) super.clone();
    }

  }

}
