/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A restriction for accessing the content of the file.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ContentRestriction extends com.google.api.client.json.GenericJson {

  /**
   * Whether the content of the file is read-only. If a file is read-only, a new revision of the
   * file may not be added, comments may not be added or modified, and the title of the file may not
   * be modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean readOnly;

  /**
   * Reason for why the content of the file is restricted. This is only mutable on requests that
   * also set readOnly=true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String reason;

  /**
   * The user who set the content restriction. Only populated if readOnly is true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User restrictingUser;

  /**
   * The time at which the content restriction was set (formatted RFC 3339 timestamp). Only
   * populated if readOnly is true.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime restrictionDate;

  /**
   * The type of the content restriction. Currently the only possible value is
   * globalContentRestriction.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Whether the content of the file is read-only. If a file is read-only, a new revision of the
   * file may not be added, comments may not be added or modified, and the title of the file may not
   * be modified.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getReadOnly() {
    return readOnly;
  }

  /**
   * Whether the content of the file is read-only. If a file is read-only, a new revision of the
   * file may not be added, comments may not be added or modified, and the title of the file may not
   * be modified.
   * @param readOnly readOnly or {@code null} for none
   */
  public ContentRestriction setReadOnly(java.lang.Boolean readOnly) {
    this.readOnly = readOnly;
    return this;
  }

  /**
   * Reason for why the content of the file is restricted. This is only mutable on requests that
   * also set readOnly=true.
   * @return value or {@code null} for none
   */
  public java.lang.String getReason() {
    return reason;
  }

  /**
   * Reason for why the content of the file is restricted. This is only mutable on requests that
   * also set readOnly=true.
   * @param reason reason or {@code null} for none
   */
  public ContentRestriction setReason(java.lang.String reason) {
    this.reason = reason;
    return this;
  }

  /**
   * The user who set the content restriction. Only populated if readOnly is true.
   * @return value or {@code null} for none
   */
  public User getRestrictingUser() {
    return restrictingUser;
  }

  /**
   * The user who set the content restriction. Only populated if readOnly is true.
   * @param restrictingUser restrictingUser or {@code null} for none
   */
  public ContentRestriction setRestrictingUser(User restrictingUser) {
    this.restrictingUser = restrictingUser;
    return this;
  }

  /**
   * The time at which the content restriction was set (formatted RFC 3339 timestamp). Only
   * populated if readOnly is true.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getRestrictionDate() {
    return restrictionDate;
  }

  /**
   * The time at which the content restriction was set (formatted RFC 3339 timestamp). Only
   * populated if readOnly is true.
   * @param restrictionDate restrictionDate or {@code null} for none
   */
  public ContentRestriction setRestrictionDate(com.google.api.client.util.DateTime restrictionDate) {
    this.restrictionDate = restrictionDate;
    return this;
  }

  /**
   * The type of the content restriction. Currently the only possible value is
   * globalContentRestriction.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of the content restriction. Currently the only possible value is
   * globalContentRestriction.
   * @param type type or {@code null} for none
   */
  public ContentRestriction setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public ContentRestriction set(String fieldName, Object value) {
    return (ContentRestriction) super.set(fieldName, value);
  }

  @Override
  public ContentRestriction clone() {
    return (ContentRestriction) super.clone();
  }

}
