/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2015-03-26 20:30:19 UTC)
 * on 2015-04-01 at 23:41:13 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A JSON representation of a reply to a comment on a file in Google Drive.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-http-java-client/wiki/JSON">http://code.google.com/p/google-http-java-client/wiki/JSON</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CommentReply extends com.google.api.client.json.GenericJson {

  /**
   * The user who wrote this reply.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private User author;

  /**
   * The plain text content used to create this reply. This is not HTML safe and should only be used
   * as a starting point to make edits to a reply's content. This field is required on inserts if no
   * verb is specified (resolve/reopen).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String content;

  /**
   * The date when this reply was first created.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime createdDate;

  /**
   * Whether this reply has been deleted. If a reply has been deleted the content will be cleared
   * and this will only represent a reply that once existed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean deleted;

  /**
   * HTML formatted content for this reply.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String htmlContent;

  /**
   * This is always drive#commentReply.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The date when this reply was last modified.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private com.google.api.client.util.DateTime modifiedDate;

  /**
   * The ID of the reply.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String replyId;

  /**
   * The action this reply performed to the parent comment. When creating a new reply this is the
   * action to be perform to the parent comment. Possible values are: - "resolve" - To resolve a
   * comment.  - "reopen" - To reopen (un-resolve) a comment.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String verb;

  /**
   * The user who wrote this reply.
   * @return value or {@code null} for none
   */
  public User getAuthor() {
    return author;
  }

  /**
   * The user who wrote this reply.
   * @param author author or {@code null} for none
   */
  public CommentReply setAuthor(User author) {
    this.author = author;
    return this;
  }

  /**
   * The plain text content used to create this reply. This is not HTML safe and should only be used
   * as a starting point to make edits to a reply's content. This field is required on inserts if no
   * verb is specified (resolve/reopen).
   * @return value or {@code null} for none
   */
  public java.lang.String getContent() {
    return content;
  }

  /**
   * The plain text content used to create this reply. This is not HTML safe and should only be used
   * as a starting point to make edits to a reply's content. This field is required on inserts if no
   * verb is specified (resolve/reopen).
   * @param content content or {@code null} for none
   */
  public CommentReply setContent(java.lang.String content) {
    this.content = content;
    return this;
  }

  /**
   * The date when this reply was first created.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getCreatedDate() {
    return createdDate;
  }

  /**
   * The date when this reply was first created.
   * @param createdDate createdDate or {@code null} for none
   */
  public CommentReply setCreatedDate(com.google.api.client.util.DateTime createdDate) {
    this.createdDate = createdDate;
    return this;
  }

  /**
   * Whether this reply has been deleted. If a reply has been deleted the content will be cleared
   * and this will only represent a reply that once existed.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDeleted() {
    return deleted;
  }

  /**
   * Whether this reply has been deleted. If a reply has been deleted the content will be cleared
   * and this will only represent a reply that once existed.
   * @param deleted deleted or {@code null} for none
   */
  public CommentReply setDeleted(java.lang.Boolean deleted) {
    this.deleted = deleted;
    return this;
  }

  /**
   * HTML formatted content for this reply.
   * @return value or {@code null} for none
   */
  public java.lang.String getHtmlContent() {
    return htmlContent;
  }

  /**
   * HTML formatted content for this reply.
   * @param htmlContent htmlContent or {@code null} for none
   */
  public CommentReply setHtmlContent(java.lang.String htmlContent) {
    this.htmlContent = htmlContent;
    return this;
  }

  /**
   * This is always drive#commentReply.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#commentReply.
   * @param kind kind or {@code null} for none
   */
  public CommentReply setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The date when this reply was last modified.
   * @return value or {@code null} for none
   */
  public com.google.api.client.util.DateTime getModifiedDate() {
    return modifiedDate;
  }

  /**
   * The date when this reply was last modified.
   * @param modifiedDate modifiedDate or {@code null} for none
   */
  public CommentReply setModifiedDate(com.google.api.client.util.DateTime modifiedDate) {
    this.modifiedDate = modifiedDate;
    return this;
  }

  /**
   * The ID of the reply.
   * @return value or {@code null} for none
   */
  public java.lang.String getReplyId() {
    return replyId;
  }

  /**
   * The ID of the reply.
   * @param replyId replyId or {@code null} for none
   */
  public CommentReply setReplyId(java.lang.String replyId) {
    this.replyId = replyId;
    return this;
  }

  /**
   * The action this reply performed to the parent comment. When creating a new reply this is the
   * action to be perform to the parent comment. Possible values are: - "resolve" - To resolve a
   * comment.  - "reopen" - To reopen (un-resolve) a comment.
   * @return value or {@code null} for none
   */
  public java.lang.String getVerb() {
    return verb;
  }

  /**
   * The action this reply performed to the parent comment. When creating a new reply this is the
   * action to be perform to the parent comment. Possible values are: - "resolve" - To resolve a
   * comment.  - "reopen" - To reopen (un-resolve) a comment.
   * @param verb verb or {@code null} for none
   */
  public CommentReply setVerb(java.lang.String verb) {
    this.verb = verb;
    return this;
  }

  @Override
  public CommentReply set(String fieldName, Object value) {
    return (CommentReply) super.set(fieldName, value);
  }

  @Override
  public CommentReply clone() {
    return (CommentReply) super.clone();
  }

}
