/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://code.google.com/p/google-apis-client-generator/
 * (build: 2014-07-09 17:08:39 UTC)
 * on 2014-07-16 at 23:25:53 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A list of changes for a user.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Drive API. For a detailed explanation see:
 * <a href="http://code.google.com/p/google-api-java-client/wiki/Json">http://code.google.com/p/google-api-java-client/wiki/Json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ChangeList extends com.google.api.client.json.GenericJson {

  /**
   * The ETag of the list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * The actual list of changes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Change> items;

  /**
   * This is always drive#changeList.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The current largest change ID.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long largestChangeId;

  /**
   * A link to the next page of changes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextLink;

  /**
   * The page token for the next page of changes.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * A link back to this list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfLink;

  /**
   * The ETag of the list.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * The ETag of the list.
   * @param etag etag or {@code null} for none
   */
  public ChangeList setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * The actual list of changes.
   * @return value or {@code null} for none
   */
  public java.util.List<Change> getItems() {
    return items;
  }

  /**
   * The actual list of changes.
   * @param items items or {@code null} for none
   */
  public ChangeList setItems(java.util.List<Change> items) {
    this.items = items;
    return this;
  }

  /**
   * This is always drive#changeList.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * This is always drive#changeList.
   * @param kind kind or {@code null} for none
   */
  public ChangeList setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The current largest change ID.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLargestChangeId() {
    return largestChangeId;
  }

  /**
   * The current largest change ID.
   * @param largestChangeId largestChangeId or {@code null} for none
   */
  public ChangeList setLargestChangeId(java.lang.Long largestChangeId) {
    this.largestChangeId = largestChangeId;
    return this;
  }

  /**
   * A link to the next page of changes.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextLink() {
    return nextLink;
  }

  /**
   * A link to the next page of changes.
   * @param nextLink nextLink or {@code null} for none
   */
  public ChangeList setNextLink(java.lang.String nextLink) {
    this.nextLink = nextLink;
    return this;
  }

  /**
   * The page token for the next page of changes.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * The page token for the next page of changes.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ChangeList setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * A link back to this list.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfLink() {
    return selfLink;
  }

  /**
   * A link back to this list.
   * @param selfLink selfLink or {@code null} for none
   */
  public ChangeList setSelfLink(java.lang.String selfLink) {
    this.selfLink = selfLink;
    return this;
  }

  @Override
  public ChangeList set(String fieldName, Object value) {
    return (ChangeList) super.set(fieldName, value);
  }

  @Override
  public ChangeList clone() {
    return (ChangeList) super.clone();
  }

}
